/*
 * @(#)RidEnvAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid env action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/22
 */
package jp.co.nri.rid.action;

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JCheckBox;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import java.util.Enumeration;
import java.util.Vector;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.ui.UFrame;
import jp.co.iti.fagot.ui.UDialog;

import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;

import jp.co.nri.Rid;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.doc.AccessCounts;

import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.environment.EnvironmentDialog;

/**
 * Rid ݒnANV`
 */
public class RidEnvAction extends ZAction {
	/**
	 * B̃RXgN^łB
	 * @param app AvP[V
	 * @param szAction ANV
	 */
	public RidEnvAction(IZApp app,String szAction) {
    super(app,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {
	if ( getActionName().equals( SET_ENV ) ) {
		// ݒ
		try {
			EnvironmentDialog env = new EnvironmentDialog();
			env.EnvDialog();
		} catch ( Throwable t ) {
		}

		
		// ANeBupl̍ĕ`
		RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);

	} else if ( getActionName().equals( SET_LOG ) ) {
		showAccessLogDialog();
		// ĕ`́AapplyAccessLogDialog()ŌĂяoB
	}
	}

	/**
	 * UIXV
	 */
	public void update() {
	}

	//## _CAO ###################################################
	/**
	 * ANZXO_CAO̕\
	 * @return boolean OK{^ꂽꍇ true
	 */
	protected boolean showAccessLogDialog() {
	ZResource       res = getApp().getResource();
	RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
	DocElement      top = doc.getTopZone();

	mDialog = new UDialog(getApp(),"accesslog");

	// plCAEg̍쐬
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints cns = new GridBagConstraints();
	JPanel panel = new JPanel();
	panel.setLayout( gridbag );

	//-----------------------------------------------------------------
	// PsځF\`
	cns.fill = GridBagConstraints.BOTH;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.accesslog.type")),cns);

	JPanel radioPanel = new JPanel();
	mTypeGroup = new ButtonGroup();
	// 
	mSerial = new JRadioButton(res.getString("msg.accesslog.type.serial")) ;
	mTypeGroup.add( mSerial );
	radioPanel.add( mSerial );
	// 
	mParallel = new JRadioButton(res.getString("msg.accesslog.type.parallel")) ;
	mTypeGroup.add( mParallel );
	radioPanel.add( mParallel );
	// 
	mJoin = new JRadioButton(res.getString("msg.accesslog.type.join")) ;
	mTypeGroup.add( mJoin );
	radioPanel.add( mJoin );

	// l̐ݒ
	String szType = top.getAttribute("AccessLogType") ;
	if ( szType.equals("join") ) {
		mJoin.setSelected(true);
	} else if ( szType.equals("parallel") ) {
		mParallel.setSelected(true);
	} else {
		mSerial.setSelected(true);
	}

	// WI{^plɓ\t
	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	panel.add(radioPanel,cns);

	//-----------------------------------------------------------------
	// QsځFf[^n
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.accesslog.data")),cns);

	JPanel dataPanel = new JPanel();
	mChecks = new Vector();
	// f[^n擾邽߂ɁAy[WQAccessLogs擾
	// gbvy[W̎擾
	String szPanelId = "Map.Site" ;
	AccessCounts acc = null;
	Vector pages = doc.getTopZone().getPages(true);
	Enumeration elm = pages.elements();
	while ( elm.hasMoreElements() ) {
		RidElementPage page = (RidElementPage)elm.nextElement();
		if ( page.getMapParent(szPanelId,"Auto").equals("root") ) {
			AccessCounts acc2 = page.getMaxAccessCount(szPanelId,null);
			if ( acc == null ) {
				acc = acc2 ;
			} else {
				acc.margeMax( acc2 );
			}
		}
	}

	if ( acc != null ) {
		// f[^ň擾
		int nCount = acc.getArrayCount();
		String szLogList = top.getAttribute("AccessLogList");
		for ( int nAt=0 ; nAt<nCount ; nAt++ ) {
			JCheckBox check = new JCheckBox();
			check.setText( Integer.toString(nAt+1) ) ;
			if ( szLogList.length()<=nAt || szLogList.charAt(nAt)!='n' ) {
				check.setSelected( true ) ;
			}
			mChecks.add( check );
			dataPanel.add( check );
		}
	} else {
		dataPanel.add(new JLabel("no data"));
	}

	// f[^nplɓ\t
	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	panel.add(dataPanel,cns);

	//-----------------------------------------------------------------
	// RsځF{^
	JPanel btnPanel = new JPanel();
	Action act  = null ;

	// OK{^
	act = new AbstractAction("OK") {
	    public void actionPerformed(ActionEvent e) { mDialog.onOK(); }
	};
	JButton okBtn = new JButton(act);
	okBtn.setText("OK");
	btnPanel.add( okBtn );

	// Cancel{^
	act = new AbstractAction("Cancel") {
	    public void actionPerformed(ActionEvent e) { mDialog.onCancel(); }
	};
	JButton cancelBtn = new JButton(act);
	cancelBtn.setText("Cancel");
	btnPanel.add( cancelBtn );

	// Cancel{^
	act = new AbstractAction("Apply") {
	    public void actionPerformed(ActionEvent e) { applyAccessLogDialog(); }
	};
	JButton applyBtn = new JButton(act);
	applyBtn.setText("Apply");
	btnPanel.add( applyBtn );

	cns.weightx = 0.0;
	panel.add(btnPanel,cns);

	// ftHg{^̐ݒ
	mDialog.getRootPane().setDefaultButton(okBtn);

	// _CAO̕\
	mDialog.setComponent( panel,false );
	mDialog.setControlPanel( "none" );
//	mDialog.pack();
	
	doc.beginTransaction();
	boolean bRet = mDialog.doModal();
	if ( bRet ) {
		applyAccessLogDialog();
	}
	doc.commit();
	return bRet;
	}

	/**
	 * ANZXO_CAO̓Kp
	 */
	protected void applyAccessLogDialog() {
	RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
	DocElement      top = doc.getTopZone();

	// ^Cv̐ݒ
	String szType = "serial";
	if ( mJoin.isSelected() ) {
		szType = "join";
	} else if ( mParallel.isSelected() ) {
		szType = "parallel";
	}
	top.setAttribute("AccessLogType",szType);

	// f[^n̐ݒ
	String szLogList = "";
	Enumeration elm = mChecks.elements();
	while( elm.hasMoreElements() ) {
		JCheckBox check = (JCheckBox)elm.nextElement();
		szLogList += (check.isSelected())?'y':'n' ;
	}
	top.setAttribute("AccessLogList",szLogList);

	doc.requestUpdateAccessCount();

	// ANeBupl̍ĕ`
	RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
	}


	//## Agr[g ###############################################
    /**
     * ANVFݒ
     */
	final static public String SET_ENV			= "set_env" ;

    /**
     * ANVFANZXOݒ
     */
	final static public String SET_LOG			= "set_log" ;

    /**
     * ANZXOp_CAO
     */
	protected UDialog mDialog = null;

    /**
     * ANZXOpWI{^F
     */
	protected JRadioButton mSerial    = null;

    /**
     * ANZXOpWI{^F
     */
	protected JRadioButton mParallel  = null;

    /**
     * ANZXOpWI{^F
     */
	protected JRadioButton mJoin      = null;

    /**
     * ANZXOp{^O[v
     */
	protected ButtonGroup  mTypeGroup = null;

    /**
     * ANZXOp`FbN{bNX
     */
	protected Vector mChecks = null;
}
