/*
 * @(#)RidZoneTitlePane.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Zone Title Pane
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid;

import java.awt.Dimension;
import java.awt.FlowLayout;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;

import javax.swing.JComponent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidElementZone;
/**
 * Rid Zone^uV[g ^Cgpl
 */
public class RidZoneTitlePane extends JPanel {

	/**
	 * RXgN^
	 */
	public RidZoneTitlePane(){
	setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
	add( new JButton("dummy") );
	}

	//## I[oCh #################################################
	/**
	 * R|[lgɍœKȃTCY̎擾
	 */
	public Dimension getPreferredSize() {
	Dimension dim = super.getPreferredSize();
	dim.height = 25;
	return dim;
	}

	//## UI ###########################################################
	/**
	 * ʍXV
	 */
	public void restract() {
//	ZDebug.trace();
	removeAll();
	setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));

	// TCghLg̃[gIꂽ][ɐݒ
	DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
	if ( doc == null ) {
		// NɃt@CJLZꍇB
		return ;
	}
	DocElement root = (DocElement)doc.getRootElement(Rid.PANEL_ZONE);
	String szFile = root.getAttribute("File");

	// top][
	RidElementZone top = ((RidDocument)doc).getTopZone();
	if ( top != root ) {

		String[] szPath = ZString.tokenize( szFile, "/" );
//		ZDebug.trace("length;"+szPath.length);
		for ( int nIndex = 0 ; nIndex< szPath.length ; nIndex++ ) {
			JComponent cmp = createZoneInfo( top );
			add( cmp );

//			ZDebug.trace("find:"+szPath[nIndex]);
			top = (RidElementZone)top.findChildElement(".ZoneUnit","Name="+szPath[nIndex]);
/*			if ( top2 == null ) {
				ZDebug.trace(top.getAttribute("Name")+"̎q"+szPath[nIndex]+"܂");
				org.w3c.dom.NodeList list = top.getChildNodes();
				for ( int nn=0 ; nn<list.getLength() ; nn++ ) {
					if ( list.item(nn) instanceof DocElement ) {
						DocElement cc = (DocElement)list.item(nn);
						ZDebug.trace("    "+cc.getTagName()+":Name="+cc.getAttribute("Name"));
					}
				}
			}
			top = top2;
*/
		}
	}

	// ŌɎǉ
	JComponent topcmp = createMyZoneInfo( top );
	add( topcmp );

	validate();
	repaint();
	}

	/**
	 * ̃][̃x
	 * @param elm root][
	 */
	public JComponent createMyZoneInfo(DocElement elm) {
	JLabel label = new JLabel(elm.getAttribute("Name"));
	return label;
	}

	/**
	 * Wv{^̍쐬
	 * @param elm Wṽ][
	 */
	public JComponent createZoneInfo(RidElementZone elm) {
	JButton btn = new JButton(elm.getAttribute("Name"));
	RZoneTitleBtnAction act = new RZoneTitleBtnAction(elm);
	btn.addActionListener( act ) ;
	return btn;
	}

	//## ANVXi[ ###########################################
	/**
	 * Wv{^̃ANVXi[
	 */
	protected class RZoneTitleBtnAction implements ActionListener {
	/**
	 * RXgN^
	 * @param zone Wṽ][
	 */
	public RZoneTitleBtnAction( RidElementZone zone ) {
	mZone = zone;
	}

	/**
	 * ANV
	 */
	public void actionPerformed(ActionEvent e) {
	// TCghLg̃[gIꂽ][ɐݒ
	DocPane editor = (DocPane)ZInstance.map().get(Rid.PANEL_ZONE);
	mZone.changeRoot( editor );
	}

	/**
	 * Wṽ][
	 */
	protected RidElementZone mZone;
	}
	//## Agr[g################################################
}
