/*
 * @(#)RidMapTitlePane.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Map Title Pane
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid;

import java.awt.Dimension;
import java.awt.FlowLayout;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementPage;
/**
 * Rid Map^uV[g ^Cgpl
 */
public class RidMapTitlePane extends JPanel {

	/**
	 * RXgN^
	 */
	public RidMapTitlePane(){
	setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
	add( new JButton("dummy") );
	}

	//## I[oCh #################################################
	/**
	 * R|[lgɍœKȃTCY̎擾
	 */
	public Dimension getPreferredSize() {
	Dimension dim = super.getPreferredSize();
	dim.height = 25;
	return dim;
	}

	//## UI ###########################################################
	/**
	 * ʍXV
	 */
	public void restract() {
//	ZDebug.printStack();
	removeAll();
//	setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
	setLayout( new BoxLayout( this, BoxLayout.X_AXIS ) );

	// }bvpl擾
	DocPane editor = (DocPane)ZInstance.map().get( Rid.PANEL_MAP );

	//
	RidDocumentSite doc = (RidDocumentSite)editor.getDocument();
	RidElementPage  top = doc.getTopPage(editor.getPanelId());

	if ( top != null ) {
		RidElementPage defaultTop = doc.getDefaultTopPage(editor.getPanelId());
		// ݂̒SftHggbvł΁AMyPage
		if ( top == defaultTop ) {
			add( createMyPageInfo( top ) );
		} else {
			add( createPageInfo( defaultTop ) );
			add( createMyPageInfo( top ) );
		}
	}

	// ]̑}
	add( Box.createVerticalStrut(5) );

	// ViIx
	add( new JLabel("Scenario:") );

	// ViIx
	JComboBox combo = new JComboBox() {
		// R|[lgɍœKȕ̍ŏl200ɐݒ
		public Dimension getPreferredSize() {
		Dimension dim = super.getPreferredSize();
		dim.width = Math.max(dim.width,100);
		return dim;
		}
	};

	// ViIꗗ̓o^
	combo.addItem( "" );
	XElementNS scene = (XElementNS)((XElementNS)doc.getDocumentElement()).findChildElement(".Scenario",null);
	Vector vec = scene.findChildElements("ScenarioUnit");
//	ZDebug.trace("ScenarioCount:"+vec.size());
	Enumeration elm = vec.elements();
	while ( elm.hasMoreElements() ) {
		XElementNS scenario = (XElementNS)elm.nextElement();
		String szName = scenario.getAttribute("Name");
//		ZDebug.trace("addItem:"+szName);
		combo.addItem( szName );
	}
	add( combo );

	// JgViȊI
	String szName = doc.getScenarioName();
//	ZDebug.trace("I:"+szName);
	combo.setSelectedItem( szName );

	// Xi[̓o^
	RMapScenarioComboAction act = new RMapScenarioComboAction();
	combo.addActionListener( act );

	validate();
	repaint();
	}

	/**
	 * ̃][̃x
	 * @param elm root][
	 */
	public JComponent createMyPageInfo(DocElement elm) {
	JLabel label = new JLabel(elm.getAttribute("Name"));
//	ZDebug.trace("Top:"+elm.getAttribute("Name"));
	return label;
	}

	/**
	 * Wv{^̍쐬
	 * @param elm Wṽy[W
	 */
	public JComponent createPageInfo(RidElementPage elm) {
	JButton btn = new JButton(elm.getAttribute("Name"));
	RMapTitleBtnAction act = new RMapTitleBtnAction(elm);
	btn.addActionListener( act ) ;
	return btn;
	}

	//## ANVXi[ ###########################################
	/**
	 * Wv{^̃ANVXi[
	 */
	protected class RMapTitleBtnAction implements ActionListener {
	/**
	 * RXgN^
	 * @param zone Wṽy[W
	 */
	public RMapTitleBtnAction( RidElementPage page ) {
	mPage = page;
	}

	/**
	 * ANV
	 */
	public void actionPerformed(ActionEvent e) {
	// TCghLg̃[gIꂽ][ɐݒ
	DocPane editor = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);
	mPage.changeTop( editor );
	}

	/**
	 * Wṽy[W
	 */
	protected RidElementPage mPage;
	}

	//## ANVXi[ ###########################################
	/**
	 * ViIR{{bNX̃ANVXi[
	 */
	protected class RMapScenarioComboAction implements ActionListener {
	/**
	 * RXgN^
	 * @param zone Wṽy[W
	 */
	public RMapScenarioComboAction() {
	}

	/**
	 * ANV
	 */
	public void actionPerformed(ActionEvent e) {
	// ViIύX
	DocPane editor = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);

	JComboBox combo = (JComboBox)e.getSource();
	String szName = (String)combo.getSelectedItem();
	ZDebug.trace("ViIIF"+szName);
	
	RidDocumentSite doc = (RidDocumentSite)editor.getDocument();
	doc.beginTransaction();
	doc.setScenarioName( szName );
	doc.commit();
	}
	}
	//## Agr[g################################################
}
