/*
 * @(#)RPanPanel.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Scaled Item draw Panel
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid;

import java.util.Vector;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.BorderLayout;

import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;

//import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FColor;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GOperationSelect;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.PTransform;

import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocUIAdapter;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.iti.fagot.ZApp;

import jp.co.nri.Rid;
/**
 * Pan Panel
 *
 * g}`悷邽߂ɁARDocument̃y[WA][𕡎ʂāA~jDrawPane쐬
 * pNX́A
 * RPanDrawPanel	:VDrawPane̔hNX
 * RPanMouseAdapter	:VMouseAdapter̔hNX
 *					 }EXړɂJ[\ύXȂ
 * GViewport		:GRectangle̔hNX
 *					 Rei킷BlueRect`悷
 * GViewportZoom	:GOperationSelect̔hNX
 *					 Vierport̊gk̑ŗp
 *
 */
public class RPanPanel extends JPanel {

	/**
     * RXgN^
	 */
	public RPanPanel() {
		// n}̒ǉ
		mPanel = new RPanDrawPanel();
		setLayout(new BorderLayout());
		add("Center",mPanel);
	}

	/**
     * č\z
	 */
	public void restract() {
	mPanel.updateGobs();
	// ppĺAقǏdvȉʂł͂ȂA
	// MapplƏLĂ̂ŁAMappl肠Ƃŕ`悷悤
	// x`悷
	repaint(2000);
	}

	//## Agr[g ###############################################
    /**
     * ppl
     */
	protected RPanDrawPanel	mPanel	= null;

	//## TuNXFppl #######################################
	/**
	 * ppl
	 */
	public class RPanDrawPanel extends DocPane {
	/**
	 * RXgN^
	 */
	public RPanDrawPanel() {
	super("pan");
	}

	//## č\z #######################################################
	/**
	 * č\z
	 */
	public void createGobs() {
	// Gob̏
	Vector gobs = GobManager.getElement(getPanelId());
	gobs.removeAllElements();

	// ANeBupl̎擾
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͕`悵Ȃ
		return;
	}

	DocPane panel = (DocPane)active;

	// ReiŜGob
	if ( panel != null ) {
		GRectangle grect = new GRectangle();
		Dimension dim = panel.getDocument().getLogicalSize();
		grect.setRect(new ZRectangle(0,0,dim.width,dim.height));
		grect.getStyle().setFillColor( new FColor( panel.getBackground() ));
		grect.getStyle().setStrokeColor( new FColor( Color.black ));
		gobs.add( grect );
//		rect.setSelectable(false);
//		rect.setSelect(false);

		// ANeBupl̃XPgGob𐶐
		gobs.addAll( panel.getDocument().createSkeltonGobs(panel.getPanelId()) );

		// r[|[gGob𐶐
		mViewPort = new GViewport();
		JViewport port = (JViewport)panel.getParent();
		Dimension vwdim = port.getSize();
		Point    ptTL = port.getViewPosition();
		ZRectangle rtport = new ZRectangle( ptTL.getX(),ptTL.getY(),
										(double)vwdim.width,(double)vwdim.height);

		PTransform trans = null;
		DocElement root = (DocElement)panel.getDocument().getRootElement(panel.getPanelId());
		if ( root != null ) {
			trans = root.getDisplayScaledTransform(panel.getPanelId());
		} else {
			trans = new PTransform(1,0,0,1,0,0);
		}
		Shape sh = trans.inverseTransform( rtport );

		mViewPort.setRect(new ZRectangle(sh.getBounds2D()));
		gobs.add(mViewPort);

		// Wϊ̐ݒ
		Dimension mydim = this.getSize();
		recalcTransform(mydim.width,mydim.height);

		// r[|[ĝ݂Iς݂ɐݒ
		mViewPort.setSelect(true);
//		updateCurrent();
	}
	}

	/**
	 * č\z
	 * @param width R|[lg̕
	 * @param height R|[lg̍
	 */
	public void recalcTransform(int width,int height) {
	// ANeBupl̎擾
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent cmp = (JComponent)ZInstance.map().get(szTitle);
	if ( !(cmp instanceof DocPane) ) {
		return ;
	}
	DocPane panel = (DocPane)cmp;

	if ( panel != null ) {
		Dimension dim = panel.getDocument().getLogicalSize();
		double inset = 5;
		// ǩvZ
		double dx = (width-inset*2)/dim.width;
		double dy = (height-inset*2)/dim.height;
		double dz = Math.min(dx,dy);
		// ItZbǧvZ
		double ox = (width-dim.width*dz)/2;
		double oy = (height-dim.height*dz)/2;

		DocElement root = (DocElement)getDocument().getRootElement(getPanelId());

		XElementNS elm = root.getChildElement(".ViewInfo."+getPanelId(),null);
		elm.setDoubleAttr("DisplayOffsetX",ox);
		elm.setDoubleAttr("DisplayOffsetY",oy);
		elm.setDoubleAttr("DisplayScale",dz);
	}
	}

	//## I[oCh #################################################
	/**
	 * UIA_v^̍쐬
	 * @return UIA_v^
	 */
	public DocUIAdapter createUIAdapter() {
	return new RPanMouseAdapter(this);
	}

	/*
	 * TCY̕ύX
	 * @param x R|[lgx
	 * @param y R|[lgy
	 * @param width R|[lg̕
	 * @param height R|[lg̍
	 */
	public void setBounds(int x,int y,int width,int height){
	recalcTransform(width,height);
	super.setBounds(x,y,width,height);
//	repaint();
	}

	//## ScrollableubN ###########################################
	/**
	 * R|[lgɍœKȃTCYԂ܂
	 */
	public Dimension getPreferredSize() {
	Dimension dim = new Dimension(50,50);
	return dim;
	}

	//## r[|[g #################################################
	/**
	 * r[|[gGOB̎擾
	 */
	public GRectangle getViewPortGob() {
	return mViewPort;
	}

	//## Agr[g ###############################################
	/**
	 * r[|[gGOB
	 */
	protected GRectangle mViewPort = null;
    }

	//## TuNXF}EXA_v^[ #################################
	/**
	 * }EXA_v^[
	 */
	public class RPanMouseAdapter extends DocUIAdapter {
	/**
	 * RXgN^
	 * @param container Rei
	 */
	public RPanMouseAdapter(DocPane container){
	super(container);
	}

	/**
	 * }EXhbOȂړ
	 * @param evt }EXCxg
	 */
	public void mouseDragged(MouseEvent evt){
	mEditor.getGridControler().setMoving( new ZPoint(evt.getPoint()),0 );
	mEditor.repaint();
	}

	/**
	 * ̎擾
	 * @param evt }EXCxg
	 */
	public GElement createOperation(MouseEvent evt){
	return null;
	}

	//## Cxg #####################################################
	/**
	 * {^down
	 * @param evt }EXCxg
	 */
	protected void OnLButtonDown( MouseEvent evt ) {
	mStartPoint = new ZPoint(evt.getPoint());
	mMoveMode = GobManager.getSelectedHitMode(mEditor,mStartPoint);
	if ( mMoveMode != GOperation.HANDON ) {
		GobManager.setCurrent(mEditor.getPanelId(),new GViewportZoom());
	} else {
		// ݑIGgɃqbĝŁAIĂGgJgɐݒ
		GobManager.updateCurrent(mEditor.getPanelId());
	}

	// ړJn
	mEditor.getGridControler().setMoveStart( mStartPoint,mMoveMode ) ;
	GobManager.moveStart(mEditor,mEditor.getGridControler());

	// ړ
	mEditor.getGridControler().setMoving( mStartPoint,0 ) ;

	// J[\̕ύXƍĕ`
	mEditor.setCursor(GOperation.getCursor(mMoveMode));
	mEditor.repaint();
	}

	/**
	 * {^up
	 * @param evt }EXCxg
	 */
	protected void OnLButtonUp( MouseEvent evt ) {
	super.OnLButtonUp(evt);
	}

	/**
	 * E{^down
	 * @param evt }EXCxg
	 */
	protected void OnRButtonDown( MouseEvent evt ) {
	// Ȃ
	}
	}

	//## TuNXFViewportIuWFNg #############################
	/**
	 * ViewporẗړIuWFNg
	 */
	public class GViewport extends GRectangle {
	/**
	 * RXgN^
	 */
	public GViewport(){
	super();

	getStyle().setStrokeColor( new FColor( Color.blue ));
	mSelect = true;
	}

	/**
	 * I̕ύX
	 */
	public boolean setSelect( boolean bSelect ) {
	return false;
	}

	//## ړ##########################################################
	/**
	 * ړ̏I
	 * @param grid ObhRg[
	 */
	public void moveEndGob( DocGridControler grid ) {
	ZRectangle rect = getMovingRectGob( grid ) ;
	ZPoint pt = rect.getCenter();

	// ANeBupl̎擾
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	DocPane panel  = (DocPane)ZInstance.map().get(szTitle);
//	panel.getDocument().beginTransaction();
	panel.setCenter(pt);
	// setCenterupdateCenterĂԂ悤C
//	panel.updateCenter(pt);
//	panel.getDocument().commit();
	panel.repaint();

	// g̍č\z
//	DocPane myPanel = grid.getEditor();
//	myPanel.updateGobs();
	}

	//## ʒu##########################################################
	/**
	 * vfɃqbg邩H
	 * @param pt _W
	 */
	public byte getHitModeGob(ZPoint pt) {
	byte mode = super.getHitModeGob(pt);
	if ( mode != GOperation.NONE ) {
//		ZDebug.trace("Hit:"+pt);
		mode = GOperation.HANDON;
	} else {
//		ZDebug.trace("@"+pt);
	}
	return mode;
	}

	//## `##########################################################
	/**
	 * I_͕`悵Ȃ
	 * @param g OtBbNX
	 */
	public void paintSelector(DocGraphics g) {
//	ZDebug.trace();
	}
	}

	//## TuNXFViewportZoomIuWFNg #########################
	/**
	 * Viewport̊gIuWFNg
	 */
	public class GViewportZoom extends GOperationSelect {
	/**
	 * RXgN^
	 */
	public GViewportZoom(){
	super();
	}

	//## ړ##########################################################
	/**
	 * ړ̏I
	 * @param grid ObhRg[
	 */
	public void moveEndGob( DocGridControler grid ) {
	ZRectangle rect = getMovingRectGob( grid ) ;

	// ANeBupl̎擾
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	DocPane panel  = (DocPane)ZInstance.map().get(szTitle);

	JViewport port = (JViewport)panel.getParent();
	Dimension dim  = port.getSize();
	double dx = dim.width/ Math.max(1,rect.getWidth());
	double dy = dim.height/Math.max(1,rect.getHeight());
	double dz = Math.min(dx,dy);

	// ő/ŏTCYւ̕␳
	if ( dz > 4.00 ) {
		dz = 4.00;
	} else if ( dz < 0.1 ) {
		dz = 0.1;
	}

	ZPoint center = rect.getCenter();

	// g嗦̕ύX
//	panel.getDocument().beginTransaction();

	// |[g̍ăCAEg
	DocElement element = (DocElement)panel.getDocument().getRootElement(panel.getPanelId());
	element.setDisplayScale( panel.getPanelId(), dz );
	port.doLayout();

	// r[|[g̈ړ
//	ZDebug.trace("Center:"+center.toString());
	panel.setCenter( center );
	// setCenterupdateCenterĂԂ悤C
//	panel.updateCenter(center);
	// O`^C~OƂTransfromςĂ̂ŁAnbVg܂킵łȂB
	// āAړƂ͂ƂȂACreateGobKv
	panel.updateGobs();
	panel.repaint();
//	panel.getDocument().commit();
	}

	//## Agr[g ###############################################
	}
}
