/*
 * @(#)ZString.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.util;

import java.text.DateFormat;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.StringTokenizer;
/**
 * FuStringNX͕𕪊܂B
 * ׂstatic\bh̃[eBeBł
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class ZString {

	/**
	 * B̃RXgN^łB
	 */
	public ZString() {
	}

	//## ؂ #######################################################
	/**
	 * 𕪊zɊi[܂B
	 *
	 * ؂蕶ꍇ́A1̋؂蕶ƂĔF܂B
	 * ؂蕶{擪|Ō}ɂꍇ́A؂蕶؂̂Ă܂B
	 *
	 * p[^̕ɂ莟̂悤ȒlԂ܂B
	 * param       : return
	 * ------------ ---------------------------
	 * null        : length 0
	 * delm        : length 0
	 * delm + Str  : length 1 , Str
	 * Str + delm  : length 1 , Str
	 *
	 * @param szInput 
	 * @param szDelim ؂蕶
	 */
	static public String[] tokenize(String szInput,String szDelim ) {
	if ( szInput == null ) {
		return new String[0];
	}
	Vector v = new Vector();
	StringTokenizer tokn = new StringTokenizer(szInput,szDelim);
	String szCmd[];

	while (tokn.hasMoreTokens())
	    v.addElement(tokn.nextToken());
	szCmd = new String[v.size()];
	for (int i = 0; i < szCmd.length; i++)
	    szCmd[i] = (String) v.elementAt(i);

	return(szCmd);
	}

	/**
	 * 𕪊zɊi[܂B
	 * @param szInput 
	 */
	static public String[] tokenize(String szInput) {
	return(	tokenize(szInput, " \t\n\r\f") );
	}

	/**
	 * ̍ŏ̋؂̂ݕzɊi[܂B
	 * @param szInput 
	 * @param szDelim ؂蕶
	 */
	static public String[] tokenfirst(String szInput,String szDelim ) {
	String szValues[] = tokenize( szInput, szDelim );
	String szRet[] = new String[2];
	if ( szValues.length > 1 ) {
		szRet[0] = szValues[0];
		szRet[1] = szInput.substring(szRet[0].length()+1);
	} else {
		szRet[0] = szInput;
		szRet[1] = null;
	}
	return szRet;
	}

	/**
	 * ̍ŏ̋؂̂ݕzɊi[܂B
	 * @param szInput 
	 */
	static public String[] tokenfirst(String szInput) {
	return(	tokenfirst(szInput, " \t\n\r\f") );
	}

	//## trim #########################################################
	/**
	 * ̍󔒂폜܂B
	 * @param szInput 
	 */
	static public String trimLeft( String szInput ) {
	int nIndex = 0;
	for ( nIndex=0; nIndex< szInput.length() ; nIndex++ ) {
		if ( !Character.isWhitespace( szInput.charAt(nIndex) ) ) {
			break;
		}
	}
	return ( szInput.substring( nIndex ) ) ;
	}

	/**
	 * ̉E󔒂폜܂B
	 * @param szInput 
	 */
	static public String trimRight( String szInput ) {
	int nIndex = 0;
	for ( nIndex=szInput.length()-1; nIndex >= 0 ; nIndex-- ) {
		if ( !Character.isWhitespace( szInput.charAt(nIndex) ) ) {
			break;
		}
	}
	return ( szInput.substring( 0, nIndex+1 ) ) ;
	}

	/**
	 * ̍E󔒂폜܂B
	 * @param szInput 
	 */
	static public String trim( String szInput ) {
	String left  = trimLeft(szInput);
	String right = trimRight(left);
	return right ;
	}

	//## utility ######################################################
	/**
	 * ̂Aꂩ̕܂܂Ă΁AʒuԂ܂
	 *
	 * @param szInput 
	 * @param szFind  
	 */
	static public int findOneOf( String szInput, String szFind ) {
	int nRet = -1;
	int nIndex = 0;
	for ( nIndex=0; nIndex< szFind.length() ; nIndex++ ) {
		char find = szFind.charAt(nIndex);
		int nAt = szInput.indexOf( find );
		if ( nAt >= 0 ) {
			if ( nRet == -1 ) {
				nRet = nAt;
			} else {
				nRet = Math.min(nRet,nAt);
			}
		}
	}
	return nRet ;
	}

	/**
	 * 𒊏o܂B
	 * @param szInput 
	 */
	static public String getString( String szInput ) {
	int nIndex = 0;
	for ( nIndex=0; nIndex< szInput.length() ; nIndex++ ) {
		if ( Character.isLetterOrDigit( szInput.charAt(nIndex) ) ) {
			continue;
		} else if ( szInput.charAt(nIndex) == '.' ) {
			continue;
		}
		break;
	}
	return ( szInput.substring( 0,nIndex ) ) ;
	}

	/**
	 * u܂B
	 * 񂪌ĂxłJԂĒu܂B
	 * @param szInput 
	 * @param szSrc   
	 * @param szDst   u
	 */
	static public String replace( String szInput,String szSrc, String szDst ) {
	int nIndex = 0;
	String szRet = new String();
	while ( (nIndex=szInput.indexOf(szSrc)) >=0 ) {
		if ( nIndex > 0 ) {
			szRet = szRet + szInput.substring(0,nIndex) ;
		}
		szRet = szRet + szDst ;
		if ( szInput.length() == (nIndex+szSrc.length()) ) {
			szInput = null;
			break ;
		}
		szInput = szInput.substring( nIndex+szSrc.length() );
	}
	if ( szInput != null ) {
		szRet = szRet + szInput ;
	}
	return ( szRet ) ;
	}

	/**
	 * ʕ𒊏o܂
	 * @param strs Q
	 */
	static public String getCommonStrings( Vector strs ) {
	Vector cmn = null;
	Enumeration elm = strs.elements();
//	ZDebug.trace();
	while ( elm.hasMoreElements() ) {
		String tmp = (String)elm.nextElement();
//		ZDebug.trace("    add:"+tmp);
		String[] str = tokenize(tmp);
		if ( cmn == null ) {
			// ŏ̃Gg͑Sēo^
			cmn = new Vector();
			for ( int nIndex=0; nIndex<str.length ; nIndex++ ) {
				cmn.add(str[nIndex]);
			}
		} else {
			Vector newcmn = new Vector();
			// ʂ̕Ax̕Ɋ܂܂Ă邩H
			Enumeration cmnelm = cmn.elements();
			while( cmnelm.hasMoreElements() ) {
				String szcmn = (String)cmnelm.nextElement();
				for ( int nIndex=0; nIndex<str.length ; nIndex++ ) {
					if ( szcmn.equals(str[nIndex]) ) {
						newcmn.add( szcmn ) ;
						break;
					}
				}
			}
			cmn = newcmn;
		}
	}
	String szRet = "";
	if ( cmn != null ) {
		Enumeration cmnelm = cmn.elements();
		while( cmnelm.hasMoreElements() ) {
			szRet += (String)cmnelm.nextElement() + " ";
		}
	}
	szRet = trimRight(szRet);
//	ZDebug.trace("    cmn:"+szRet);
	return szRet;
	}

	//##  #########################################################
	/**
	 * ݎԂ܂B
	 */
	static public String getTime() {
	Date date = new Date();
	DateFormat fmt = DateFormat.getTimeInstance();
	return fmt.format(date);
	}

	/**
	 * ݓtԂ܂B
	 */
	static public String getDate() {
	Date date = new Date();
	DateFormat fmt = DateFormat.getDateInstance();
	return fmt.format(date);
	}

	/**
	 * ݎԂ܂B
	 */
	static public String getDateTime() {
	Date date = new Date();
	DateFormat fmt = DateFormat.getDateTimeInstance();
	return fmt.format(date);
	}

	//## ϊ #########################################################
	/**
	 * l擾܂
	 * @param szStr l
	 * @param nErr  G[̏ꍇɕԂl
	 */
	static public byte parseByte(String szStr, byte nErr) {
	if ( szStr == null ) {
		return nErr;
	}
	try {
		byte nIndex = Byte.parseByte(szStr);
		return nIndex;
	} catch(NumberFormatException nf) {
//		ZDebug.trace("Parse Error:"+szStr);
	}
	return nErr;
	}

	/**
	 * l擾܂
	 * @param szStr l
	 * @param nErr  G[̏ꍇɕԂl
	 */
	static public double parseDouble(String szStr, double nErr) {
	if ( szStr == null ) {
		return nErr;
	}

	// SVG Spec
	// @see http://www.w3.org/TR/SVG/coords.html#UnitIdentifiers
	double dUnit = 1.0;
	if ( szStr.endsWith("px") ) {
		szStr = szStr.substring(0,szStr.length()-2);
	} else if ( szStr.endsWith("pt") ) {
		szStr = szStr.substring(0,szStr.length()-2); dUnit = 1.25 ;
	} else if ( szStr.endsWith("pc") ) {
		szStr = szStr.substring(0,szStr.length()-2); dUnit = 15 ;
	} else if ( szStr.endsWith("mm") ) {
		szStr = szStr.substring(0,szStr.length()-2); dUnit = 3.543307 ;
	} else if ( szStr.endsWith("cm") ) {
		szStr = szStr.substring(0,szStr.length()-2); dUnit = 35.43307 ;
	} else if ( szStr.endsWith("in") ) {
		szStr = szStr.substring(0,szStr.length()-2); dUnit = 90 ;
	}

	try {
		double nIndex = Double.parseDouble(szStr);
		return nIndex * dUnit;
	} catch(NumberFormatException nf) {
//		ZDebug.trace("Parse Error:"+szStr);
	}
	return nErr;
	}


	/**
	 * l擾܂
	 * @param szStr l
	 * @param nErr  G[̏ꍇɕԂl
	 */
	static public int parseInt(String szStr, int nErr) {
	if ( szStr == null ) {
		return nErr;
	}
	try {
		int nIndex = Integer.parseInt(szStr);
		return nIndex;
	} catch(NumberFormatException nf) {
//		ZDebug.trace("Parse Error:"+szStr);
	}
	return nErr;
	}

	/**
	 * l擾܂
	 * G[̏ꍇA-1Ԃ܂
	 * @param szStr l
	 */
	static public int parseInt(String szStr) {
	return parseInt(szStr,-1);
	}
}
