/*
 * @(#)ZMessage.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.util;

import java.awt.Window;
import java.awt.Component;

import javax.swing.JOptionPane;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZUIUtil;
/**
 * bZ[W{bNX\܂B
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class ZMessage {
	/**
	 * mFbZ[W\܂
	 * @param parent eR|[lg
	 * @param szKey  bZ[WL[
	 */
	static public void showMessage(Component parent,String szKey) {
	String szMsg   = getMessage(szKey);
	String szTitle = getTitle(szKey);
	int    nType   = getType(szKey);
	Window win     = ZUIUtil.getParentWindow(parent);
	JOptionPane.showMessageDialog(win,szMsg,szTitle,nType);
	}

	/**
	 * mFbZ[W\܂
	 * @param parent eR|[lg
	 * @param szKey  bZ[WL[
	 * @param szMessage  ǉbZ[W
	 */
	static public void showMessage(
		Component parent,String szKey,String szMessage) {
	String szMsg   = getMessage(szKey)+"\n"+szMessage;
	String szTitle = getTitle(szKey);
	int    nType   = getType(szKey);
	Window win     = ZUIUtil.getParentWindow(parent);
	JOptionPane.showMessageDialog(win,szMsg,szTitle,nType);
	}

	/**
	 * mFbZ[W\܂(yes/no)₢킹܂
	 * @param parent eR|[lg
	 * @param szKey  bZ[WL[
	 */
	static public boolean showConfirmDialog(Component parent,String szKey) {
	String szMsg   = getMessage(szKey);
	String szTitle = getTitle(szKey);
	int    nType   = getType(szKey);
	Window win     = ZUIUtil.getParentWindow(parent);
	int result = JOptionPane.showConfirmDialog(win,szMsg,szTitle,nType);
	return (result==JOptionPane.YES_OPTION);
	}

	/**
	 * mFbZ[W\܂(yes/no/cancel)₢킹܂
	 * @param parent eR|[lg
	 * @param szKey  bZ[WL[
	 */
	static public int showConfirmDialog3(Component parent,String szKey) {
	String szMsg   = getMessage(szKey);
	String szTitle = getTitle(szKey);
	int    nType   = getType(szKey);
	Window win     = ZUIUtil.getParentWindow(parent);
	return JOptionPane.showConfirmDialog(win,szMsg,szTitle,nType);
	}

	/**
	 * ͂𑣐i܂
	 * @param parent eR|[lg
	 * @param szKey  bZ[WL[
	 */
	static public String showInputDialog(Component parent,String szKey) {
	String szMsg   = getMessage(szKey);
	String szTitle = getTitle(szKey);
	int    nType   = getType(szKey);
	Window win     = ZUIUtil.getParentWindow(parent);
	return JOptionPane.showInputDialog(win,szMsg,szTitle,nType);
	}

	//## ֐ #####################################################
	/**
	 * bZ[W擾֐
	 * @param szKey bZ[WL[
	 */
	static protected String getMessage(String szKey) {
	String szRet = szKey;
	ZResource res = getResource();
	if ( res != null ) {
		szRet = res.getString(PFX_MSG+szKey+SFX_MSG);
		if ( szRet == null ) {
			szRet = "message is not specified("+szKey+")";
		}
	}
	return szRet;
	}

	/**
	 * ^Cg擾֐
	 * @param szKey bZ[WL[
	 */
	static protected String getTitle(String szKey) {
	String szRet = szKey;
	ZResource res = getResource();
	if ( res != null ) {
		szRet = res.getString(PFX_MSG+szKey+SFX_TTL);
		if ( szRet == null ) {
			szRet = "title is not specified("+szKey+")";
		}
	}
	return szRet;
	}

	/**
	 * ^Cv擾֐
	 * @param szKey bZ[WL[
	 */
	static protected int getType(String szKey) {
	int nType = JOptionPane.INFORMATION_MESSAGE;
	ZResource res = getResource();
	if ( res != null ) {
		String szType = res.getString(PFX_MSG+szKey+SFX_TYPE);
		if ( szType != null ) {
			if ( szType.equals("ERROR") ) {
				nType = JOptionPane.ERROR_MESSAGE;
			} else if ( szType.equals("INFORMATION") ) {
				nType = JOptionPane.INFORMATION_MESSAGE;
			} else if ( szType.equals("WARNING") ) {
				nType = JOptionPane.WARNING_MESSAGE;
			} else if ( szType.equals("QUESTION") ) {
				nType = JOptionPane.QUESTION_MESSAGE;
			} else if ( szType.equals("PLAIN") ) {
				nType = JOptionPane.PLAIN_MESSAGE;

			} else if ( szType.equals("YES_NO_OPTION") ) {
				nType = JOptionPane.YES_NO_OPTION;
			}
		}
	}
	return nType;
	}


	/**
	 * \[X擾֐
	 */
	static protected ZResource getResource() {
	ZResource res = null;
	IZApp app = ZApp.getTheApp();
	if ( app != null ) {
		res = app.getResource();
	}
	return res;
	}

	//## Agr[g ###############################################
	/**
	 * bZ[WvtBbNX
	 */
    private static final String PFX_MSG    = "msg.";

    private static final String SFX_MSG    = ".message";
    private static final String SFX_TTL    = ".title";
    private static final String SFX_TYPE   = ".type";
}
