/*
 * @(#)UIFactory.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.ui;

import java.awt.Insets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import java.net.URL;

import java.util.Enumeration; 
import java.util.Hashtable; 
import java.util.Vector; 

import java.lang.Character;

import javax.swing.JComponent;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.Box;
import javax.swing.BoxLayout;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.IZFileable;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZDebug;
/**
 * j[Ac[o[AXe[^Xo[ȂUIʃC^[tFCX`܂
 * @author  N
 * @version 1.01 2001/01/07
 */
public class UIFactory {
	/**
	 * RXgN^
	 * @param app AvP[V(\[XƃANV擾)
	 */
	public UIFactory(IZApp app) {
	mApp = app;
	}

	/**
	 * RXgN^
	 * @param app AvP[V(ANV擾)
	 * @param res \[X
	 */
	public UIFactory(IZApp app,ZResource res) {
	mApp = app;
	mRes = res;
	}

	//## j[ #####################################################
	/**
	 * j[o[̍쐬
	 * @param szRes \[X
	 */
	public JMenuBar createMenuBar( String szRes ) {
	// \[X̑݃`FbN
	ZResource res = getResource() ;
	if ( res == null ) {
		return ( null ) ;
	}

	// j[o[̍쐬
	mMenuBar = createMenuBar();

	// j[̍쐬
	String[] szMenuKeys = ZString.tokenize(res.getString( szRes ) );
	if ( szMenuKeys == null ) {
		return(null);
	}
	for (int nIndex = 0; nIndex < szMenuKeys.length; nIndex++) {
	    JMenu menu = createMenu(szMenuKeys[nIndex]);
	    if (menu != null) {
			mMenuBar.add(menu);
	    }
	}
	return ( mMenuBar );
	}

	/**
	 * j[쐬܂B
	 * @param szKey j[L[
	 */
	protected JMenu createMenu(String szKey) {
	JMenu menu = null ;
	String szLabel = getResource().getString(PFX_MENU+szKey+SFX_LABEL);
	if ( szLabel == null ) {
		System.out.println("Resouce not found:"+
							PFX_MENU+szKey+SFX_LABEL);
		return null;
	}
	int nIndex = szLabel.indexOf(MNEMONIC);
	// j[jbN̐ݒ
	if ( nIndex != -1 ) {
		String szLabel2 = szLabel.substring(0,nIndex)+szLabel.substring(nIndex+1);
		menu = new JMenu(szLabel2);
		menu.setMnemonic( Character.toLowerCase(szLabel.charAt(nIndex+1)) );
	} else {
		menu = new JMenu(szLabel);
	}

	// v_Ej[̍쐬
	String[] szItemKeys = ZString.tokenize(getResource().getString(PFX_MENU+szKey));
	for ( nIndex = 0; nIndex < szItemKeys.length; nIndex++) {
	    if (szItemKeys[nIndex].equals(SEPARATOR)) {
			menu.addSeparator();
	    } else {
			JMenuItem mi = createMenuItem(szItemKeys[nIndex],menu.getPopupMenu());
			menu.add(mi);
	    }
	}

	// j[ꗗɓo^
	mMenus.put(szKey, menu);
	return menu;
	}

	/**
	 * ReLXgj[쐬܂B
	 * @param invoker C{[J[
	 * @param szKey j[L[
	 */
	public JPopupMenu createContextMenu(JComponent invoker,String szKey) {
//	ZDebug.trace("key:"+szKey+"="+getResource().getString(PFX_MENU+szKey));
	// |bvAbv̍쐬
	JPopupMenu menu = new JPopupMenu();
	menu.setInvoker( invoker );

	// v_Ej[̍쐬
//	ZDebug.trace("menu key:"+PFX_MENU+szKey);
//	ZDebug.trace("menu    :"+getResource().getString(PFX_MENU+szKey));
	String[] szItemKeys = ZString.tokenize(getResource().getString(PFX_MENU+szKey));
	for (int nIndex = 0; nIndex < szItemKeys.length; nIndex++) {
	    if (szItemKeys[nIndex].equals(SEPARATOR)) {
			menu.addSeparator();
	    } else {
			JMenuItem mi = createMenuItem(szItemKeys[nIndex],menu);
			menu.add(mi);
	    }
	}
	return menu;
	}

	/**
	 * ReLXgj[쐬܂B
	 * L[̋ʍڂ\܂B
	 * @param invoker C{[J[
	 * @param szKey j[L[Q
	 */
	public JPopupMenu createContextMenu(JComponent invoker,Vector szKeys) {
	// |bvAbv̍쐬
	JPopupMenu menu = new JPopupMenu();
	menu.setInvoker( invoker );

	// v_Ej[̍쐬
	Vector keys = new Vector();
	Enumeration elm = szKeys.elements();
	while( elm.hasMoreElements() ) {
		String szKey = (String)elm.nextElement();
		keys.add(getResource().getString(PFX_MENU+szKey));
	}

	String szCommon = ZString.getCommonStrings(keys);

	// ŌɃZp[^ꍇ́A폜
	while ( szCommon.endsWith(SEPARATOR) ) {
		szCommon = szCommon.substring(0,szCommon.length()-SEPARATOR.length());
		szCommon = ZString.trimRight(szCommon);
	}

	String[] szItemKeys = ZString.tokenize(szCommon);

	boolean bSep = true;
	for (int nIndex = 0; nIndex < szItemKeys.length; nIndex++) {
	    if (szItemKeys[nIndex].equals(SEPARATOR)) {
			// Zp[^ꍇ̓Zp[^ǉȂ
			if ( !bSep ) {
				menu.addSeparator();
			}
			bSep = true;
	    } else {
			JMenuItem mi = createMenuItem(szItemKeys[nIndex],menu);
			menu.add(mi);
			bSep = false;
	    }
	}
	return menu;
	}

	/**
	 * j[ڂ쐬܂B
	 * @param szCmd R}h
	 * @param menu  |bvAbvj[
	 */
	protected JMenuItem createMenuItem(String szCmd,JPopupMenu popup) {
	// Tuj[
	if ( szCmd.startsWith(SUBMENU) ) {
		return ( createMenu( szCmd.substring(1) ) ) ;
	}

	boolean bToggled = false ;
	if ( szCmd.startsWith(TOGGLED) ) {
		bToggled = true ;
		szCmd = szCmd.substring(1);
	}

	// j[ڂ̍쐬
	JMenuItem mi = null;
	String szLabel = getResource().getString(PFX_MENU+szCmd+SFX_LABEL);
	// OSMac̏ꍇ͂ŃxύX
	// ۂɐݒ肷L&F ZUIAction ̒os.archɂ茈肳
	if ( System.getProperty("os.arch").equals("ppc") && szCmd.equals("view_windows") ) {
//		szLabel = "Mac($M)";
		szLabel = getResource().getString(PFX_MENU+"view_mac"+SFX_LABEL);
	}
	String szLabel2 = szLabel;
	char   mnemonic = '\0';
	if ( szLabel == null ) {
		ZDebug.err("not exist resource key:"+PFX_MENU+szCmd+SFX_LABEL);
		szLabel = new String( szCmd );
		szLabel2 = szLabel;
	} else {

		// j[jbN̗L̔
		int nIndex = szLabel.indexOf(MNEMONIC);
		if ( nIndex != -1 ) {
			szLabel2 = szLabel.substring(0,nIndex)+szLabel.substring(nIndex+1);
			mnemonic = Character.toLowerCase(szLabel.charAt(nIndex+1));
		}
	}

//	ZDebug.err("menu:"+szLabel2);
	// j[ACe̍쐬
	if ( bToggled ) {
		mi = new JCheckBoxMenuItem(szLabel2);
	} else {
		mi = new JMenuItem(szLabel2);
	}

	// j[jbN̐ݒ
	if ( mnemonic != '\0' ) {
		mi.setMnemonic( mnemonic );
	}

	// ACR̐ݒ
    URL url = getResource().getURL(PFX_MENU+szCmd+SFX_IMAGE);
	if (url == null) {
		url = getResource().getURL(PFX_MENU+"default"+SFX_IMAGE);
	}
	if (url != null) {
	    mi.setHorizontalTextPosition(JButton.RIGHT);
	    mi.setIcon(new ImageIcon(url));
		mi.setMargin(new Insets(0,0,1,1));
	}

	// ANV̐ݒ
	String szAction = getResource().getString(PFX_MENU+szCmd+SFX_ACTION);
	if (szAction == null) {
	    szAction = szCmd;
	}
	mi.setActionCommand(szAction);
	Action act = getApp().getAction(szAction);
	if (act != null) {
	    mi.addActionListener(act);
	    act.addPropertyChangeListener(new UIChangedListener(mi));
	    mi.setEnabled(act.isEnabled());
	    if ( act instanceof ZAction ) {
			popup.addPopupMenuListener((ZAction)act);
		}
	} else {
	    mi.setEnabled(false);
	}

	// j[ꗗɓo^
	mMenuItems.put(szCmd, mi);
	return mi;
	}

	/**
	 * j[o[̍쐬
	 */
	public JMenuBar createMenuBar() {
	return ( new JMenuBar() );
	}

	/**
	 * j[o[̎擾
	 */
	public JMenuBar getMenuBar() {
	return ( mMenuBar );
	}

	/**
	 * j[ڂ擾܂B
	 * @param szCmd  ANV
	 * @returns item j[ځA܂́Anull
	 */
	public JMenuItem getMenuItem(String szCmd) {
	return (JMenuItem) mMenuItems.get(szCmd);
	}

	/**
	 * j[擾܂B
	 * @param szCmd  ANV
	 * @returns item j[ځA܂́Anull
	 */
	public JMenu getMenu(String szCmd) {
	return (JMenu) mMenus.get(szCmd);
	}

	/**
	 * ŋߎgt@C̍XV
	 * @param cmp          t@CR|[lg
	 * @param szRecentMenu j[ږ
	 * @param szRecentFile OɊJt@C
	 */
	public void updateRecent(IZFileable cmp,
		String szRecentMenu,String szRecentFile) {
	int nRecent = getResource().getInt(szRecentMenu,5);
	int nIndex = 1 ;
	String szRecentn ;
	if ( szRecentFile != null ) {
		// ÕvWFNg݂邩`FbN
		// ŌɂĂSւȂ̂ōŌ̓`FbNȂ
		for ( ; nIndex < nRecent ; nIndex++ ) {
			szRecentn = getResource().getString(szRecentMenu+nIndex);
			if ( szRecentn == null || szRecentn.equals(szRecentFile) ) {
				break;
			}
		}
		// P炷
		for ( nIndex-- ; nIndex>0 ; nIndex-- ) {
			szRecentn = getResource().getString(szRecentMenu+nIndex);
			getResource().putString(szRecentMenu+(nIndex+1),szRecentn);
		}
		// Jt@C擪ɓ
		getResource().putString(szRecentMenu+1,szRecentFile);
	}
	// j[̍XV
	String szCurDir = System.getProperty("user.dir");
//	System.out.println("user.dir=" + szCurDir );
	JMenu menu = getMenu(szRecentMenu);
	if ( menu != null ) {
		menu.removeAll();
		for ( nIndex=1 ; nIndex <= nRecent ; nIndex++ ) {
			szRecentn = getResource().getString(szRecentMenu+nIndex);
			// Recent vpeBݒ肳Ăꍇ
			if ( szRecentn != null ) {
				// ΃pXł͂ȂAtpXŕ\B
				String szRecentName = szRecentn ;
/*
				// \̌(΃pX\)
				if ( szCurDir != null ) {
					szRecentName = ZFile.getSPath(szCurDir,szRecentn);
				}
*/
				JMenuItem mi = new JMenuItem(szRecentName);
				Action action = cmp.createRecentAction(szRecentMenu,szRecentn);
				if ( action != null ) {
				    mi.addActionListener(action);
				    mi.setEnabled(action.isEnabled());
					menu.add(mi);
				} else {
					ZDebug.err("Can't create action") ;
				}
			} else {
//				ZDebug.err("not exist recent:"+ nIndex ) ;
			}
		}
	} else {
		ZDebug.err("not exist menu" ) ;
	}
	}

	//## c[o[ ###################################################
	/**
	 * c[o[쐬܂B
	 * ()łĂꍇ́AO[v܂B
	 * @param szRes \[X
	 */
	public JToolBar createToolBar( String szRes ) {
	// \[X̑݃`FbN
	ZResource res = getResource() ;
	if ( res == null ) {
		return ( null ) ;
	}

	// c[o[̍쐬
	JToolBar toolbar = new JToolBar();
	JPanel   tmpPanel = null;

	// c[̍쐬
	String[] szToolKeys = ZString.tokenize(res.getString( szRes ));
	if ( szToolKeys == null ) {
		return(null);
	}
	for (int nIndex = 0; nIndex < szToolKeys.length; nIndex++) {
	    if (szToolKeys[nIndex].equals(SEPARATOR)) {
			toolbar.add(Box.createHorizontalStrut(5));
	    } else if (szToolKeys[nIndex].equals("(")) {
			tmpPanel = new JPanel();
			tmpPanel.setAlignmentX(0.0f);
			tmpPanel.setLayout( new BoxLayout( tmpPanel, BoxLayout.X_AXIS ) );
	    } else if (szToolKeys[nIndex].equals(")")) {
			toolbar.add(tmpPanel);
			tmpPanel = null;
	    } else {
			if ( tmpPanel == null ) {
				toolbar.add(createTool(szToolKeys[nIndex]));
			} else {
				tmpPanel.add(createTool(szToolKeys[nIndex]));
			}
	    }
	}
	toolbar.add(Box.createHorizontalGlue());
	// ʍɓ\tƂɁADocBarȂǂȂ̂ŁAt[eBO~
	toolbar.setFloatable( false );
	return toolbar;
	}

	/**
	 * c[ڂ쐬܂B
	 * @param szCmd R}h
	 */
	public JComponent createTool(String szCmd) {
	String szToolClass = getResource().getString( PFX_TOOL+szCmd+SFX_CLASS );

	JComponent cmp = null;
	if ( szToolClass == null ) {
		cmp = createToolBarButton(szCmd);
	} else {
		// NX̎擾
		Class cClass;
		try {
			cClass = Class.forName( szToolClass );
		} catch ( ClassNotFoundException cn ) {
			System.err.println ( "ClassNotFound:" + szToolClass ) ;
			return( null );
		}

		// CX^X
		Object obj ;
		try {
			obj = cClass.newInstance();
		} catch ( InstantiationException ie ) {
			System.err.println ( "Class newInstance Failed:" + szToolClass ) ;
			return( null );
		} catch ( IllegalAccessException ia ) {
			System.err.println ( "Class newInstance Failed:" + szToolClass ) ;
			return( null );
		}

		if ( ! ( obj instanceof JComponent ) ) {
			System.err.println ( "Class is not instanceof Compenent:" + szToolClass ) ;
			return( null );
		}
		cmp = (JComponent) obj;

		// {^̓o^
		mToolItems.put(szCmd, cmp);
	}
	return ( cmp ) ;
	}

	/**
	 * c[{^쐬܂B
	 * @param szCmd R}h
	 */
	protected AbstractButton createToolBarButton(String szCmd) {
	boolean bToggled = false ;
	if ( szCmd.startsWith(TOGGLED) ) {
		bToggled = true ;
		szCmd = szCmd.substring(1);
	}
	URL url = getResource().getURL(PFX_MENU+szCmd+SFX_IMAGE);
	if ( url == null ) {
		System.out.println("Resouce not found:"+
							PFX_MENU+szCmd+SFX_IMAGE);
		return null;
	}
    AbstractButton btn ;
	ImageIcon img = new ImageIcon(url);
	if ( img == null ) {
		System.out.println("Resouce not found:"+
							PFX_MENU+szCmd+SFX_IMAGE+"="+
							url.toString());
		return null;
	}
/*
	if ( bToggled ) {
		btn = new JToggleButton(img) {
			public float getAlignmentY() { return 0.5f; }
		};
	} else {
		btn = new JButton(img) {
			public float getAlignmentY() { return 0.5f; }
		};
	}
*/
	if ( bToggled ) {
		btn = new JToggleButton(img);
	} else {
		btn = new JButton(img);
	}
	btn.setAlignmentY(0.5f);
    btn.setRequestFocusEnabled(false);
    btn.setMargin(new Insets(1,1,1,1));

	// ANV̐ݒ
	String szAction = getResource().getString(PFX_MENU+szCmd+SFX_ACTION);
	if (szAction == null) {
	    szAction = szCmd;
	}
	Action act = getApp().getAction(szAction);
	if (act != null) {
	    btn.setActionCommand(szAction);
	    act.addPropertyChangeListener(new UIChangedListener(btn));
	    btn.addActionListener(act);
	} else {
	    btn.setEnabled(false);
	}

	// c[`bv̐ݒ
	String szTip = getResource().getString(PFX_TOOL+szCmd+SFX_TOOLTIP);
	if (szTip == null) {
		// c[`bvɂȂꍇj[x擾
		szTip = getResource().getString(PFX_MENU+szCmd+SFX_LABEL);
		if ( szTip != null ) {
			int nIndex = szTip.indexOf('$');
			if ( nIndex != -1 ) {
				szTip = szTip.substring(0,nIndex) + szTip.substring(nIndex+1);
			}
			nIndex = szTip.indexOf('(');
			if ( nIndex != -1 ) {
				szTip = szTip.substring(0,nIndex);
			}
		}
	}
	if (szTip != null) {
	    btn.setToolTipText(szTip);
	}

	// {^̓o^
	mToolItems.put(szCmd, btn);

    return btn;
	}

	/**
	 * c[ڂ擾܂B
	 * @param szCmd  ږ
	 * @returns item j[ځA܂́Anull
	 */
	public JComponent getToolItem(String szCmd) {
	return (JComponent) mToolItems.get(szCmd);
	}

	//## Xe[^Xo[ ###############################################
	/**
	 * Xe[^Xo[쐬܂B
	 */
/*	public FwStatusbar createStatusbar() {
		FwStatusbar sts = new FwStatusbar();
		return ( sts ) ;
	}
*/

	//##  #########################################################
	/**
	 * \[X̎擾
	 */
	protected ZResource getResource() {
	if ( mRes == null ) {
		return ( getApp().getResource() );
	}
	return mRes;
	}

	/**
	 * AvP[V̎擾
	 */
	protected IZApp getApp() {
	return ( mApp );
	}

	//## TuNX ###################################################
	/**
	 * ANVύXXi[
	 */
	private class UIChangedListener implements PropertyChangeListener {
	/**
	 * RXgN^
	 * @param mi j[
	 */
	UIChangedListener(AbstractButton btn) {
	super();
	mButton = btn;
	}

	/**
	 * vpeBύXB
	 * @param evt vpeBύXCxg
	 */
	public void propertyChange(PropertyChangeEvent e) {
	String propertyName = e.getPropertyName();
	if (e.getPropertyName().equals(ZAction.LABEL)) {
		String text = (String) e.getNewValue();
		mButton.setText(text);
	} else if (propertyName.equals(ZAction.ENABLED)) {
		Boolean enabledState = (Boolean) e.getNewValue();
		mButton.setEnabled(enabledState.booleanValue());
	} else if (propertyName.equals(ZAction.CHECKED)) {
		Boolean checkedState = (Boolean) e.getNewValue();
		mButton.setSelected(checkedState.booleanValue());

/*
		if ( mButton instanceof JCheckBoxMenuItem ) {
			((JCheckBoxMenuItem)mButton).setState(enabledState.booleanValue());
		} else if ( mButton instanceof 
		mButton.setSelected(enabledState.booleanValue());
*/
	}
	}

    /**
	 * j[ځAc[{^
     */
	private AbstractButton mButton;
//=====================================================================
}
	//## Agr[g ###############################################
    /**
	 * AvP[VNX
     */
	protected IZApp		mApp;

    /**
	 * \[X
     */
	protected ZResource mRes = null;

    /**
	 * j[o[
     */
	protected JMenuBar	mMenuBar;

    /**
	 * j[ڈꗗFj[ACe
     */
    protected Hashtable	mMenuItems	 = new Hashtable();

    /**
	 * j[ڈꗗFj[
     */
    protected Hashtable	mMenus		 = new Hashtable();

    /**
	 * j[ڈꗗFc[{^
     */
    protected Hashtable	mToolItems	 = new Hashtable();
    /**
	 * \[X擾p
     */
    private static final String PFX_MENU    = "menu.";
    private static final String PFX_TOOL    = "tool.";
    private static final String SFX_IMAGE   = ".image";
    private static final String SFX_LABEL   = ".label";
    private static final String SFX_ACTION  = ".action";
    private static final String SFX_TOOLTIP = ".tooltip";
    private static final String SFX_CLASS   = ".class";
	private static final String MNEMONIC	= "$";
	private static final String SUBMENU		= "%";
	private static final String TOGGLED		= "+";
	private static final String SEPARATOR	= "-";
}
