/*
 * @(#)GobManager.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.gob;

import java.awt.Color;
import java.awt.BasicStroke;

import java.util.Enumeration;
import java.util.Vector;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZReverseEnumeration;
/**
 * ݑIĂGgɑ΂鑀`
 *
 * ʂ̕\{ɊւWῗ̃NXŃCvg
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GobManager {

	//## Jg ####################################################
	/**
	 * GgJgGgɐݒ肷
	 * JgGg͑쒆̂ݗLŁALButtonDownLButtonUp܂ł̊Ԃ̂ݗL
	 *
	 * @param panelId plʎq
	 * @param elm     Gg
	 */
	static public void setCurrent( String panelId, GElement elm ) {
	// SI
	Vector items = list(panelId,CURRENT);
	items.removeAllElements();
	if ( elm != null ) {
		items.add(elm);
	}
	}

	/**
	 * JgGgɒǉ
	 * @param panelId plʎq
	 */
	static public void addCurrent( String panelId, GElement elm ) {
	// SI
	Vector items = list(panelId,CURRENT);
	if ( elm != null ) {
		items.add(elm);
	}
	}

	/**
	 * IĂGgJgGgɐݒ肷
	 * @param panelId plʎq
	 */
	static public void updateCurrent( String panelId ) {
	ZInstance.setList(panelId+CURRENT+ELEMENTS,getSelectedElement(panelId));
	}

	/**
	 * ݑIGǧ擾
	 * @param panelId plʎq
	 */
	static public Vector getCurrent( String panelId ) {
	return list(panelId,CURRENT);
	}

	//## Gg ##################################################
	/**
	 * Gg擾
	 * @param panelId plʎq
	 */
	static public Vector getElement( String panelId ) {
	return list(panelId,ALL);
	}

	/**
	 * IĂGg擾
	 * @param panelId plʎq
	 */
	static public Vector getSelectedElement( String panelId ) {
	Vector items = new Vector();
	Enumeration elm = list(panelId,ALL).elements();
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		if ( item.isSelect() ) {
			items.add( item );
		}
	}
//	ZDebug.trace("select count:"+panelId+":"+items.size());
	return items;
	}


	//## qbg[h ################################################
	/**
	 * ݑIĂGgɃqbg邩H
	 * @param editor R|[lg
	 * @param pt     |Cg
	 */
	static public byte getSelectedHitMode( DocPane editor, ZPoint pt ) {
	String panelId = editor.getPanelId();
	ZPoint transPt = transrateRootTransform( editor, pt );
	byte nMode = GOperation.NONE;

	// ݑIĂGg̎擾
	int nCount = 0;
	Enumeration elm = elements(panelId,ALL);
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		if ( item.isSelect() ) {
			nCount ++;
			byte mode = item.getHitMode(transPt);
			if ( mode != GOperation.NONE ) {
				nMode = mode;
			}
		}
	}

	if ( nMode != GOperation.NONE && nCount>1 ) {
		nMode = GOperation.MOVE;
	}
	return nMode;
	}

	/**
	 * ݑIĂGg̈ړ[h͂ȂɂH
	 * @param editor R|[lg
	 * @param pt     |Cg
	 */
	static public byte getSelectedPreMoveMode( DocPane editor, ZPoint pt ) {
	String panelId = editor.getPanelId();
	ZPoint transPt = transrateRootTransform( editor, pt );
	byte nMode = GOperation.NONE;

	// ݑIĂGg̎擾
	int nCount = 0;
	Enumeration elm = elements(panelId,ALL);
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		if ( item.isSelect() ) {
			nCount ++;
			byte mode = item.getPreMoveMode(transPt);
			if ( mode != GOperation.NONE ) {
				nMode = mode;
			}
		}
	}

	if ( nMode != GOperation.NONE && nCount>1 ) {
		nMode = GOperation.MOVE;
	}
	return nMode;
	}

	/**
	 * JgGg̑IԂݒ肷
	 * @param panelId plʎq
	 * @param bSel    I
	 */
	static public void setCurrentSelect( String panelId, boolean bSel ) {
	setSelect(panelId,CURRENT,bSel);
	}

	/**
	 * SẴGg̑IԂݒ肷
	 * @param panelId plʎq
	 * @param bSel    I
	 */
	static public void setSelect( String panelId, boolean bSel ) {
	setSelect(panelId,ALL,bSel);
	}

	/**
	 * IԂݒ肷
	 * @param panelId plʎq
	 * @param szMode  [h
	 * @param bSel    I
	 */
	static public void setSelect( String panelId, String szMode, boolean bSel ) {
	Enumeration elm = elements(panelId,szMode);
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		item.setSelect(bSel);
	}
	}

	//## qbgGg ##############################################
	/**
	 * ׂẴGgɃqbg邩H
	 * @param editor R|[lg
	 * @param pt    |Cg
	 */
	static public GElement getCurrentHitElement( DocPane editor, ZPoint pt ) {
	return getHitElement( editor, CURRENT, pt );
	}

	/**
	 * ׂẴGgɃqbg邩H
	 * @param editor R|[lg
	 * @param pt    |Cg
	 */
	static public GElement getHitElement( DocPane editor, ZPoint pt ) {
	return getHitElement( editor, ALL, pt );
	}

	/**
	 * ׂẴGgɃqbg邩H
	 * @param editor R|[lg
	 * @param szMode [h
	 * @param pt     |Cg
	 */
	static public GElement getHitElement( DocPane editor, String szMode, ZPoint pt ) {
	String panelId = editor.getPanelId();
	ZPoint transPt = transrateRootTransform( editor, pt );

	// ݑIĂGg̎擾
	Enumeration elm = r_elements(panelId,szMode);
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		byte mode = item.getHitMode(transPt);
		if ( mode != GOperation.NONE ) {
			return item;
		}
	}
	
	return null;
	}

	//## ړ ##########################################################
	/**
	 * ړ̊Jn
	 * @param editor R|[lg
	 * @param grid   ObhRg[
	 */
	static public void moveStart( DocPane editor, DocGridControler grid ) {
	String panelId = editor.getPanelId();
	pushRootTransform(editor,grid);

	Enumeration elm = elements( panelId, CURRENT );
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		item.moveStart( grid );
	}
	grid.popTransform();
	}

	/**
	 * ړ̏I
	 * @param editor R|[lg
	 * @param grid   ObhRg[
	 */
	static public void moveEnd( DocPane editor, DocGridControler grid ) {
	String panelId = editor.getPanelId();
	pushRootTransform(editor,grid);

	Enumeration elm = elements( panelId, CURRENT );
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		item.moveEnd( grid );
	}
	grid.popTransform();
	}

	//## ` ##########################################################
	/**
	 * `
	 * @param editor   R|[lg
	 * @param graphics OtBbNX
	 */
	static public void paint( DocPane editor, DocGraphics graphics ) {
//	ZDebug.trace();
	String panelId = editor.getPanelId();
	pushRootTransform(editor,graphics.getGridControler());

	// Gob{̂̕`
	Enumeration elm = elements( panelId, ALL );
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		item.paint( graphics );
	}

	graphics.getGridControler().popTransform();
	}

	/**
	 * ݗvfɑ΂`
	 * @param editor   R|[lg
	 * @param graphics OtBbNX
	 */
	static public void paintCurrent( DocPane editor, DocGraphics graphics ) {
	String panelId = editor.getPanelId();
	pushRootTransform(editor,graphics.getGridControler());

	boolean bDrag = ( size(panelId,CURRENT)!=0 );
	// hbȌꍇA`惂[h̕ύX
	if ( bDrag ) {
		graphics.getGraphics().setXORMode(Color.black);

		BasicStroke dotted = new BasicStroke(1, BasicStroke.CAP_BUTT, 
					BasicStroke.JOIN_MITER, 10.0f, new float[]{3,3}, 0);
		graphics.getGraphics().setStroke(dotted);

		// ړe̕`
		Enumeration elm = elements( panelId, CURRENT );
		while ( elm.hasMoreElements() ) {
			GElement item = (GElement)elm.nextElement();
			item.paintDrag( graphics );
		}

		// `惂[h߂
		graphics.getGraphics().setPaintMode();

	} else {
		// ZN^[̕`
		Enumeration elm = getSelectedElement(panelId).elements();
		while ( elm.hasMoreElements() ) {
			GElement item = (GElement)elm.nextElement();
			item.paintSelector( graphics );
		}
	}

	// ǉGob̕`
	// RlN^̐VK쐬̏ꍇARlN^GgGobƂĂ܂݂Ȃ
	// ǉGobƂĕ`悷
	Enumeration elm = elements( panelId, HIGHLIGHT );
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		item.paint( graphics );
	}

	graphics.getGridControler().popTransform();
	}

	//## ʒu ##########################################################
	/**
	 * \XP[Wϊ̊i[
	 * @param editor   R|[lg
	 * @param graphics OtBbNX
	 */
	static public void pushRootTransform( DocPane editor, DocGridControler grid ) {
	String panelId = editor.getPanelId();
	DocElement root = (DocElement)editor.getDocument().getRootElement(panelId);
	if ( root != null ) {
		grid.pushTransform(root.getDisplayScaledTransform(panelId));
	} else {
		grid.pushTransform(new PTransform(1,0,0,1,0,0));
	}
	}

	/**
	 * \XP[Wϊ
	 * @param editor   R|[lg
	 * @param pt       W
	 */
	static public ZPoint transrateRootTransform( DocPane editor, ZPoint pt ) {
	String panelId = editor.getPanelId();
	DocElement root = (DocElement)editor.getDocument().getRootElement(panelId);
	if ( root != null ) {
		return root.getDisplayScaledTransform(panelId).inverseTransform(pt);
	}
	return pt;
	}

	/**
	 * `̎擾
	 * ꂼ̎qvfƂɍWϊێĂ\̂ŁA
	 * O[vƂĂ͍Wϊς݋`擾łȂB
	 *
	 * @param items `vZqvf̃xN^[
	 */
	static public ZRectangle getTransformedBounds(Vector items) {
	Enumeration elm = items.elements();
	ZRectangle rect = null;
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		ZRectangle childRect = item.getTransformedBounds();
		if ( childRect != null ) {
			if ( rect == null ) {
				rect = childRect;
			} else {
				rect.union(childRect);
			}
		}
	}
	return rect;
	}

	//## [eBeB ################################################
	/**
	 * ݑIĂGg̎擾
	 * @param panelId plʎq
	 * @param mode    [h
	 */
	static public Vector list(String panelId,String mode) {
	return ZInstance.list(panelId+mode+ELEMENTS);
	}

	/**
	 * ݑIĂGg̎擾
	 * @param panelId plʎq
	 * @param mode    [h
	 */
	static public Enumeration elements(String panelId,String mode) {
	return list(panelId,mode).elements();
	}

	/**
	 * ݑIĂGg̋t擾
	 * @param panelId plʎq
	 * @param mode    [h
	 */
	static public Enumeration r_elements(String panelId,String mode) {
	return new ZReverseEnumeration((Vector)list(panelId,mode));
	}

	/**
	 * ݑIĂGg̎擾
	 * @param panelId plʎq
	 * @param mode    [h
	 */
	static public int size(String panelId,String mode) {
	return list(panelId,mode).size();
	}

	//## Agr[g################################################
    /**
	 * CX^X}l[Wo^L[F݃IuWFNg
     */
	public  static final String CURRENT		= ".current";

    /**
	 * CX^X}l[Wo^L[Fׂ
     */
	public  static final String ALL			= ".all";

    /**
	 * CX^X}l[Wo^L[FnCCg
     */
	public  static final String HIGHLIGHT	= ".highlight";

    /**
	 * CX^X}l[Wo^L[FGgvtBbNX
     */
	public  static final String ELEMENTS	= ".elements";
}
