/*
 * @(#)GRectShape.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.gob;

import java.awt.geom.Ellipse2D;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FInteger;

import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZRectangle;
/*
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.geom.ZGeneralPath;

import jp.co.iti.fagot.util.ZGraphicUtil;

import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
*/
import jp.co.iti.fagot.util.ZDebug;

/**
 * RectShape
 * `Iȓ`
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GRectShape extends GRectangle {

	/**
	 * RXgN^
	 */
	public GRectShape() {
		super();

		//{{FAGOT_ATTR
		mShapeType = new FInteger();
		//}}FAGOT_ATTR
	}

	//## FAGOT ########################################################
	/**
	 * ^Cv̐ݒ
	 * @param type ^Cv
	 */
	public void setShape( String type ) {
	if ( type != null ) {
		if      ( type.equals("static")  ) { setShape(0); }
		else if ( type.equals("dynamic") ) { setShape(1); }
		else if ( type.equals("server")  ) { setShape(2); }
	}
	}

	/**
	 * ^Cv̐ݒ
	 * @param type ^Cv
	 */
	public void setShape( int type ) {
	mShapeType.set( type );
	}

	/**
	 * ^Cv̎擾
	 */
	public int getShape() {
	return mShapeType.get();
	}

	/**
	 * pX̐ݒ
	 */
	public void setPath() {
	ZRectangle rt = getRect();
	ZPath path = new ZPath();
	double dx = rt.getX();
	double dy = rt.getY();
	double dw = rt.getWidth();
	double dh = rt.getHeight();

	switch ( getShape() ) {
	  case 0:
	  default:
		setPath( new ZPath( rt ) );
		break;
	  case 1:	// Ђ`
		path.moveTo( dx + dw/2 , dy        );
		path.lineTo( dx + dw   , dy + dh/2 );
		path.lineTo( dx + dw/2 , dy + dh   );
		path.lineTo( dx        , dy + dh/2 );
		path.closePath();
		setPath( path );
		break;
	  case 2:
		setPath( new ZPath( rt.getEllipse2D() ) );
//		path.moveTo(  dx + dw/2   , dy        );
//		path.curveTo( dx + dw*3/4 , dy         , dx + dw     , dy + dh/4  , dx + dw   , dy + dh/2 );
//		path.curveTo( dx + dw     , dy + dh*3/4, dx + dw*3/4 , dy + dh    , dx + dw/2 , dy + dh   );
//		path.curveTo( dx + dw/4   , dy + dh    , dx          , dy + dh*3/4, dx        , dy + dh/2 );
//		path.curveTo( dx          , dy + dh/4  , dx + dw/4   , dy         , dx + dw/2 , dy        );
//		path.closePath();
//		setPath( path );
		break;
	}
	}

	/**
	 * Fob}l[W̓o^
	 * @param mgr }l[W
	 */
	public void setFobManager(FobManager mgr) {
		super.setFobManager(mgr);
		//{{FAGOT_ATTR
		mShapeType.setFobManager(mgr,this);
		//}}FAGOT_ATTR
	}

	//## CLONE ########################################################
	/**
	 * CX^X̍쐬
	 * eNXɂăCX^X𐶐
	 * zNXiуCX^XȂNXjłnullԂ
	 */
	public Object createClone() {
	return new GRectShape();
	}

	/**
	 * Agr[g̕
	 * @param obj ̃IuWFNg
	 */
	public void copyAttribute( Object obj ) {
	super.copyAttribute( obj );

	((GRectShape)obj).setShape( getShape() );
	}

	//##{FAGOT_ATTRIBUTE###############################################
	/**
	 * `
	 */
	protected FInteger	mShapeType = null;
}
