/*
 * @(#)GElement.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.gob;

import java.awt.Rectangle;
import java.awt.Graphics2D;

import java.awt.geom.Rectangle2D;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.geom.ZPath;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.IFobContainer;

import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZDebug;
/**
 * `\̕iLq܂B
 *
 * ydlz
 * ȉ̐݌vjɃNX`
 * <ul>
 * <li>gAkjava.awt.GraphicsōsStrokȇ܂ŕωĂ܂
 *     ̂ōWȊǗ
 * <li>gAkAړA]̌JԂɂ덷̍ŏ
 * </ul>
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GElement implements IFobContainer {

	/**
	 * RXgN^
	 */
	public GElement() {
		//{{FAGOT_ATTR
		mStyle     = new PStyle();
		mTransform = new PTransform();
		//}}FAGOT_ATTR
	}

	//## Rei #####################################################
	/**
	 * Rei̐ݒ
	 * @param container Rei
	 */
	public void setContainer(IGobContainer container) {
	mContainer = container;
	}

	/**
	 * Rei̎擾
	 */
	public IGobContainer getContainer() {
	return mContainer;
	}

	/**
	 * Rei̍폜
	 */
	public void removeContainer() {
	if ( mContainer != null ) {
		mContainer.removeGob(this);
	}
	}

	/**
	 * ʎq̐ݒ
	 * ReiGElementʂ邽߂IDݒł
	 * ̒ĺAReip̒lł̂ŁAundosv
	 * @param szId ʎq
	 */
	public void setGobId(String szId) {
	mGobId = szId;
	}

	/**
	 * ʎq̎擾
	 */
	public String getGobId() {
	return mGobId;
	}

	/**
	 * IłȂOʕ`IuWFNg̒ǉ
	 * @param children q
	 */
	public void addForeChildren(Vector children) {
	mForeChildren.addAll(children);
	}

	/**
	 * IłȂOʕ`IuWFNg̒ǉ
	 * @param child q
	 */
	public void addForeChild(GElement child) {
	mForeChildren.add(child);
	}

	/**
	 * IłȂOʕ`IuWFNg̎擾
	 * @return q
	 */
	public Vector getForeChildren() {
	return mForeChildren;
	}

	/**
	 * IłȂwʕ`IuWFNg̒ǉ
	 * @param children q
	 */
	public void addBackChildren(Vector children) {
	mBackChildren.addAll(children);
	}

	/**
	 * IłȂwʕ`IuWFNg̒ǉ
	 * @param child q
	 */
	public void addBackChild(GElement child) {
	mBackChildren.add(child);
	}

	/**
	 * IłȂwʕ`IuWFNg̎擾
	 * @return q
	 */
	public Vector getBackChildren() {
	return mBackChildren;
	}

	//##  #########################################################
	/**
	 * I̎擾
	 */
	public boolean isSelect() {
	return mSelect;
	}

	/**
	 * I̐ݒ
	 * @param bSel I
	 */
	public boolean setSelect(boolean bSel) {
	if ( mSelectable ) {
		if ( mContainer != null ) {
			mSelect = mContainer.setSelect(this,bSel);
		} else {
			mSelect = bSel;
		}
	}
	return mSelect;
	}

	/**
	 * Is̐ݒ
	 * @param bSel Is
	 */
	public void setSelectable(boolean bSel) {
	mSelectable = bSel;
	}

	//## Container #####################################################
	/**
	 * vfɃqbg邩H
	 * @param pt   _W
	 */
	public byte getHitMode(ZPoint pt) {
	if ( mSelectable ) {
		ZPoint ptTrans = getTransform().inverseTransform(pt);

		if ( mContainer != null ) {
			// Reiɖ₢킹
			return mContainer.getHitMode(this,ptTrans);
		}
		return getHitModeGob(ptTrans);
	}
	return GOperation.NONE;
	}

	/**
	 * vfɃqbg邩H(Rei݂ȂꍇftHg\bh)
	 * @param pt _W
	 */
	public byte getHitModeGob(ZPoint pt) {
		return GOperation.NONE;
	}

	/**
	 * vf̈ړ[h͂ȂɂH
	 * @param pt   _W
	 */
	public byte getPreMoveMode(ZPoint pt) {
	if ( mSelectable ) {
		ZPoint ptTrans = getTransform().inverseTransform(pt);

		if ( mContainer != null ) {
			// Reiɖ₢킹
			return mContainer.getPreMoveMode(this,ptTrans);
		}
		return getPreMoveModeGob(ptTrans);
	}
	return GOperation.NONE;
	}

	/**
	 * vf̈ړ[h͂ȂɂH(Rei݂ȂꍇftHg\bh)
	 * @param pt _W
	 */
	public byte getPreMoveModeGob(ZPoint pt) {
		return getHitModeGob(pt);
	}

	/**
	 * vfɐڑ邩H
	 * @param pt   _W
	 * @param obj  ڑΏ
	 */
	public byte getConnectMode(ZPoint pt, Object obj) {
	if ( mSelectable ) {
		ZPoint ptTrans = getTransform().inverseTransform(pt);

		if ( mContainer != null ) {
			// Reiɖ₢킹
			return mContainer.getConnectMode(this,ptTrans,obj);
		}
		return getConnectModeGob(ptTrans, obj);
	}
	return GOperation.NONE;
	}

	/**
	 * vfɐڑ邩H(Rei݂ȂꍇftHg\bh)
	 * @param pt   _W
	 * @param obj  ڑΏ
	 */
	public byte getConnectModeGob(ZPoint pt, Object obj) {
		return GOperation.NONE;
	}

	/**
	 * vf̐ڑʒu擾
	 * @param mode ڑʒu
	 */
	public ZPoint getConnectPointGob(byte mode) {
	return new ZPoint(0,0);
	}

	/**
	 * _uNbN̓
	 * @param mode NbNʒu
	 */
	public void verbDblClick(ZPoint pt) {
	ZPoint ptTrans = getTransform().inverseTransform(pt);

	if ( mContainer != null ) {
		mContainer.verbDblClick(this,ptTrans);
	} else {
		verbDblClickGob(ptTrans);
	}
	}

	/**
	 * _uNbN̓
	 * @param mode NbNʒu
	 */
	public void verbDblClickGob(ZPoint pt) {
	}

	//## ړ #########################################################
	/**
	 * ړ̊Jn
	 * @param grid ObhRg[
	 */
	public void moveStart(DocGridControler grid) {
	// Wϊ̓Kp
	grid.pushTransform(getTransform());

	if ( mContainer != null ) {
		mContainer.moveStart(this,grid);
	} else {
		moveStartGob(grid);
	}

	// Wϊɖ߂
	grid.popTransform();
	}

	/**
	 * ړ̊Jn(Rei݂ȂꍇftHg\bh)
	 * @param grid ObhRg[
	 */
	public void moveStartGob(DocGridControler grid) {
	}

	/**
	 * ړPath̎擾
	 * @param grid ObhRg[[
	 */
	public ZPath getMovingPath(DocGridControler grid) {
	if ( mContainer != null ) {
//		ZDebug.trace();
		return mContainer.getMovingPath(this,grid);
	}
	return getMovingPathGob(grid);
	}

	/**
	 * ړPath̎擾(Rei݂ȂꍇftHg\bh)
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPathGob(DocGridControler grid) {
	return null;
	}


	/**
	 * ړ̊
	 * @param grid ObhRg[[
	 */
	public void moveEnd(DocGridControler grid) {
	// Wϊ̓Kp
	grid.pushTransform(getTransform());

	if ( mContainer != null ) {
		mContainer.moveEnd(this,grid);
	} else {
		moveEndGob(grid);
	}

	// Wϊɖ߂
	grid.popTransform();
	}

	/**
	 * ړ̊(Rei݂ȂꍇftHg\bh)
	 * @param grid ObhRg[
	 */
	public void moveEndGob(DocGridControler grid) {
	}

	/**
	 * ړ̊KvH
	 */
	public boolean needsMoveEnd() {
	return false;
	}

	//## ʒu #########################################################
	/**
	 * q܂߂`̎擾
	 */
	public ZRectangle getBounds() {
	return getMyBounds();
/*	Vector children = new Vector();
	children.addAll(mBackChildren);
	children.addAll(mForeChildren);
	ZRectangle rect = GobManager.getTransformedBounds(children);
	ZRectangle myRect = getMyBounds();
	if ( myRect != null ) {
		if ( rect == null ) {
			rect = myRect;
		} else {
			rect.union(myRect);
		}
	}
	return rect;
*/
	}

	/**
	 * g̋`̎擾
	 */
	public ZRectangle getMyBounds() {
	return null;
	}

	/**
	 * Wϊς̋`̎擾
	 */
	public ZRectangle getTransformedBounds() {
	return new ZRectangle(getTransform().transform(getBounds()).getBounds2D());
	}

	/**
	 * `X^C̐ݒ
	 */
	public void setStyle( PStyle style ) {
	mStyle.set( style );
	}

	/**
	 * `X^C̎擾
	 */
	public PStyle getStyle() {
		return mStyle;
	}

	/**
	 * Wϊ̐ݒ
	 */
	public void setTransform( PTransform trans ) {
	mTransform.set( trans );
	}

	/**
	 * Wϊ̒ǉ
	 */
	public void addTransform( PTransform trans ) {
//	ZDebug.trace("!!add my:"+getTransform());
//	ZDebug.trace("     add:"+trans);
	mTransform.add( trans );
//	ZDebug.trace("     res:"+getTransform());
	}

	/**
	 * Wϊ
	 */
	public PTransform getTransform() {
		return mTransform;
	}

	//## ` #########################################################
	/**
	 * `
	 */
	public void paint(DocGraphics graphics) {
	// Wϊ̓Kp
	graphics.getGridControler().pushTransform(getTransform());
//	ZDebug.trace("---:"+getTransform());

	if ( paintCheck( graphics ) ) {
		paintBackChildren(graphics);
		paintContents(graphics);
		paintForeChildren(graphics);
	}

	// Wϊɖ߂
	graphics.getGridControler().popTransform();
	}

	/**
	 * vfŗL̕`
	 */
	public void paintContents(DocGraphics graphics) {
	}

	/**
	 * Oʎqvf̕`
	 */
	public void paintForeChildren(DocGraphics graphics) {
	Enumeration elm = mForeChildren.elements();
	while( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		item.paintContents(graphics);
	}
	}

	/**
	 * wʎqvf̕`
	 */
	public void paintBackChildren(DocGraphics graphics) {
	Enumeration elm = mBackChildren.elements();
	while( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		item.paintContents(graphics);
	}
	}

	/**
	 * \̂ߕ`Ԉۂ𔻒肷B
	 * main gobł̂ݔ肵Aqgobmain gobɏ]
	 * @param graphics OtBbNX
	 */
	protected boolean paintCheck(DocGraphics graphics) {
	return true;
	}

	//## ` #########################################################
	/**
	 * I_̕`
	 */
	public void paintSelector(DocGraphics graphics) {
	}

	/**
	 * ړ̕`
	 */
	public void paintDrag(DocGraphics graphics) {
	// Wϊ̓Kp
	graphics.getGridControler().pushTransform(getTransform());
	paintDragContents(graphics);

	// Wϊɖ߂
	graphics.getGridControler().popTransform();
	}

	/**
	 * vfŗL̈ړ̕`
	 */
	public void paintDragContents(DocGraphics graphics) {
	}

	//## FAGOT ########################################################
	/**
	 * Fob}l[W̓o^
	 * @param mgr }l[W
	 */
	public void setFobManager(FobManager mgr) {
		//{{FAGOT_ATTR
		mStyle.setFobManager(mgr,this);
//		mTransform.setFobManager(mgr,this);
		//}}FAGOT_ATTR
	}

	//## CLONE ########################################################
	/**
	 * ̍쐬i}l[W͕Ȃj
	 */
	public Object clone() {
	Object obj = createClone();
	copyAttribute( obj );
	return obj;
	}

	/**
	 * CX^X̍쐬
	 * eNXɂăCX^X𐶐
	 * zNXiуCX^XȂNXjłnullԂ
	 */
	public Object createClone() {
	return new GElement();
	}

	/**
	 * Agr[g̕
	 * @param obj ̃IuWFNg
	 */
	public void copyAttribute( Object obj ) {
	((GElement)obj).setStyle( (PStyle)mStyle.clone() );
	((GElement)obj).setTransform( (PTransform)mTransform.clone() );
	}

	//## Agr[g################################################
	/**
	 * Rei
	 * DOM Tree̕`ł͂ȂAGOB Tree̕`ł΁ARei݂͑Ȃ
	 */
	protected IGobContainer	mContainer = null;

	/**
	 * ʎq
	 */
	protected String		mGobId = null;

	/**
	 * Oʎq
	 */
	protected Vector		mForeChildren = new Vector();

	/**
	 * wʎq
	 */
	protected Vector		mBackChildren = new Vector();

	//## Agr[g:FAGOT##########################################
	/**
	 * `X^C
	 */
	protected PStyle		mStyle;

	/**
	 * Wϊ
	 */
	protected PTransform	mTransform;

	/**
	 * IL
	 */
	protected boolean  mSelect     = false;

	/**
	 * Is
	 */
	protected boolean  mSelectable = true;

	/**
	 * nCCg̗L
	 */
//	protected boolean mHighlight  = false;

}
