/*
 * @(#)XDocument.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.fob.xml;

import org.w3c.dom.*;

import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;

import org.apache.xerces.utils.StringPool;

import jp.co.iti.fagot.fob.FobManager;

import jp.co.iti.fagot.util.ZDebug;
/**
 * Xerces DOM Tree undoableɂ邽߂̃hLgłB
 *
 * ̕@ŌĂяoƂ̃hLg쐬܂B
 *	DOMParser parser = new DOMParser();
 *	parser.setProperty("http://apache.org/xml/properties/dom/document-class-name",new String("class name"));
 *	InputSource in = new InputSource("file:/c:/work/R2/project/test/01Project.xml");
 *	parser.parse(in);
 *	doc = (DocDocument)parser.getDocument();
 *
 * {IɁAorg.apache.xerces.dom.DocumentImpl̃I[oChłAundoKvł
 * ƂĂCvg܂B
 *
 * @author  N
 * @version 1.01 2001/03/22
 */
public class XDocument extends DocumentImpl {

	/**
	 * RXgN^
	 */
	public XDocument(){
//	createDocument();
	}

	//## vpeB ###################################################
	/**
	 * f[^}l[W̎擾
	 */
	public FobManager getFobManager(){
	return mFobManager ;
	}

	/**
	 * XVԂ̏
	 * hLgۑꂽƂɍXVԂ邽߂ɌĂяo܂
	 */
	public void setModified() {
	mFobManager.setModified() ;
	}

	/**
	 * XVԂ̎擾
	 */
	public boolean isModified() {
	return mFobManager.isModified() ;
	}

	//## f[^####################################################
	/**
	 * gUNVH
	 */
	public boolean isTransaction() {
	boolean bRet = false;
	if ( mFobManager != null ) {
		bRet = mFobManager.isTransaction();
	}
	return bRet;
	}

	/**
	 * gUNV̊Jn
	 */
	public void beginTransaction() {
	if ( mFobManager != null ) {
		mFobManager.beginTransaction();
	}
	}

	/**
	 * R~bg
	 */
	public void commit() {
	if ( mFobManager != null ) {
		mFobManager.commit();
	}
	}

	/**
	 * ǉR~bg
	 */
	public void commitPlus() {
	if ( mFobManager != null ) {
		mFobManager.commitPlus();
	}
	}

	/**
	 * [obN
	 */
	public void rollback() {
	if ( mFobManager != null ) {
		mFobManager.rollback();
	}
	}

	//## IZUndoableC^[tFCX ###################################
	/**
	 * undo
	 */
	public void doUndo() {
	mFobManager.undo() ;
	}

	/**
	 * redo
	 */
	public void doRedo() {
	mFobManager.redo() ;
	}

	/**
	 * undo̖₢킹
	 */
	public boolean canUndo() {
	return mFobManager.canUndo() ;
	}

	/**
	 * redo̖₢킹
	 */
	public boolean canRedo() {
	return mFobManager.canRedo() ;
	}

	//## I[oChFhLg ###############################
	/**
	 * }
	 */
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
//	ZDebug.trace("insert:"+newChild.toString());
	return super.insertBefore(newChild,refChild);
	}

	/**
	 * 폜
	 */
    public Node removeChild(Node oldChild) throws DOMException {
	ZDebug.trace("remove:"+oldChild.toString());
	return super.removeChild(oldChild);
	}

	/**
	 * u
	 */
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
	ZDebug.trace("remove:"+oldChild.toString());
	return super.removeChild(oldChild);
	}

	//## I[oChFDOMt@Ng[ ################################
	/**
	 * Agr[g
	 */
	public Attr createAttribute(String name) throws DOMException {
//	ZDebug.trace("\t:create:"+name);
	return super.createAttribute(name);
	}

	/**
	 * f[^ZNV
	 */
	public CDATASection createCDATASection(String data) throws DOMException {
	ZDebug.trace("\t:create:"+data);
	return super.createCDATASection(data);
	}

	/**
	 * Rg
	 */
	public Comment createComment(String data) {
//	ZDebug.trace("\t:create:"+data);
	return super.createComment(data);
	}

	/**
	 * hLgtOg
	 */
	public DocumentFragment createDocumentFragment() {
	ZDebug.trace("\t:create:");
	return super.createDocumentFragment();
	}

	/**
	 * Gg
	 */
	public Element createElement(String tagName) throws DOMException {
	ZDebug.trace("\t:create:"+tagName);
	return super.createElement(tagName);
	}

	/**
	 * GeBeBt@X
	 */
	public EntityReference createEntityReference(String name) throws DOMException {
	ZDebug.trace("\t:create:"+name);
	return super.createEntityReference(name);
	}

	/**
	 * ProcessingInstruction
	 */
	public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
	return super.createProcessingInstruction(target,data);
	}

	/**
	 * text
	 */
	public Text createTextNode(String data) {
	return super.createTextNode(data);
	}

	//## I[oChFnon-DOMt@Ng[ ############################
	/**
	 * hLg^Cv(ύXȂ̂ŃI[oChȂ)
	 */
/*
	public DocumentType createDocumentType(String qualifiedName,
                                           String publicID,
                                           String systemID)
        throws DOMException {
	ZDebug.trace("\t:create:"+qualifiedName+","+publicID+","+systemID);
	ZDebug.printStack();
	return super.createDocumentType(qualifiedName,publicID,systemID);
	}
*/
	/**
	 * GeBeB
	 */
	public Entity createEntity(String name) throws DOMException {
	ZDebug.trace("\t:create:"+name);
	return super.createEntity(name);
	}

	/**
	 * Notation
	 */
	public Notation createNotation(String name) throws DOMException {
	ZDebug.trace("\t:create:"+name);
	return super.createNotation(name);
	}

	/**
	 * ElementDefinition
	 */
	public ElementDefinitionImpl createElementDefinition(String name) throws DOMException {
//	ZDebug.trace("\t:create:"+name);
	return super.createElementDefinition(name);
	}

	//## I[oChFnon-DOM\bh ################################
	/**
	 * C|[g
	 */
	public Node importNode(Node source, boolean deep) throws DOMException {
	ZDebug.trace("\t:import:"+source.toString());
	return super.importNode(source,deep);
	}

	/**
	 * adopt
	 */
	public Node adoptNode(Node source) {
	ZDebug.trace("\t:adopt:"+source.toString());
	return super.adoptNode(source);
	}

	/**
	 * Identifierǉ
	 */
	public void putIdentifier(String idName, Element element) {
	ZDebug.trace("\t:putIdentifier:"+idName+","+element.toString());
	super.putIdentifier(idName,element);
	}

	/**
	 * Identifier폜
	 */
	public void removeIdentifier(String idName) {
	ZDebug.trace("\t:removeIdentifier:"+idName);
	super.removeIdentifier(idName);
	}

	//## I[oChFDOM2 NameSpace t@Ng[ ####################
	/**
	 * Gg
	 */
	public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
	ZDebug.trace("\t:create:"+namespaceURI+","+qualifiedName);
	return new XElementNS(this,namespaceURI,qualifiedName);
//	return super.createElementNS(namespaceURI,qualifiedName);
	}

	/**
	 * Agr[g
	 */
	public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
//	ZDebug.trace("\t:create:"+namespaceURI+","+qualifiedName);
	return super.createAttributeNS(namespaceURI,qualifiedName);
	}

	//## fobO #####################################################
	public static void dump(Node node) {
	switch ( node.getNodeType() ) {
	  case Node.DOCUMENT_NODE :
		ZDebug.trace("DumpDocument:"+node);
		DocumentType doctype = ( (Document) node ).getDoctype();
		ZDebug.trace("    doctype:"+doctype);
		break;
	  default:
		ZDebug.trace("Dump:"+node);
		break;
	}
	}

    /** Ensures that the internal tables are large enough. */
/*
    protected boolean ensureCapacity(int chunk, int index) {
	ZDebug.trace("!!!!");
	return super.ensureCapacity(chunk, index);
	}
*/
/*
    public short getNodeType(int nodeIndex, boolean free) {
	ZDebug.trace("!!!!fNodeType.length:"+fNodeType.length);
//DEBUG_PRINT_REF_COUNTS = true;
        int chunk = nodeIndex >> CHUNK_SHIFT;
        int index = nodeIndex & CHUNK_MASK;
			ZDebug.trace( "chunk:"+chunk+"\tindex:"+index);
            if (fNodeType[chunk] != null) {
					ZDebug.trace("\tfNodeType:"+fNodeType[chunk][index]);
			} else {
				ZDebug.trace( "fNodeType[chunk]=null");
			}
	        return super.getNodeType(nodeIndex, free);
    } // getNodeType(int):int
*/
	//## Agr[g################################################
	/**
	 * Fob}l[W
	 */
	protected FobManager	mFobManager = new FobManager();
}
