/**
 * @(#)DocUI.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 *
 * UI
 */
package jp.co.iti.fagot.doc;

import java.awt.Container;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

import java.util.Hashtable;
import java.util.Enumeration;

import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;
/**
 * DocpbP[WpComponentUI
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class DocUI extends ComponentUI {

	/**
	 * B̃RXgN^łB
	 */
	public DocUI() {
	super();
	}

	/**
	 * UI̐
	 */
	public static ComponentUI createUI(JComponent c) {
	return( new DocUI() );
	}

	/**
	 * UI̐ݒ
	 */
	public void installUI(JComponent cmp) {
//	mEditor = cmp;

	cmp.setBackground(Color.white);
	cmp.setForeground(Color.black);
	cmp.setOpaque(true);
	cmp.setAutoscrolls(true);

	cmp.setLayout(mLayout);
	}

	/**
	 * UỈ
	 */
	public void uninstallUI(JComponent cmp) {
	cmp.setLayout(mLayout);
	}

	/**
	 * ʕ\̍XV
	 */
	public void update(Graphics g, JComponent cmp) {
	paint(g, cmp);
	}

	/**
	 * ʕ\
	 */
	public void paint(Graphics g, JComponent cmp) {
	if ( mPainting ) {
		mGraphics = g;
		return ;
	}
	mPainting = true;
	mGraphics = null;

	try {
		DocPane editor = (DocPane)cmp;
			
		// 쒆ȂǕ`łȂꍇ́A`悵Ȃ
		if ( !editor.canPaint() ) {
			mPainting = false;
			return;
		}

		// wi̕`
		if ( editor.isOpaque() ) {
			g.setColor(editor.getBackground());
			// ʂ̕\Ă̈悾NA悤ɏC
			Rectangle clipRect = g.getClipBounds();
			if ( clipRect != null ) {
				g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
			} else {
				g.fillRect(0, 0, editor.getWidth(), editor.getHeight());
			}
		}

		// Gob̍č\zKvH
		boolean isCreateGob = false;
		if ( editor.isUpdateGobs() ) {
			isCreateGob = true;
			editor.createGobs();
		}

		// Graphics ̍쐬
		DocGraphics graphics = new DocGraphics((Graphics2D)g,editor.getGridControler(),isCreateGob);

		GobManager.paint( editor, graphics );

		GobManager.paintCurrent( editor, graphics );

		// 2dyCgꍇ͍ăyCg
		Graphics gSave = mGraphics;
		while ( gSave != null ) {
			mGraphics = null;
			editor.repaint();

			// `撆paintĂ΂ꂽH
			gSave = mGraphics;
			mPainting = true;
		}
	} catch ( Throwable t ) {
		ZDebug.err("!!!ExceptionF"+t.toString() );
		t.printStackTrace();
		RidMessage ridMsg = new RidMessage();
		MessageDialog.showError(ridMsg.Error("E1900",t.toString()));
		System.exit(0);
	}

	mPainting = false;
	}

	//## TuNXFCAEg}l[W #############################
	/**
	 * Xi[
	 */
	class DocLayout implements LayoutManager{

	//## LayoutManager2 ###############################################
	/**
	 * R|[lg̒ǉ
	 */
	public void addLayoutComponent(String name, Component comp) {
	if ( name.startsWith("Doc") ) {
		mComponents.put(comp,name);
	}
	}

	/**
	 * R|[lg̍폜
	 */
	public void removeLayoutComponent(Component comp) {
	if ( mComponents.containsKey( comp ) ) {
		mComponents.remove( comp );
	}
	}

	/**
	 * ŏTCY̎擾
	 */
	public Dimension minimumLayoutSize(Container parent) {
    return(null);
	}

	/**
	 * TCY̎擾
	 */
	public Dimension preferredLayoutSize(Container parent) {
    return(null);
	}

	/**
	 * CAEg̐ݒ
	 */
	public void layoutContainer(Container parent) {
	Enumeration elm = mComponents.keys();
	boolean bFirst = true;
	while ( elm.hasMoreElements() ) {
		Component cmp = (Component)elm.nextElement();
		String szRect = (String)mComponents.get( cmp );
		String[] posInfo = ZString.tokenize( szRect ) ;
		if ( posInfo.length == 5 ) {
			double dX      = ZString.parseDouble(posInfo[1],0);
			double dY      = ZString.parseDouble(posInfo[2],0);
			double dWidth  = ZString.parseDouble(posInfo[3],0);
			double dHeight = ZString.parseDouble(posInfo[4],0);
			cmp.setBounds((int)dX,(int)dY,(int)dWidth,(int)dHeight);
			if ( bFirst ) {
				bFirst = false;
				cmp.requestFocus();
			}
		} else {
			ZDebug.trace("  ~layout:"+szRect);
		}
	}
	}

	/**
	 * R|[lgꗗ
	 */
	protected Hashtable mComponents = new Hashtable();

	}

	//## Agr[g################################################
	/**
	 * CAEg}l[W
	 */
	protected DocLayout mLayout = new DocLayout() ;

	/**
	 * `撆H
	 */
	protected boolean	mPainting = false ;

	/**
	 * `撆̏ꍇɕۑGraphics
	 */
	protected Graphics	mGraphics = null ;
}
