/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.table.editor.CECAdapter;
import jp.co.nri.rid.table.editor.ColorCEC;
import jp.co.nri.rid.table.editor.RCellEditor;
import jp.co.nri.rid.table.editor.TextCEC;
import jp.co.nri.rid.table.editor.iCellEditorComponent;
import jp.co.nri.rid.table.editor.iChildReloadable;
import jp.co.nri.rid.table.editor.iReloadable;
import jp.co.nri.rid.xml.elementBooster;
import org.w3c.dom.Element;

public class PaneledElementFactory {
    public static final String BORDERLAYOUT = "BorderLayout";
    public static final String FLOWLAYOUT = "FlowLayout";
    public static final String BOXLAYOUT = "BoxLayout";
    public static final String GRIDLAYOUT = "GridLayout";
    public static final String TABLE = "Table";
    public static final String SCROLL = "scroll";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String AXIS = "axis";
    public static final String AXISX = "x";
    public static final String AXISY = "y";
    public static final String FILL = "fill";
    public static final String ALIGN = "align";
    public static final String VALIGN = "valign";
    public static final String COLSPAN = "colspan";
    public static final String ROWSPAN = "rowspan";
    public static final String EDITABLE = "editable";
    public static final String RESIZEBLE = "resizeble";
    public static final String WIDTH = "width";
    public static final String CELLPADDING = "cellpadding";
    public static final String CENTER = "center";
    public static final String NORTH = "north";
    public static final String SOUTH = "south";
    public static final String EAST = "east";
    public static final String WEST = "west";
    public static final String TR = "tr";
    public static final String TD = "td";
    public static final String LABEL = "label";
    public static final String TEXT = "text";
    public static final String RIDEDITOR = "RidEditor";
    public static final String ACTION = "action";
    public static final String CHILD = "child";
    public static final String ATTRIBUTE = "attribute";
    public static final String STRING = "string";
    public static final String FALSE = "false";
    public static final String HORIZONTAL = "horizontal";
    public static final String VERTICAL = "vertical";
    public static final String BOTH = "both";
    public static final String CENTERs = "center";
    public static final String LEFTs = "left";
    public static final String RIGHTs = "right";
    public static final String MIDDLEs = "middle";
    public static final String TOPs = "top";
    public static final String BOTTOMs = "bottom";
    public static final int CENTERi = 0;
    public static final int LEFTi = 1;
    public static final int RIGHTi = 2;
    public static final int MIDDLEi = 0;
    public static final int TOPi = 16;
    public static final int BOTTOMi = 32;
    public static final int TOPLEFTi = 17;
    public static final int TOPRIGHTi = 18;
    public static final int BOTTOMLEFTi = 33;
    public static final int BOTTOMRIGHTi = 34;
    public elementBooster myElement;

    public JComponent PaneledElement(Element element, Element element2) {
        return this.PaneledElement(new elementBooster(element), new elementBooster(element2));
    }

    public JComponent PaneledElement(elementBooster elementBooster2) {
        return this.PaneledElement(this.myElement, elementBooster2);
    }

    public JComponent PaneledElement(elementBooster elementBooster2, elementBooster elementBooster3) {
        if (null == elementBooster2) {
            return null;
        }
        if (null == elementBooster3) {
            return null;
        }
        this.myElement = elementBooster2;
        JComponent jComponent = null;
        String string = elementBooster3.tagname();
        if (BORDERLAYOUT.equals(string)) {
            jComponent = this.caseBorderLayout(elementBooster3);
        } else if (TABLE.equals(string)) {
            jComponent = this.caseGridBagLayout(elementBooster3);
        } else if (FLOWLAYOUT.equals(string)) {
            jComponent = this.caseFlowLayout(elementBooster3);
        } else if (BOXLAYOUT.equals(string)) {
            jComponent = this.caseBoxLayout(elementBooster3);
        } else if (GRIDLAYOUT.equals(string)) {
            jComponent = this.caseGridLayout(elementBooster3);
        } else if (LABEL.equals(string)) {
            jComponent = this.caseLabel(elementBooster3);
        } else if (TEXT.equals(string)) {
            jComponent = this.caseText(elementBooster3);
        } else if (RIDEDITOR.equals(string)) {
            jComponent = this.caseRidEditor(elementBooster3);
        }
        return jComponent;
    }

    protected JPanel caseGridBagLayout(elementBooster elementBooster2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        elementBooster[] elementBoosterArray = elementBooster2.children(TR);
        if (null != elementBoosterArray) {
            int n = 0;
            try {
                n = Integer.parseInt(elementBooster2.attribute(CELLPADDING));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = elementBoosterArray.length;
            for (int i = 0; i < n2; ++i) {
                this.addTR(jPanel, gridBagLayout, elementBoosterArray[i], n);
            }
        }
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected void addTR(JPanel jPanel, GridBagLayout gridBagLayout, elementBooster elementBooster2, int n) {
        Serializable serializable;
        elementBooster[] elementBoosterArray = elementBooster2.children(TD);
        int n2 = elementBoosterArray.length;
        for (int i = 0; i < n2; ++i) {
            serializable = this.PaneledElement(elementBoosterArray[i].children()[0]);
            if (null == serializable) continue;
            gridBagLayout.setConstraints((Component)serializable, this.constraints(elementBoosterArray[i], n));
            jPanel.add((Component)serializable);
        }
        JPanel jPanel2 = new JPanel();
        serializable = new GridBagConstraints();
        serializable.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, (GridBagConstraints)serializable);
        jPanel.add(jPanel2);
    }

    protected GridBagConstraints constraints(elementBooster elementBooster2, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        String string = elementBooster2.attribute(ALIGN);
        int n2 = null == string ? 0 : ("center".equals(string) ? 0 : (LEFTs.equals(string) ? 1 : (RIGHTs.equals(string) ? 2 : 0)));
        String string2 = elementBooster2.attribute(VALIGN);
        n2 = null == string2 ? (n2 += 0) : (MIDDLEs.equals(string2) ? (n2 += 0) : (TOPs.equals(string2) ? (n2 += 16) : (BOTTOMs.equals(string2) ? (n2 += 32) : (n2 += 0))));
        switch (n2) {
            case 0: {
                gridBagConstraints.anchor = 10;
                break;
            }
            case 1: {
                gridBagConstraints.anchor = 17;
                break;
            }
            case 2: {
                gridBagConstraints.anchor = 13;
                break;
            }
            case 16: {
                gridBagConstraints.anchor = 11;
                break;
            }
            case 32: {
                gridBagConstraints.anchor = 15;
                break;
            }
            case 17: {
                gridBagConstraints.anchor = 18;
                break;
            }
            case 18: {
                gridBagConstraints.anchor = 12;
                break;
            }
            case 33: {
                gridBagConstraints.anchor = 16;
                break;
            }
            case 34: {
                gridBagConstraints.anchor = 14;
            }
        }
        try {
            gridBagConstraints.gridwidth = Integer.parseInt(elementBooster2.attribute(COLSPAN));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            gridBagConstraints.gridheight = Integer.parseInt(elementBooster2.attribute(ROWSPAN));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            gridBagConstraints.weightx = Double.parseDouble(elementBooster2.attribute(WIDTH));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return gridBagConstraints;
    }

    protected JPanel caseBorderLayout(elementBooster elementBooster2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        elementBooster elementBooster3 = elementBooster2.child("center");
        this.add(jPanel, "Center", elementBooster3);
        elementBooster3 = elementBooster2.child(NORTH);
        this.add(jPanel, "North", elementBooster3);
        elementBooster3 = elementBooster2.child(SOUTH);
        this.add(jPanel, "South", elementBooster3);
        elementBooster3 = elementBooster2.child(EAST);
        this.add(jPanel, "East", elementBooster3);
        elementBooster3 = elementBooster2.child(WEST);
        this.add(jPanel, "West", elementBooster3);
        return jPanel;
    }

    protected JPanel caseFlowLayout(elementBooster elementBooster2) {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.add(jPanel, null, elementBooster2);
        return jPanel;
    }

    protected JPanel caseBoxLayout(elementBooster elementBooster2) {
        JPanel jPanel = new JPanel();
        String string = elementBooster2.attribute(AXIS);
        if (AXISY.equals(string)) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
        } else {
            jPanel.setLayout(new BoxLayout(jPanel, 0));
        }
        this.add(jPanel, null, elementBooster2);
        return jPanel;
    }

    protected JPanel caseGridLayout(elementBooster elementBooster2) {
        int n = elementBooster2.attributeInt(ROWS);
        int n2 = elementBooster2.attributeInt(COLUMNS);
        JPanel jPanel = new JPanel(new GridLayout(n, n2));
        this.add(jPanel, null, elementBooster2);
        return jPanel;
    }

    protected JTextField caseText(elementBooster elementBooster2) {
        FocusListener focusListener;
        JTextField jTextField = new JTextField();
        String string = elementBooster2.attribute(CHILD);
        if (null != string) {
            focusListener = new ElementListener(this.myElement, string, jTextField);
            jTextField.addFocusListener(focusListener);
            jTextField.addAncestorListener((AncestorListener)((Object)focusListener));
        }
        if (null != (string = elementBooster2.attribute(ATTRIBUTE))) {
            focusListener = new AttributeListener(this.myElement, string, jTextField);
            jTextField.addFocusListener(focusListener);
            jTextField.addAncestorListener((AncestorListener)((Object)focusListener));
        }
        return jTextField;
    }

    protected JComponent caseRidEditor(elementBooster elementBooster2) {
        String string = elementBooster2.attribute(ATTRIBUTE);
        if (null == string) {
            return null;
        }
        ZProperties zProperties = DocManager.loadProperty("element");
        String string2 = zProperties.getProperty("attributes." + string + ".type");
        if (null == string2) {
            return null;
        }
        boolean bl = true;
        if (FALSE.equals(elementBooster2.attribute(EDITABLE))) {
            bl = false;
        }
        iCellEditorComponent iCellEditorComponent2 = new RCellEditor(string2, bl, new CECAdapter(this.myElement, string)).CEC();
        String string3 = this.myElement.attribute(string);
        if (iCellEditorComponent2 instanceof iReloadable) {
            ((iReloadable)((Object)iCellEditorComponent2)).reload();
        }
        if (iCellEditorComponent2 instanceof iChildReloadable) {
            ((iChildReloadable)((Object)iCellEditorComponent2)).reload(this.myElement);
        }
        iCellEditorComponent2.text(string3);
        if (iCellEditorComponent2 instanceof TextCEC) {
            AttributeListener attributeListener = new AttributeListener(this.myElement, string, (TextCEC)iCellEditorComponent2);
            ((TextCEC)iCellEditorComponent2).addFocusListener(attributeListener);
            ((TextCEC)iCellEditorComponent2).addAncestorListener(attributeListener);
        } else if (iCellEditorComponent2 instanceof ColorCEC) {
            ColorAttributeListener colorAttributeListener = new ColorAttributeListener(this.myElement, string, (ColorCEC)iCellEditorComponent2);
            ((ColorCEC)iCellEditorComponent2).getTextField().addActionListener(colorAttributeListener);
            ((ColorCEC)iCellEditorComponent2).getTextField().addFocusListener(colorAttributeListener);
            ((ColorCEC)iCellEditorComponent2).getTextField().addAncestorListener(colorAttributeListener);
        }
        return iCellEditorComponent2.component();
    }

    protected JLabel caseLabel(elementBooster elementBooster2) {
        return new JLabel(elementBooster2.attribute(STRING));
    }

    protected void add(JPanel jPanel, String string, elementBooster elementBooster2) {
        if (null == jPanel) {
            return;
        }
        if (null == elementBooster2) {
            return;
        }
        elementBooster[] elementBoosterArray = elementBooster2.children();
        int n = elementBoosterArray.length;
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = this.PaneledElement(elementBoosterArray[i]);
            if (null == jComponent) continue;
            jPanel.add((Component)jComponent, string);
        }
    }

    private class ColorAttributeListener
    extends AttributeListener
    implements ActionListener {
        private ColorCEC cec;

        public ColorAttributeListener(elementBooster elementBooster2, String string, ColorCEC colorCEC) {
            super(elementBooster2, string, colorCEC.getTextField());
            this.cec = colorCEC;
        }

        private boolean chgColor() {
            String string = this.myText.getText();
            if (null == string) {
                return false;
            }
            int n = 0;
            try {
                n = this.cec.hex(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            this.cec.ButtonColor(n);
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.chgColor();
        }

        protected void write() {
            if (this.chgColor()) {
                super.write();
            }
        }
    }

    protected class AttributeListener
    implements FocusListener,
    AncestorListener {
        protected elementBooster myElement;
        protected String myAttributeName;
        protected JTextField myText;

        public AttributeListener(elementBooster elementBooster2, String string, JTextField jTextField) {
            this.myElement = elementBooster2;
            this.myAttributeName = new String(string);
            this.myText = jTextField;
            this.read();
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            this.write();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.write();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.read();
        }

        protected void write(String string) {
            if (null != string && 0 >= string.length()) {
                string = null;
            }
            if (!this.myText.isShowing()) {
                return;
            }
            if (ZInstance.prop().getBoolean("messagedialog.isShowing", false)) {
                return;
            }
            String string2 = this.myElement.attribute(this.myAttributeName);
            if (null == string ? null == string2 : string.equalsIgnoreCase(string2)) {
                return;
            }
            if (this.myElement.element().getParentNode() == null) {
                return;
            }
            boolean bl = ((DocDocument)((Object)this.myElement.document().document())).isTransaction();
            if (!bl) {
                ((DocDocument)((Object)this.myElement.document().document())).beginTransaction();
            }
            this.myElement.attribute(this.myAttributeName, string);
            if (!bl) {
                ((DocDocument)((Object)this.myElement.document().document())).commit();
            }
            String string3 = this.myElement.attribute(this.myAttributeName);
            if (null == string) {
                if (null == string3) {
                    RUpdateManager.update(65535);
                    return;
                }
            } else if (string.equalsIgnoreCase(string3)) {
                RUpdateManager.update(65535);
                return;
            }
            RidException ridException = (RidException)ZInstance.map().get("setAttribute");
            MessageDialog.showError(ridException.getMessage());
        }

        protected void write() {
            this.write(this.myText.getText());
        }

        protected void read() {
            String string = this.myElement.attribute(this.myAttributeName);
            if (null == string) {
                return;
            }
            this.myText.setText(string);
        }
    }

    protected class ElementListener
    implements FocusListener,
    AncestorListener {
        protected elementBooster myElement;
        protected String myChildName;
        protected JTextField myText;

        public ElementListener(elementBooster elementBooster2, String string, JTextField jTextField) {
            this.myElement = elementBooster2;
            this.myChildName = new String(string);
            this.myText = jTextField;
            this.read();
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            this.write();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.read();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.write();
        }

        protected void write() {
            elementBooster elementBooster2;
            String string = this.myText.getText();
            if (null != string && 0 >= string.length()) {
                string = null;
            }
            if (!this.myText.isShowing()) {
                return;
            }
            String string2 = null;
            try {
                string2 = this.myElement.child(this.myChildName).text();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (null == string ? null == string2 : string.equalsIgnoreCase(string2)) {
                return;
            }
            if (this.myElement.element().getParentNode() == null) {
                return;
            }
            boolean bl = ((DocDocument)((Object)this.myElement.document().document())).isTransaction();
            if (!bl) {
                ((DocDocument)((Object)this.myElement.document().document())).beginTransaction();
            }
            if (null == (elementBooster2 = this.myElement.child(this.myChildName))) {
                elementBooster2 = this.myElement.add(this.myChildName);
            }
            elementBooster2.text(string);
            if (!bl) {
                ((DocDocument)((Object)this.myElement.document().document())).commit();
            }
            String string3 = elementBooster2.text();
            if (null == string) {
                if (null == string3) {
                    RUpdateManager.update(65535);
                    return;
                }
            } else if (string.equalsIgnoreCase(string3)) {
                RUpdateManager.update(65535);
                return;
            }
        }

        protected void read() {
            elementBooster elementBooster2 = this.myElement.child(this.myChildName);
            if (null == elementBooster2) {
                return;
            }
            String string = elementBooster2.text();
            if (null == string) {
                return;
            }
            this.myText.setText(string);
        }
    }
}

