/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.Option;
import jp.co.nri.rid.web.HTMLDocumentEx;
import jp.co.nri.rid.web.HTMLEditorKitEx;
import jp.co.nri.rid.web.HashVector;
import jp.co.nri.rid.web.Hashtable2D;

public class WebPage {
    private Hashtable2D myKeytable = null;
    private Reader myReader = null;
    private HashVector myList;

    public WebPage() {
    }

    public WebPage(Reader reader) {
        this.setPage(reader);
    }

    public void setPage(Reader reader) {
        this.myReader = reader;
    }

    public void setPage(URL uRL) throws IOException, UnsupportedEncodingException {
        this.setPage(uRL.openStream());
    }

    public void setPage(File file) throws FileNotFoundException, UnsupportedEncodingException {
        this.setPage(new FileInputStream(file));
    }

    public void setPage(InputStream inputStream) throws UnsupportedEncodingException {
        this.myReader = new BufferedReader(new InputStreamReader(inputStream, "JISAutoDetect"));
    }

    public void setKeytable(Hashtable2D hashtable2D) {
        this.myKeytable = hashtable2D;
    }

    public HashVector get() throws IOException, BadLocationException {
        String string;
        this.myList = new HashVector();
        HTMLDocumentEx hTMLDocumentEx = new HTMLDocumentEx();
        hTMLDocumentEx.putProperty("IgnoreCharsetDirective", new Boolean(true));
        HTMLEditorKitEx hTMLEditorKitEx = new HTMLEditorKitEx();
        hTMLEditorKitEx.read(this.myReader, (Document)hTMLDocumentEx, 0);
        AttributeSet[] attributeSetArray = hTMLDocumentEx.areas.toArray(new AttributeSet[0]);
        if (null != attributeSetArray) {
            for (int i = attributeSetArray.length - 1; 0 <= i; --i) {
                this.scanAttribute("area", attributeSetArray[i]);
            }
        }
        if (null != (string = (String)hTMLDocumentEx.getProperty("title"))) {
            this.myList.add("Title", string);
        }
        this.scanTag(hTMLDocumentEx.getDefaultRootElement());
        return this.myList;
    }

    private void scanTag(Element element) {
        this.scanAttribute(element.getName().toLowerCase(), element.getAttributes());
        if (element.isLeaf()) {
            return;
        }
        for (int i = element.getElementCount() - 1; 0 <= i; --i) {
            this.scanTag(element.getElement(i));
        }
    }

    private void scanAttribute(String string, AttributeSet attributeSet) {
        boolean bl = false;
        Hashtable hashtable = null;
        if (null == this.myKeytable) {
            bl = true;
        } else {
            hashtable = this.myKeytable.get(string);
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            DefaultComboBoxModel<Object> defaultComboBoxModel;
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            if (object instanceof AttributeSet) {
                this.scanAttribute(obj.toString().toLowerCase(), (AttributeSet)object);
                continue;
            }
            if (object instanceof DefaultComboBoxModel) {
                defaultComboBoxModel = (DefaultComboBoxModel)object;
                for (int i = defaultComboBoxModel.getSize() - 1; 0 <= i; --i) {
                    Object object2 = defaultComboBoxModel.getElementAt(i);
                    if (!(object2 instanceof Option)) continue;
                    this.scanAttribute(obj.toString().toLowerCase(), ((Option)object2).getAttributes());
                }
                continue;
            }
            if (null != hashtable) {
                defaultComboBoxModel = hashtable.get(obj.toString().toLowerCase());
                if (null == defaultComboBoxModel) continue;
                this.myList.add(defaultComboBoxModel, object.toString());
                continue;
            }
            if (!bl) continue;
            this.myList.add(string + " " + obj.toString().toLowerCase(), object.toString());
        }
    }
}

