/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.generator;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.environment.EnvDialog;

public class GeneratorDialog {
    public static final String GENERATE_PAGE = "generate.page";
    public static final String GENERATE_SITEMAP = "generate.sitemap";
    public static final String GENERATE_BROWSER = "generate.browser";
    public static final String MSG_GENERATE_TITLE = "msg.generate.title";
    public static final String MSG_GENERATE_PAGE = "msg.generate.page";
    public static final String MSG_GENERATE_GENERATE = "msg.generate.generate";
    public static final String MSG_GENERATE_SITEMAP = "msg.generate.sitemap";
    public static final String MSG_GENERATE_BROWSER = "msg.generate.browser";
    protected JPanel mPanel = null;
    protected JCheckBox mBrowser = null;
    protected JComboBox mBrowserLst = null;
    protected JCheckBox mPage = null;
    protected JCheckBox mSitemap = null;

    public boolean show() {
        ZResource zResource = ZApp.getTheApp().getResource();
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog envDialog = new EnvDialog(jFrame, zResource.getString(MSG_GENERATE_TITLE));
        this.mPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.createLabelConstraints();
        GridBagConstraints gridBagConstraints2 = this.createComponentConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(zResource.getString(MSG_GENERATE_GENERATE));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        JPanel jPanel = this.generateCheckBox();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints2);
        this.mPanel.add(jPanel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jLabel = new JLabel(zResource.getString(MSG_GENERATE_BROWSER));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 1;
        JPanel jPanel2 = this.browserCheckBox();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints2);
        this.mPanel.add(jPanel2);
        envDialog.setControlPanel(this.mPanel);
        envDialog.doModal();
        boolean bl = envDialog.isOK();
        if (bl) {
            this.setGenerate();
        }
        return bl;
    }

    private JPanel generateCheckBox() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.createComponentConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.mPage = this.createGenerateCheckBox(MSG_GENERATE_PAGE, GENERATE_PAGE);
        gridBagLayout.setConstraints(this.mPage, gridBagConstraints);
        jPanel.add(this.mPage);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.mSitemap = this.createGenerateCheckBox(MSG_GENERATE_SITEMAP, GENERATE_SITEMAP);
        gridBagLayout.setConstraints(this.mSitemap, gridBagConstraints);
        jPanel.add(this.mSitemap);
        return jPanel;
    }

    private JCheckBox createGenerateCheckBox(String string, String string2) {
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl = zResource.getBoolean(string2);
        String string3 = zResource.getString(string);
        JCheckBox jCheckBox = new JCheckBox(string3);
        jCheckBox.setSelected(bl);
        return jCheckBox;
    }

    private JPanel browserCheckBox() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.createComponentConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.mBrowser = this.createBrowserCheckBox();
        gridBagLayout.setConstraints(this.mBrowser, gridBagConstraints);
        jPanel.add(this.mBrowser);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        this.mBrowserLst = this.createBrowserComboBox();
        gridBagLayout.setConstraints(this.mBrowserLst, gridBagConstraints);
        jPanel.add(this.mBrowserLst);
        return jPanel;
    }

    private JCheckBox createBrowserCheckBox() {
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl = zResource.getBoolean(GENERATE_BROWSER);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        return jCheckBox;
    }

    private JComboBox createBrowserComboBox() {
        String string;
        String string2;
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        ZResource zResource = ZApp.getTheApp().getResource();
        int n = 1;
        while ((string2 = zResource.getString(string = "generate.browser_command." + Integer.toString(n))) != null) {
            jComboBox.addItem(this.makeObj(string2));
            ++n;
        }
        return jComboBox;
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private void setGenerate() {
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putBoolean(GENERATE_PAGE, this.mPage.isSelected());
        zResource.putBoolean(GENERATE_SITEMAP, this.mSitemap.isSelected());
        zResource.putBoolean(GENERATE_BROWSER, this.mBrowser.isSelected());
        int n = this.mBrowserLst.getSelectedIndex();
        String string = "generate.browser_command." + Integer.toString(n + 1);
        zResource.putString("generate.browser_command", zResource.getString(string));
    }

    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        return gridBagConstraints;
    }

    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        return gridBagConstraints;
    }

    private void ctlBrowser() {
        if (this.mSitemap.isSelected()) {
            this.mBrowser.setEnabled(true);
            this.mBrowserLst.setEnabled(true);
        } else {
            this.mBrowser.setEnabled(false);
            this.mBrowser.setSelected(false);
            this.mBrowserLst.setEnabled(false);
        }
    }
}

