/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.export;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.export.ExportDialog;
import jp.co.nri.rid.export.exporter;

public class ExportCsvDialog {
    protected JPanel mPanel = null;
    protected JTextField mImportComment = null;

    public boolean show(String string) {
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        ExportDialog exportDialog = new ExportDialog(jFrame, "CSV");
        this.mPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mPanel.add(new JLabel("Comment"));
        gridBagConstraints.gridx = 1;
        this.mImportComment = this.createImportComment();
        gridBagLayout.setConstraints(this.mImportComment, gridBagConstraints);
        this.mPanel.add(this.mImportComment);
        exportDialog.setControlPanel(this.mPanel);
        exportDialog.getRootPane().setDefaultButton(exportDialog.getOKButton());
        exportDialog.doModal();
        boolean bl = exportDialog.isOK();
        if (bl) {
            this.showCSV(string);
        }
        return bl;
    }

    private JTextField createImportComment() {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string = zResource.getString("csv.comment");
        JTextField jTextField = new JTextField(string, 35);
        return jTextField;
    }

    private String getCSVComment() {
        String string = this.mImportComment.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private void showCSV(String string) {
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putString("csv.comment", this.getCSVComment());
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.document"));
        docDocument.beginTransaction();
        try {
            String string2 = ZInstance.prop().getProperty("pj.dir");
            ZResource zResource2 = ZApp.getTheApp().getResource();
            String string3 = string2 + File.separator + zResource2.getString("rid.docs.dir");
            exporter exporter2 = new exporter();
            exporter2.export(string3, string, 2);
            docDocument.commit();
        }
        catch (Throwable throwable) {
            ZDebug.trace("failed");
            throwable.printStackTrace();
            docDocument.rollback();
        }
    }
}

