/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.environment.EnvCheckBoxText;
import jp.co.nri.rid.environment.EnvColorEditor;
import jp.co.nri.rid.environment.EnvDialog;
import jp.co.nri.rid.environment.EnvDocumentList;
import jp.co.nri.rid.environment.EnvRadioButton;
import jp.co.nri.rid.environment.EnvRadioText;
import jp.co.nri.rid.environment.EnvSeparator;
import jp.co.nri.rid.environment.EnvTextField;

public class EnvironmentDialog {
    protected JPanel mPanel = null;
    protected GridBagLayout mLayout = null;
    EnvTextField mRidualDir;
    EnvCheckBoxText mGrid;
    EnvTextField mSvg;
    EnvRadioButton mLookFeel;
    EnvRadioText mBrowser;
    EnvRadioText mHtmlEdit;
    EnvTextField mTextEdit;
    EnvColorEditor mColorZone;
    EnvColorEditor mColorPage;
    EnvColorEditor mColorLink;
    EnvColorEditor mColorReal;
    EnvColorEditor mColorUrl;
    EnvColorEditor mColorMapHier;
    EnvColorEditor mColorMapSite;
    EnvColorEditor mColorMapCircle;
    EnvColorEditor mColorNotExist;
    EnvColorEditor mColorScenarioItem;
    EnvRadioButton mStartHtml;
    EnvDocumentList mDocList;
    boolean mEnvFirst;
    static String MSG_ENVIRONMENT_TITLE = "msg.environment.title";
    static String APP_INSTALL_PATH = "app.install.path";
    static String EDIT_GRID = "edit.grid";
    static String EDIT_GRIDSIZE = "edit.gridsize";
    static String APP_LOOKANDFEEL = "app.lookandfeel";
    static String GEN_BROWSER_CMD = "generate.browser_command";
    static String GEN_BROWSER_CMD_1 = "generate.browser_command.1";
    static String GEN_BROWSER_CMD_2 = "generate.browser_command.2";
    static String CMD_HTML_EDITOR = "command.html.editor";
    static String CMD_HTML_EDITOR_1 = "command.html.editor.1";
    static String CMD_HTML_EDITOR_2 = "command.html.editor.2";
    static String CMD_TEXT_EDITOR = "command.text.editor";
    static String UNIT_CLR_ZONEUNIT = "unit.color.ZoneUnit";
    static String UNIT_CLR_PAGEUNIT = "unit.color.PageUnit";
    static String UNIT_CLR_LINKUNIT = "unit.color.LinkUnit";
    static String UNIT_CLR_STRONG = "unit.color.StrongLink";
    static String UNIT_CLR_URLUNIT = "unit.color.UrlUnit";
    static String UNIT_CLR_ACCESSCOUNT = "unit.color.AccessCount";
    static String UNIT_CLR_PANEL_PAGE = "panel.color.page";
    static String UNIT_CLR_MAP_HIER = "panel.color.Map.Hier";
    static String UNIT_CLR_MAP_SITE = "panel.color.Map.Site";
    static String UNIT_CLR_MAP_CIRCLE = "panel.color.Map.Circle";
    static String UNIT_CLR_NOT_EXIST = "unit.color.NotExist";
    static String UNIT_CLR_SCENARIO_ITEM = "unit.color.ScenarioItem";
    static String VIEWTEXT_ZONE_ZONEUNIT = "viewtext.Zone.ZoneUnit";
    static String VIEWTEXT_ZONE_PAGEUNIT = "viewtext.Zone.PageUnit";
    static String VIEWTEXT_ZONE_URLUNIT = "viewtext.Zone.UrlUnit";
    static String VIEWTEXT_MAP_PAGEUNIT = "viewtext.Map.PageUnit";
    static String NEWPROJECT_EDIT_HTML = "newproject.edit.html";
    static String ENV_FIRST = "env.first";
    static String SVG_LINEWIDTH = "svg.line.width";
    private static String[] mRadioHtml = new String[]{"On", "Off"};

    public boolean EnvDialog() throws Exception {
        JButton jButton;
        this.init();
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog envDialog = new EnvDialog(jFrame, this.getResString(MSG_ENVIRONMENT_TITLE));
        this.mPanel = new JPanel();
        this.mLayout = new GridBagLayout();
        this.mPanel.setLayout(this.mLayout);
        this.setPanelControl();
        envDialog.setControlPanel(this.mPanel);
        if (this.mEnvFirst) {
            jButton = envDialog.getCancelButton();
            jButton.setVisible(false);
        }
        jButton = new JButton("Apply");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvironmentDialog.this.onApply();
            }
        });
        envDialog.getButtonPanel().add(jButton);
        envDialog.doModal();
        boolean bl = envDialog.isOK();
        if (bl) {
            this.setEnvironment();
        }
        return bl;
    }

    private void init() {
        this.mEnvFirst = this.getResBoolean(ENV_FIRST);
    }

    private void setPanelControl() throws Exception {
        this.setPanelLabel(0, "\u3000");
        if (this.mEnvFirst) {
            this.setPanelRidualDir(1);
            this.setPanelSeparator(2);
        }
        this.setPanelGrid(3);
        this.setPanelSeparator(4);
        this.setPanelBrowser(5);
        this.setPanelSeparator(6);
        this.setPanelHtmlEdit(7);
        this.setPanelSeparator(9);
        this.setPanelTextEdit(10);
        this.setPanelDocumentList(11);
        this.setPanelSeparator(12);
        this.setPanelDefaultColor(13);
        this.setPanelSeparator(15);
        this.setPanelStartUp(16);
        this.setPanelSeparator(18);
        this.setPanelSVGLineWidth(19);
    }

    private void setPanelRidualDir(int n) throws Exception {
        String string = this.getResString(APP_INSTALL_PATH);
        if (this.isNullString(string)) {
            String string2 = this.getCurrentPath();
            File file = new File(string2);
            string = file.getParent();
        }
        this.mRidualDir = this.setPanelLabelText(n, "Ridual Dir", string, 1);
    }

    private void setPanelGrid(int n) throws Exception {
        this.mGrid = this.setPanelCheckBoxText(n, "Grid", this.getResBoolean(EDIT_GRID), this.getResString(EDIT_GRIDSIZE));
    }

    private void setPanelBrowser(int n) throws Exception {
        int n2 = 0;
        String string = this.getResString(GEN_BROWSER_CMD);
        String string2 = this.getResString(GEN_BROWSER_CMD_1);
        String string3 = this.getResString(GEN_BROWSER_CMD_2);
        if (string.equals(string2)) {
            n2 = 0;
        } else if (string.equals(string3)) {
            n2 = 1;
        }
        this.mBrowser = this.setPanelRadioText(n, "Browser", this.getResString(GEN_BROWSER_CMD_1), this.getResString(GEN_BROWSER_CMD_2), n2);
    }

    private void setPanelHtmlEdit(int n) throws Exception {
        int n2 = 0;
        String string = this.getResString(CMD_HTML_EDITOR);
        String string2 = this.getResString(CMD_HTML_EDITOR_1);
        String string3 = this.getResString(CMD_HTML_EDITOR_2);
        if (string.equals(string2)) {
            n2 = 0;
        } else if (string.equals(string3)) {
            n2 = 1;
        }
        this.mHtmlEdit = this.setPanelRadioText(n, "HTML Editor", this.getResString(CMD_HTML_EDITOR_1), this.getResString(CMD_HTML_EDITOR_2), n2);
    }

    private void setPanelTextEdit(int n) throws Exception {
        this.mTextEdit = this.setPanelLabelText(n, "TEXT Editor", this.getResString(CMD_TEXT_EDITOR), 2);
    }

    private void setPanelDocumentList(int n) throws Exception {
        this.mDocList = this.setPanelDocList(n, "Document List");
    }

    private void setPanelDefaultColor(int n) throws Exception {
        this.setPanelLabel(n, "Default Color");
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.mColorZone = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 0, 0, " Zone", this.getResString(UNIT_CLR_ZONEUNIT));
        this.mColorPage = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 0, 1, " Page", this.getResString(UNIT_CLR_PAGEUNIT));
        this.mColorLink = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 0, 2, " Link(Virtual)", this.getResString(UNIT_CLR_STRONG));
        this.mColorReal = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 0, 3, " Link(Real)", this.getResString(UNIT_CLR_LINKUNIT));
        this.mColorUrl = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 0, 4, " Url", this.getResString(UNIT_CLR_URLUNIT));
        this.mColorNotExist = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 2, 0, " NotExist", this.getResString(UNIT_CLR_NOT_EXIST));
        this.mColorMapHier = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 2, 1, " MapHier", this.getResString(UNIT_CLR_MAP_HIER));
        this.mColorMapSite = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 2, 2, " MapSite", this.getResString(UNIT_CLR_MAP_SITE));
        this.mColorMapCircle = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 2, 3, " MapCircle", this.getResString(UNIT_CLR_MAP_CIRCLE));
        this.mColorScenarioItem = this.setColorEditor(jPanel, gridBagLayout, gridBagConstraints, 2, 4, " ScenarioItem", this.getResString(UNIT_CLR_SCENARIO_ITEM));
        GridBagConstraints gridBagConstraints2 = this.createComponentConstraints();
        gridBagConstraints2.gridy = n + 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        this.mLayout.setConstraints(jPanel, gridBagConstraints2);
        this.mPanel.add(jPanel);
    }

    private EnvColorEditor setColorEditor(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, String string, String string2) {
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        JLabel jLabel = new JLabel(string);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        EnvColorEditor envColorEditor = new EnvColorEditor(string2);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.gridy = n2;
        gridBagLayout.setConstraints(envColorEditor.getPanel(), gridBagConstraints);
        jPanel.add(envColorEditor.getPanel());
        return envColorEditor;
    }

    private void setPanelStartUp(int n) {
        this.setPanelLabel(n, "Start-Up");
        this.mStartHtml = this.setPanelRadioButton(n + 1, "  HTML-Editor", mRadioHtml, this.getStartUp(NEWPROJECT_EDIT_HTML));
    }

    private String getStartUp(String string) {
        boolean bl = this.getResBoolean(string);
        if (bl) {
            return "On";
        }
        return "Off";
    }

    private void setPanelSVGLineWidth(int n) throws Exception {
        this.mSvg = this.setPanelLabelTextLabel(n, "SVG Line Width ", this.getResString(SVG_LINEWIDTH), "\u3000%\u3000");
    }

    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        return gridBagConstraints;
    }

    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        return gridBagConstraints;
    }

    private void setPanelLabel(int n, String string) {
        this.setPanelLayoutLabel(n, string);
    }

    private EnvTextField setPanelLabelText(int n, String string, String string2, int n2) {
        EnvTextField envTextField = new EnvTextField(string2, n2);
        this.setPanelLayoutLabel(n, string);
        this.setPanelLayoutComponent(n, envTextField.getPanel());
        return envTextField;
    }

    private EnvTextField setPanelLabelTextLabel(int n, String string, String string2, String string3) {
        EnvTextField envTextField = new EnvTextField(string2, string3);
        this.setPanelLayoutLabel(n, string);
        this.setPanelLayoutComponent(n, envTextField.getPanel());
        return envTextField;
    }

    private EnvCheckBoxText setPanelCheckBoxText(int n, String string, boolean bl, String string2) {
        EnvCheckBoxText envCheckBoxText = new EnvCheckBoxText(bl, string2);
        this.setPanelLayoutLabel(n, string);
        this.setPanelLayoutComponent(n, envCheckBoxText.getPanel());
        return envCheckBoxText;
    }

    private EnvRadioButton setPanelRadioButton(int n, String string, String[] stringArray, String string2) {
        EnvRadioButton envRadioButton = new EnvRadioButton();
        for (int i = 0; i < stringArray.length; ++i) {
            envRadioButton.addItem(stringArray[i]);
        }
        envRadioButton.setString(string2);
        this.setPanelLayoutLabel(n, string);
        this.setPanelLayoutComponent(n, envRadioButton.getPanel());
        return envRadioButton;
    }

    private EnvRadioText setPanelRadioText(int n, String string, String string2, String string3, int n2) {
        EnvRadioText envRadioText = new EnvRadioText(string2, string3);
        envRadioText.setSelected(n2);
        this.setPanelLayoutLabel(n, string);
        this.setPanelLayoutComponent(n, envRadioText.getPanel());
        return envRadioText;
    }

    private void setPanelSeparator(int n) {
        EnvSeparator envSeparator = new EnvSeparator();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        this.mLayout.setConstraints(envSeparator, gridBagConstraints);
        this.mPanel.add(envSeparator);
    }

    private EnvDocumentList setPanelDocList(int n, String string) throws Exception {
        EnvDocumentList envDocumentList = new EnvDocumentList();
        this.setPanelLayoutLabel(n, string);
        this.setPanelLayoutComponent(n, envDocumentList.getPanel());
        return envDocumentList;
    }

    private void setPanelLayoutLabel(int n, String string) {
        GridBagConstraints gridBagConstraints = this.createLabelConstraints();
        JLabel jLabel = new JLabel(string);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        this.mLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
    }

    private void setPanelLayoutComponent(int n, JComponent jComponent) {
        GridBagConstraints gridBagConstraints = this.createComponentConstraints();
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 1;
        this.mLayout.setConstraints(jComponent, gridBagConstraints);
        this.mPanel.add(jComponent);
    }

    private void setEnvironment() throws Exception {
        if (this.mEnvFirst) {
            this.setRidualDir();
        }
        this.setGrid();
        this.setBrowser();
        this.setHtmlEditor();
        this.setTextEditor();
        this.mDocList.setDocList();
        this.setDefaultColor();
        this.setStartUp();
        this.setSvgLineWidth();
        ((Ridual)ZApp.getTheApp()).resetGroupToolBar();
        RUpdateManager.update(0);
    }

    public void onApply() {
        try {
            this.setEnvironment();
            this.mGrid.setString(this.getResString(EDIT_GRIDSIZE));
            this.mSvg.setString(this.getResString(SVG_LINEWIDTH));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setRidualDir() throws Exception {
        String string = this.mRidualDir.getString();
        if (this.isNullString(string)) {
            string = this.getResString(APP_INSTALL_PATH);
        }
        this.setResString(APP_INSTALL_PATH, string);
        this.setResBoolean(ENV_FIRST, false);
    }

    private void setGrid() throws Exception {
        this.setResBoolean(EDIT_GRID, this.mGrid.getSelected());
        String string = this.mGrid.getString();
        if (string != null) {
            int n;
            String string2 = null;
            if (this.isDigitString(string) && 1 <= (n = Integer.parseInt(string)) && n <= 100) {
                string2 = string;
            }
            this.setResString(EDIT_GRIDSIZE, string2);
        } else {
            this.setResString(EDIT_GRIDSIZE, null);
        }
    }

    private void setBrowser() {
        String string = this.mBrowser.getSelected() == 0 ? this.mBrowser.getString1() : this.mBrowser.getString2();
        this.setResString(GEN_BROWSER_CMD, string);
        this.setResString(GEN_BROWSER_CMD_1, this.mBrowser.getString1());
        this.setResString(GEN_BROWSER_CMD_2, this.mBrowser.getString2());
    }

    private void setHtmlEditor() {
        String string = this.mHtmlEdit.getSelected() == 0 ? this.mHtmlEdit.getString1() : this.mHtmlEdit.getString2();
        this.setResString(CMD_HTML_EDITOR, string);
        this.setResString(CMD_HTML_EDITOR_1, this.mHtmlEdit.getString1());
        this.setResString(CMD_HTML_EDITOR_2, this.mHtmlEdit.getString2());
    }

    private void setTextEditor() {
        this.setResString(CMD_TEXT_EDITOR, this.mTextEdit.getString());
    }

    private void setDefaultColor() {
        this.setResString(UNIT_CLR_ZONEUNIT, this.mColorZone.getString());
        this.setResString(UNIT_CLR_PAGEUNIT, this.mColorPage.getString());
        this.setResString(UNIT_CLR_STRONG, this.mColorLink.getString());
        this.setResString(UNIT_CLR_LINKUNIT, this.mColorReal.getString());
        this.setResString(UNIT_CLR_URLUNIT, this.mColorUrl.getString());
        this.setResString(UNIT_CLR_MAP_HIER, this.mColorMapHier.getString());
        this.setResString(UNIT_CLR_MAP_SITE, this.mColorMapSite.getString());
        this.setResString(UNIT_CLR_MAP_CIRCLE, this.mColorMapCircle.getString());
        this.setResString(UNIT_CLR_NOT_EXIST, this.mColorNotExist.getString());
        this.setResString(UNIT_CLR_SCENARIO_ITEM, this.mColorScenarioItem.getString());
    }

    private void setDialayItem(String string, String string2) {
        if (string2.indexOf("(Path)") != -1) {
            string2 = "File";
        }
        this.setResString(string, string2);
    }

    private void setStartUp() {
        boolean bl = false;
        String string = this.mStartHtml.getString();
        if (string.compareTo("On") == 0) {
            bl = true;
        }
        this.setResBoolean(NEWPROJECT_EDIT_HTML, bl);
    }

    private void setSvgLineWidth() throws Exception {
        String string = this.mSvg.getString();
        if (string != null) {
            int n;
            String string2 = null;
            if (this.isDigitString(string) && 1 <= (n = Integer.parseInt(string)) && n <= 100) {
                string2 = string;
            }
            this.setResString(SVG_LINEWIDTH, string2);
        } else {
            this.setResString(SVG_LINEWIDTH, null);
        }
    }

    private boolean isNullString(String string) throws Exception {
        boolean bl = string == null || string.equals("");
        return bl;
    }

    private void setResString(String string, String string2) {
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putString(string, string2);
    }

    private void setResBoolean(String string, boolean bl) {
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putBoolean(string, bl);
    }

    private String getResString(String string) throws Exception {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string2 = zResource.getString(string);
        if (this.isNullString(string2)) {
            string2 = "";
        }
        return string2;
    }

    private boolean getResBoolean(String string) {
        ZResource zResource = ZApp.getTheApp().getResource();
        return zResource.getBoolean(string);
    }

    private String getCurrentPath() throws Exception {
        File file = new File(".").getAbsoluteFile().getParentFile();
        return file.getAbsolutePath();
    }

    private boolean isDigitString(String string) throws Exception {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

