/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.environment.EnvDialog;

public class AnalyzerDialog {
    public static final String MSG_ANALYZER_TITLE = "msg.analyzer.title";
    public static final String MSG_ANALYZER_IGNORE = "msg.analyzer.ignore";
    public static final String MSG_ANALYZER_O3W_IMPORT = "msg.analyzer.o3w.import";
    public static final String IGNORE_PREFIX = "rid.ignore.prefix";
    public static final String ANALYZE_O3W_IMPORT = "analyze.o3w.import";
    public static final String MSG_ANALYZER_DETAILINFO = "msg.analyzer.detailinfo";
    public static final String ANALYZER_DETAILINFO = "analyzer.detailinfo";
    protected JPanel mPanel = null;
    protected JTextField mIgnorePrefix = null;
    protected JCheckBox mO3WImport = null;
    protected JCheckBox[] mDetailInfo = null;

    public boolean show() {
        ZResource zResource = ZApp.getTheApp().getResource();
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog envDialog = new EnvDialog(jFrame, zResource.getString(MSG_ANALYZER_TITLE));
        this.mPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.createLabelConstraints();
        GridBagConstraints gridBagConstraints2 = this.createComponentConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(zResource.getString(MSG_ANALYZER_IGNORE));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        this.mIgnorePrefix = this.createIgnorePrefix();
        gridBagLayout.setConstraints(this.mIgnorePrefix, gridBagConstraints2);
        this.mPanel.add(this.mIgnorePrefix);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        JLabel jLabel2 = new JLabel(zResource.getString(MSG_ANALYZER_O3W_IMPORT));
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.mPanel.add(jLabel2);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 1;
        this.mO3WImport = new JCheckBox("");
        this.mO3WImport.setSelected(zResource.getBoolean(ANALYZE_O3W_IMPORT));
        gridBagLayout.setConstraints(this.mO3WImport, gridBagConstraints2);
        this.mPanel.add(this.mO3WImport);
        this.mDetailInfo = this.createDetailInfo();
        try {
            JPanel jPanel = new JPanel();
            int n = this.mDetailInfo.length;
            for (int i = 0; i < n; ++i) {
                jPanel.add(this.mDetailInfo[i]);
            }
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(zResource.getString(MSG_ANALYZER_DETAILINFO));
            gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
            this.mPanel.add(jLabel3);
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.gridx = 1;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints2);
            this.mPanel.add(jPanel);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        envDialog.setControlPanel(this.mPanel);
        envDialog.doModal();
        boolean bl = envDialog.isOK();
        if (bl) {
            this.setIgnorePrefix();
            this.setAnalyzO3WImport();
            this.setDetailInfo();
        }
        return bl;
    }

    private JTextField createIgnorePrefix() {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string = zResource.getString(IGNORE_PREFIX);
        JTextField jTextField = new JTextField(string, 30);
        return jTextField;
    }

    private JCheckBox[] createDetailInfo() {
        Vector<JCheckBox> vector = new Vector<JCheckBox>();
        ZResource zResource = ZApp.getTheApp().getResource();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(zResource.getString(ANALYZER_DETAILINFO), " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                vector.add(new JCheckBox(string, zResource.getBoolean("analyzer.detailinfo." + string)));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return vector.toArray(new JCheckBox[0]);
    }

    private String getIgnorePrefix() {
        String string = this.mIgnorePrefix.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private void setIgnorePrefix() {
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putString(IGNORE_PREFIX, this.getIgnorePrefix());
    }

    private void setAnalyzO3WImport() {
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putBoolean(ANALYZE_O3W_IMPORT, this.mO3WImport.isSelected());
    }

    private void setDetailInfo() {
        ZResource zResource = ZApp.getTheApp().getResource();
        try {
            for (int i = this.mDetailInfo.length - 1; 0 <= i; --i) {
                JCheckBox jCheckBox = this.mDetailInfo[i];
                zResource.putBoolean("analyzer.detailinfo." + jCheckBox.getText(), jCheckBox.isSelected());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        return gridBagConstraints;
    }

    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        return gridBagConstraints;
    }
}

