/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.doc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.LineBreakMeasurer;
import java.awt.geom.AffineTransform;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DefaultElement;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.xml.XElementNS;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GPath;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.GSelector;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.gob.PTransform;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementLink;
import jp.co.nri.rid.doc.RidElementScenarioItem;
import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.gob.RidGobManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RidElement
extends DefaultElement {
    public static double TTL = 0.0;
    public static final double TTLIN = 2.0;
    public static final double LINE = 1.0;
    protected Hashtable mMainGobs = new Hashtable();
    public static Vector mAllUnits = null;
    protected static ZRectangle mRootRt = null;
    protected static boolean[] mOverFlow = null;

    protected RidElement() throws DOMException {
        mOverFlow = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            RidElement.mOverFlow[i] = false;
        }
    }

    public String getAttribute(String string) {
        if (string.equals("Key")) {
            return this.getAttribute("File");
        }
        return super.getAttribute(string);
    }

    public void setAttribute(String string, String string2) {
        if (string.equals("Key")) {
            this.setAttribute("File", string2);
        } else if (string.equals("Name")) {
            Object object;
            RidElementZone ridElementZone;
            RidMessage ridMessage = new RidMessage();
            if (string2.length() == 0) {
                ZDebug.err(ridMessage.Error("E1004", string2));
                ZInstance.map().put("setAttribute", new RidException(ridMessage.Error("E1004", string2)));
                return;
            }
            if (!this.getTagName().equals("UrlUnit")) {
                int n = ZString.findOneOf(string2, "\\/:;*?\"<>|#");
                if (n >= 0) {
                    ZDebug.err(ridMessage.Error("E1001", string2));
                    ZInstance.map().put("setAttribute", new RidException(ridMessage.Error("E1001", string2)));
                    return;
                }
                if (string2.startsWith(" ") || string2.startsWith(".")) {
                    ZDebug.err(ridMessage.Error("E1005", string2));
                    ZInstance.map().put("setAttribute", new RidException(ridMessage.Error("E1005", string2)));
                    return;
                }
                if (string2.length() > 215) {
                    ZDebug.err(ridMessage.Error("E1006", string2));
                    ZInstance.map().put("setAttribute", new RidException(ridMessage.Error("E1006", string2)));
                    return;
                }
            }
            if ((ridElementZone = (RidElementZone)((Object)this.getParentNode())) != null) {
                object = ridElementZone.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node = object.item(i);
                    if (!(node instanceof RidElement) || node == this || !((RidElement)((Object)node)).getAttribute("Name").equalsIgnoreCase(string2)) continue;
                    ZDebug.err(ridMessage.Error("E1000", string2));
                    ZInstance.map().put("setAttribute", new RidException(ridMessage.Error("E1000", string2)));
                    return;
                }
            }
            if (this.getTagName().equals("ZoneUnit")) {
                super.setAttribute(string, string2);
                this.updateFileAttribute();
            } else if (this.getTagName().equals("PageUnit") || this.getTagName().equals("ResourceUnit") || this.getTagName().equals("DocumentUnit")) {
                object = ZString.tokenize(string2, ".");
                if (((String[])object).length > 1) {
                    super.setAttribute("FileType", object[((String[])object).length - 1].toLowerCase());
                }
                super.setAttribute(string, string2);
                this.updateFileAttribute();
            } else {
                object = this.getAttribute("Name");
                super.setAttribute(string, string2);
                this.updateLink((String)object);
            }
        } else if (!string.equals("File") && !string.equals("FileType")) {
            if (string.equals("AccessCount")) {
                ((RidDocumentSite)((Object)this.getOwnerDocument())).requestUpdateAccessCount();
                super.setAttribute(string, string2);
            } else {
                super.setAttribute(string, string2);
            }
        }
    }

    public void removeAttribute(String string) {
        if (string.equals("Name")) {
            RidMessage ridMessage = new RidMessage();
            ZDebug.err(ridMessage.Error("E1004", ""));
            ZInstance.map().put("setAttribute", new RidException(ridMessage.Error("E1004", "")));
            return;
        }
        super.removeAttribute(string);
    }

    public byte getConnectModeImpl(GElement gElement, ZPoint zPoint, Object object) {
        GSelector gSelector = new GSelector();
        AffineTransform affineTransform = gElement.getTransform().getTransform();
        gSelector = gSelector.createScaledSelector(1.0 / affineTransform.getScaleX(), 1.0 / affineTransform.getScaleY());
        for (byte by = 2; by <= 9; by = (byte)(by + 1)) {
            if (!gSelector.isHit(((GRectangle)gElement).getSelectorPoint(by), zPoint)) continue;
            return by;
        }
        if (gElement.getBounds().contains(zPoint)) {
            GRectangle gRectangle = (GRectangle)gElement;
            byte by = 2;
            double d = ZGraphicUtil.getDistance(gRectangle.getSelectorPoint(by), zPoint);
            for (byte by2 = (byte)(by + 1); by2 <= 9; by2 = (byte)(by2 + 1)) {
                double d2 = ZGraphicUtil.getDistance(gRectangle.getSelectorPoint(by2), zPoint);
                if (!(d2 < d)) continue;
                by = by2;
                d = d2;
            }
            return by;
        }
        return 0;
    }

    public void setHighlight(String string, byte by) {
        GPath gPath = (GPath)this.getMainGob(string);
        if (gPath == null) {
            gPath = (GPath)this.getMainGob(string + ".current");
        }
        GPath gPath2 = new GPath();
        ZPath zPath = new ZPath(gPath.getTransform().transform(gPath.getPath()));
        gPath2.setPath(zPath);
        gPath2.getStyle().setStrokeColor(new FColor(Color.blue));
        GobManager.list(string, ".highlight").add(gPath2);
        GRectangle gRectangle = new GRectangle();
        gRectangle.setRect(new ZRectangle(zPath.getBounds2D()));
        if (gPath instanceof GRectangle) {
            for (byte by2 = 2; by2 <= 9; by2 = (byte)(by2 + 1)) {
                GSelector gSelector = new GSelector();
                if (by == by2) {
                    gSelector = gSelector.createScaledSelector(2.0, 2.0);
                    gSelector.getStyle().setFillColor(new FColor(Color.red));
                } else {
                    gSelector.getStyle().setFillColor(new FColor(Color.blue));
                }
                gSelector.getStyle().setStrokeColor(new FColor(Color.blue));
                ZPoint zPoint = gRectangle.getSelectorPoint(by2);
                ZRectangle zRectangle = gSelector.getRect();
                zRectangle.setCenter(zPoint);
                gSelector.setRect(zRectangle);
                GobManager.list(string, ".highlight").add(gSelector);
            }
        } else {
            ZPoint zPoint = gRectangle.getRect().getCenter();
            GSelector gSelector = new GSelector();
            gSelector.getStyle().setFillColor(new FColor(by == 1 ? Color.red : Color.blue));
            ZRectangle zRectangle = gSelector.getRect();
            zRectangle.setCenter(zPoint);
            gSelector.setRect(zRectangle);
            GobManager.list(string, ".highlight").add(gSelector);
        }
    }

    public ZPoint getConnectPoint(String string, byte by) {
        GElement gElement = this.getMainGob(string);
        if (gElement == null) {
            gElement = this.getMainGob(string + ".current");
        }
        if (gElement == null) {
            gElement = this.getMainGob(string + ".omission");
        }
        if (gElement == null) {
            Vector vector = this.createAdditionalGobs(string);
            gElement = (GElement)vector.firstElement();
            GobManager.list(string, "additional").addAll(vector);
        }
        return gElement.getConnectPointGob(by);
    }

    public boolean isGobId(GElement gElement, String string) {
        if (gElement != null && gElement.getGobId() != null) {
            String string2 = gElement.getGobId();
            if (string2.equals(string)) {
                return true;
            }
            if (string.equals("add") && string2.startsWith(string)) {
                return true;
            }
        }
        return false;
    }

    public void moveEnd(GElement gElement, DocGridControler docGridControler) {
        ZRectangle zRectangle = new ZRectangle(this.getMovingPath(gElement, docGridControler).getBounds2D());
        DocPane docPane = docGridControler.getEditor();
        if (this.isGobId(gElement, "zone") || this.isGobId(gElement, "map") || this.isGobId(gElement, "new")) {
            ZPoint zPoint = zRectangle.getTopLeft();
            ZPoint zPoint2 = docGridControler.transformToLP(zPoint);
            GElement gElement2 = RidGobManager.findParentZoneGob(docPane.getPanelId(), zPoint2);
            RidDocument ridDocument = (RidDocument)docPane.getDocument();
            RidElementZone ridElementZone = null;
            ridElementZone = gElement2 == null ? (RidElementZone)((Object)ridDocument.getRootElement(docPane.getPanelId())) : (RidElementZone)gElement2.getContainer();
            zRectangle.setX(zPoint2.getX());
            zRectangle.setY(zPoint2.getY());
            if (gElement2 != null) {
                this.convertRectToParentZone(docPane, gElement2, zRectangle);
            }
            switch (docGridControler.getMoveMode()) {
                case 11: {
                    this.setAttribute("Creator", "Operator");
                    this.setSelect(null, true);
                    this.setDocument(ridDocument);
                    ridElementZone.appendChild(this);
                    this.treeChanged();
                    break;
                }
                default: {
                    RidElementZone ridElementZone2 = (RidElementZone)((Object)this.getParentNode());
                    if (ridElementZone == ridElementZone2) break;
                    if (this.getTagName().equals("ZoneUnit") || this.getTagName().equals("PageUnit")) {
                        NodeList nodeList = ridElementZone.getChildNodes();
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            if (!(node instanceof RidElement) || !((RidElement)((Object)node)).getAttribute("Name").equalsIgnoreCase(this.getAttribute("Name"))) continue;
                            RidMessage ridMessage = new RidMessage();
                            MessageDialog.showError(ridMessage.Error("E1000", this.getAttribute("Name")));
                            return;
                        }
                    }
                    ridElementZone2.removeChild((Node)((Object)this));
                    ridElementZone.appendChild(this);
                    this.treeChanged();
                }
            }
            this.setRect(docPane.getPanelId(), zRectangle);
        } else {
            String string = gElement.getGobId().substring(4);
            this.setRect(docPane.getPanelId(), string, zRectangle);
        }
    }

    public void treeChanged() {
    }

    public void convertRectToParentZone(DocPane docPane, GElement gElement, ZRectangle zRectangle) {
        ZPoint zPoint;
        ZPoint zPoint2;
        PTransform pTransform;
        RidElementZone ridElementZone;
        RidElementZone ridElementZone2 = (RidElementZone)gElement.getContainer();
        Stack<RidElementZone> stack = new Stack<RidElementZone>();
        RidDocument ridDocument = (RidDocument)docPane.getDocument();
        RidElementZone ridElementZone3 = (RidElementZone)((Object)ridDocument.getRootElement(docPane.getPanelId()));
        for (ridElementZone = (RidElementZone)((Object)ridElementZone2.getParentNode()); ridElementZone != ridElementZone3; ridElementZone = (RidElementZone)((Object)ridElementZone.getParentNode())) {
            stack.push(ridElementZone);
        }
        while (stack.size() > 0) {
            ridElementZone = (RidElementZone)stack.pop();
            pTransform = ridElementZone.getChildTransform(docPane.getPanelId());
            zPoint2 = zRectangle.getTopLeft();
            zPoint = pTransform.inverseTransform(zPoint2);
            zRectangle.setX(zPoint.getX());
            zRectangle.setY(zPoint.getY());
        }
        pTransform = ridElementZone2.getChildTransform(docPane.getPanelId());
        if (pTransform == null) {
            zPoint2 = gElement.getBounds().getCenter();
            double d = 8000.0 + (zRectangle.getX() - zPoint2.getX());
            double d2 = 6000.0 + (zRectangle.getY() - zPoint2.getY());
            zRectangle.setX(d);
            zRectangle.setY(d2);
        } else {
            zPoint2 = zRectangle.getTopLeft();
            zPoint = pTransform.inverseTransform(zPoint2);
            zRectangle.setX(zPoint.getX());
            zRectangle.setY(zPoint.getY());
        }
    }

    public boolean setSelect(GElement gElement, boolean bl) {
        if (bl && this.isAncestorSelect()) {
            bl = false;
        }
        if (bl = super.setSelect(gElement, bl)) {
            this.setChildUnSelect();
        }
        return bl;
    }

    public boolean isAncestorSelect() {
        Node node = this.getParentNode();
        if (node != null && node instanceof RidElement) {
            if (((RidElement)((Object)node)).isSelect()) {
                return true;
            }
            return ((RidElement)((Object)node)).isAncestorSelect();
        }
        return false;
    }

    public void setChildUnSelect() {
        for (int i = 0; i < this.getLength(); ++i) {
            Node node = this.item(i);
            if (!(node instanceof RidElement)) continue;
            ((RidElement)((Object)node)).setSelect(null, false);
            ((RidElement)((Object)node)).setChildUnSelect();
        }
    }

    protected void updateFileAttribute() {
        RidElementZone ridElementZone = ((RidDocument)((Object)this.getOwnerDocument())).getTopZone();
        if (this == ridElementZone) {
            super.setAttribute("File", this.getAttribute("Name"));
        } else if (this.getTagName().equals("ZoneUnit") || this.getTagName().equals("PageUnit") || this.getTagName().equals("ResourceUnit") || this.getTagName().equals("DocumentUnit")) {
            String string = this.getAttribute("File");
            RidElementZone ridElementZone2 = (RidElementZone)((Object)this.getParentNode());
            if (ridElementZone2 == null) {
                ZDebug.trace("null:" + this.getAttribute("Name"));
                return;
            }
            if (ridElementZone2 == ridElementZone) {
                super.setAttribute("File", this.getAttribute("Name"));
            } else {
                String string2 = ridElementZone2.getAttribute("File");
                super.setAttribute("File", string2 + "/" + this.getAttribute("Name"));
            }
            for (int i = 0; i < this.getLength(); ++i) {
                Node node = this.item(i);
                if (!(node instanceof RidElement)) continue;
                ((RidElement)((Object)node)).updateFileAttribute();
            }
            if (this.getTagName().equals("ZoneUnit")) {
                this.updatePosition(string);
            }
            if (this.getTagName().equals("PageUnit")) {
                this.updateLink(string);
                this.updateScenarioItem(string);
            }
        }
    }

    protected void updatePosition(String string) {
        RidElementZone ridElementZone = ((RidDocument)((Object)this.getOwnerDocument())).getTopZone();
        Vector vector = ridElementZone.getPages(true);
        vector.addAll(ridElementZone.findChildElements(".UrlUnit"));
        String string2 = this.getAttribute("File");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RidElement ridElement = (RidElement)enumeration.nextElement();
            XElementNS xElementNS = ridElement.findChildElement(".ViewInfo.Zone.Position", "On=" + string);
            if (xElementNS == null) continue;
            xElementNS.setAttribute("On", string2);
        }
    }

    protected void updateLink(String string) {
        DocElement docElement = (DocElement)((DocElement)((Object)this.getOwnerDocument().getDocumentElement())).findChildElement(".Link", null);
        if (docElement != null) {
            Vector vector = docElement.findChildElements("LinkUnit");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RidElementLink ridElementLink = (RidElementLink)enumeration.nextElement();
                ridElementLink.updateKeyAttribute(string, this);
            }
        }
    }

    protected void updateScenarioItem(String string) {
        DocElement docElement = (DocElement)((DocElement)((Object)this.getOwnerDocument().getDocumentElement())).findChildElement(".Scenario", null);
        if (docElement != null) {
            Vector vector = docElement.findChildElements("ScenarioUnit");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                DocElement docElement2 = (DocElement)enumeration.nextElement();
                Enumeration enumeration2 = docElement2.findChildElements("ScenarioItem").elements();
                while (enumeration2.hasMoreElements()) {
                    RidElementScenarioItem ridElementScenarioItem = (RidElementScenarioItem)enumeration2.nextElement();
                    ridElementScenarioItem.updateKeyAttribute(string, this);
                }
            }
        }
    }

    protected String getZone() {
        DocElement docElement = (DocElement)((Object)this.getParentNode());
        return docElement.getAttribute("File");
    }

    public void preCreateGobs(String string) {
        this.setMainGob(string, null);
        this.setMainGob(string + ".current", null);
        this.setMainGob(string + ".omission", null);
        super.preCreateGobs(string);
    }

    public Vector createShadowGobs(GPath gPath) {
        Vector<GPath> vector = new Vector<GPath>();
        ZResource zResource = ZApp.getTheApp().getResource();
        Color color = ZGraphicUtil.stringToColor(zResource.getString("unit.color.shadow"));
        ZPath zPath = gPath.getPath();
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 5.0f, 5.0f);
        ZPath zPath2 = new ZPath(affineTransform.createTransformedShape(zPath));
        GPath gPath2 = new GPath();
        gPath2.setPath(zPath2);
        gPath2.getStyle().setFillColor(new FColor(color));
        vector.add(gPath2);
        return vector;
    }

    public Vector createAdditionalGobs(String string) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        DocDocument docDocument = (DocDocument)((Object)this.getOwnerDocument());
        DocElement docElement = (DocElement)((Object)docDocument.getRootElement(string));
        String string2 = docElement.getAttribute("File");
        Color color = this.getBackgroundColor();
        ZRectangle zRectangle = null;
        if (this.hasRect(string, string2)) {
            zRectangle = this.getRect(string, string2);
        } else {
            object = this.getSideSpace(string, string2);
            zRectangle = new ZRectangle(((ZPoint)object).getX(), ((ZPoint)object).getY(), 20.0, 20.0);
            this.setRect(string, string2, zRectangle);
        }
        object = new GRectangle();
        ((GRectangle)object).setRect(zRectangle);
        ((GElement)object).getStyle().setFillColor(new FColor(color));
        ((GElement)object).getStyle().setStrokeColor(new FColor(Color.black));
        ((GElement)object).setSelect(this.isSelect());
        ((GRectangle)object).setEditOption(1);
        ((GElement)object).setContainer(this);
        ((GElement)object).setGobId("add." + string2);
        vector.add(object);
        this.setMainGob(string + ".current", (GElement)object);
        double d = RidElement.getTitleHeight();
        Vector<GString> vector2 = new Vector<GString>();
        ZResource zResource = ZApp.getTheApp().getResource();
        String string3 = zResource.getString("viewtext.Zone." + this.getTagName());
        String string4 = this.getAttribute(string3);
        if (string4.length() > 0) {
            ZRectangle zRectangle2 = new ZRectangle(zRectangle.getX() + 1.0 + 2.0, zRectangle.getY() + zRectangle.getHeight() + 1.0 + 2.0, 1000.0, d);
            GString gString = new GString();
            gString.setText(string4);
            gString.getStyle().setFillColor(new FColor(Color.black));
            gString.setFormat(20);
            gString.setRect(zRectangle2);
            vector2.add(gString);
            ((GElement)object).addForeChildren(vector2);
        }
        return vector;
    }

    public Vector createTitleGobs(String string) {
        Vector<GRectangle> vector = new Vector<GRectangle>();
        ZRectangle zRectangle = this.getRect(string);
        double d = RidElement.getTitleHeight();
        GRectangle gRectangle = new GRectangle();
        ZRectangle zRectangle2 = new ZRectangle(zRectangle.getX(), zRectangle.getY(), zRectangle.getWidth(), d + 4.0);
        gRectangle.setRect(zRectangle2);
        Color color = ((RidElement)((Object)this.getParentNode())).getBackgroundColor();
        gRectangle.getStyle().setFillColor(new FColor(color));
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl = this.getBooleanAttr("Exist", true);
        Color color2 = zResource.getColor("unit.color." + (bl ? "" : "Not") + "Exist");
        gRectangle.getStyle().setStrokeColor(new FColor(color2));
        vector.add(gRectangle);
        String string2 = zResource.getString("viewtext.Zone." + this.getTagName());
        String string3 = this.getAttribute(string2);
        if (string3.length() > 0 && zRectangle2.getWidth() >= 30.0) {
            ZRectangle zRectangle3 = this.getTagName().equals("ZoneUnit") ? new ZRectangle(zRectangle.getX() + 1.0 + 2.0, zRectangle.getY() + 1.0 + 2.0, zRectangle.getWidth() - 12.0 - d, d) : new ZRectangle(zRectangle.getX() + 1.0 + 2.0, zRectangle.getY() + 1.0 + 2.0, zRectangle.getWidth() - 6.0, d);
            GString gString = new GString();
            gString.setText(string3);
            Color color3 = ZGraphicUtil.isBlackFamily(color) ? Color.white : Color.black;
            gString.getStyle().setFillColor(new FColor(color3));
            gString.setFormat(20);
            gString.setRect(zRectangle3);
            vector.add(gString);
        }
        return vector;
    }

    public Color getBackgroundColor() {
        Color color = this.getColorAttr("PaintColor");
        if (color == null) {
            color = ZApp.getTheApp().getResource().getColor("unit.color." + this.getTagName());
        }
        return color;
    }

    protected void setMainGob(String string, GElement gElement) {
        if (gElement != null) {
            this.mMainGobs.put(string, gElement);
        } else {
            this.mMainGobs.remove(string);
        }
    }

    protected void setOmissionGob(String string, GElement gElement) {
        if (gElement != null) {
            this.mMainGobs.put(string + ".omission", gElement);
        } else {
            this.mMainGobs.remove(string + ".omission");
        }
        for (int i = 0; i < this.getLength(); ++i) {
            Node node = this.item(i);
            if (!(node instanceof RidElement)) continue;
            ((RidElement)((Object)node)).setOmissionGob(string, gElement);
        }
    }

    protected GElement getMainGob(String string) {
        return (GElement)this.mMainGobs.get(string);
    }

    public ZPoint getSpace(String string) {
        Object object;
        boolean bl = this.getTagName().equals("UrlUnit");
        int n = 20;
        double d = 150.0;
        double d2 = 150.0;
        RidElementZone ridElementZone = (RidElementZone)((Object)this.getParentNode());
        ZPoint zPoint = new ZPoint(8000.0 - (double)(n / 2) * d, bl ? 6000.0 - d2 : 6000.0);
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        for (int i = 0; i < ridElementZone.getLength(); ++i) {
            int n3;
            object = ridElementZone.item(i);
            if (!(object instanceof DocElement) || !((DocElement)object).hasRect(string)) continue;
            ZRectangle zRectangle = ((DocElement)object).getRect(string);
            boolean bl2 = false;
            if (bl) {
                if (zRectangle.getY() < zPoint.getY()) {
                    n3 = (int)((6000.0 - zRectangle.getY()) / d2);
                    zPoint.setY(6000.0 - (double)n3 * d2);
                    for (n2 = 0; n2 < n; ++n2) {
                        blArray[n2] = false;
                    }
                    bl2 = true;
                } else if (zRectangle.getY() < zPoint.getY() + d2) {
                    bl2 = true;
                }
            } else if (zRectangle.getY() + zRectangle.getHeight() > zPoint.getY() + d2) {
                n3 = (int)((zRectangle.getY() + zRectangle.getHeight() - 6000.0) / d2);
                zPoint.setY(6000.0 + (double)n3 * d2);
                for (n2 = 0; n2 < n; ++n2) {
                    blArray[n2] = false;
                }
                bl2 = true;
            } else if (zRectangle.getY() + zRectangle.getHeight() > zPoint.getY()) {
                bl2 = true;
            }
            if (!bl2) continue;
            n3 = Math.min(n, Math.max(0, (int)((zRectangle.getX() - zPoint.getX()) / d)));
            int n4 = Math.max(-1, Math.min(n - 1, (int)((zRectangle.getX() + zRectangle.getWidth() - zPoint.getX()) / d)));
            for (n2 = n3; n2 <= n4; ++n2) {
                blArray[n2] = true;
            }
        }
        for (n2 = 0; n2 < n && blArray[n2]; ++n2) {
        }
        if (n2 == n) {
            n2 = 0;
            zPoint.setY(zPoint.getY() + (bl ? -d2 : d2));
        }
        zPoint.setX(zPoint.getX() + (double)n2 * d);
        Dimension dimension = ((DocDocument)((Object)this.getOwnerDocument())).getLogicalSize();
        if (zPoint.getY() < 0.0) {
            zPoint.setY(0.0);
            if (!mOverFlow[0]) {
                ZDebug.err("URL Overflow");
                object = new RidMessage();
                MessageDialog.showError(((RidMessage)object).Error("W1000", "URL"));
            }
            RidElement.mOverFlow[0] = true;
        } else if (zPoint.getY() > dimension.getHeight() - d2) {
            zPoint.setY(dimension.getHeight() - d2);
            if (!mOverFlow[1]) {
                ZDebug.err("Zone/Page Overflow");
                object = new RidMessage();
                MessageDialog.showError(((RidMessage)object).Error("W1000", "Zone/Page"));
            }
            RidElement.mOverFlow[1] = true;
        }
        return zPoint;
    }

    public ZPoint getSideSpace(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = this.getTagName().equals("UrlUnit");
        int n = 20;
        double d = 150.0;
        double d2 = 50.0;
        if (mAllUnits == null) {
            object4 = ((RidDocumentSite)((Object)this.getOwnerDocument())).getTopZone();
            mAllUnits = ((RidElementZone)object4).getPages(true);
            mAllUnits.addAll(((XElementNS)((Object)object4)).findChildElements(".UrlUnit"));
            mRootRt = null;
            object3 = (Object)((DocDocument)((Object)this.getOwnerDocument()));
            DocElement docElement = (DocElement)((Object)((DocDocument)((Object)object3)).getRootElement(string));
            for (int i = 0; i < docElement.getLength(); ++i) {
                object2 = docElement.item(i);
                if (!(object2 instanceof DocElement) || !((DocElement)object2).hasRect(string)) continue;
                object = ((DocElement)object2).getRect(string);
                if (mRootRt == null) {
                    mRootRt = object;
                    continue;
                }
                mRootRt.union((ZRectangle)object);
            }
            mRootRt.setX(mRootRt.getX() - d / 2.0);
            mRootRt.setWidth(mRootRt.getWidth() + d);
        }
        object4 = new ZPoint(bl ? mRootRt.getX() - d : mRootRt.getX() + mRootRt.getWidth(), mRootRt.getY());
        object3 = new boolean[n];
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            object3[n2] = false;
        }
        Enumeration enumeration = mAllUnits.elements();
        while (enumeration.hasMoreElements()) {
            int n3;
            object2 = (RidElement)enumeration.nextElement();
            if (!((RidElement)object2).hasRect(string, string2)) continue;
            object = ((RidElement)object2).getRect(string, string2);
            boolean bl2 = false;
            if (bl) {
                if (((ZRectangle)object).getX() < ((ZPoint)object4).getX()) {
                    n3 = (int)((mRootRt.getX() - ((ZRectangle)object).getX()) / d);
                    ((ZPoint)object4).setX(mRootRt.getX() - (double)(n3 + 1) * d);
                    for (n2 = 0; n2 < n; ++n2) {
                        object3[n2] = false;
                    }
                    bl2 = true;
                } else if (((ZRectangle)object).getX() < ((ZPoint)object4).getX() + d) {
                    bl2 = true;
                }
            } else if (((ZRectangle)object).getX() + ((ZRectangle)object).getWidth() > ((ZPoint)object4).getX() + d) {
                n3 = (int)((((ZRectangle)object).getX() + ((ZRectangle)object).getWidth() - (mRootRt.getX() + mRootRt.getWidth())) / d);
                ((ZPoint)object4).setX(mRootRt.getX() + mRootRt.getWidth() + (double)n3 * d);
                for (n2 = 0; n2 < n; ++n2) {
                    object3[n2] = false;
                }
                bl2 = true;
            } else if (((ZRectangle)object).getX() + ((ZRectangle)object).getWidth() > ((ZPoint)object4).getX()) {
                bl2 = true;
            }
            if (!bl2) continue;
            n3 = Math.min(n, Math.max(0, (int)((((ZRectangle)object).getY() - ((ZPoint)object4).getY()) / d2)));
            int n4 = Math.max(-1, Math.min(n, (int)((((ZRectangle)object).getY() + ((ZRectangle)object).getHeight() - ((ZPoint)object4).getY()) / d2)));
            for (n2 = n3; n2 <= n4; ++n2) {
                object3[n2] = true;
            }
        }
        for (n2 = 0; n2 < n && object3[n2] != false; ++n2) {
        }
        if (n2 == n) {
            n2 = 0;
            ((ZPoint)object4).setX(((ZPoint)object4).getX() + (bl ? -d : d));
        }
        ((ZPoint)object4).setY(((ZPoint)object4).getY() + (double)n2 * d2);
        object2 = ((DocDocument)((Object)this.getOwnerDocument())).getLogicalSize();
        if (((ZPoint)object4).getX() < 0.0) {
            ((ZPoint)object4).setX(0.0);
            if (!mOverFlow[3]) {
                ZDebug.err("URL Overflow");
                object = new RidMessage();
                MessageDialog.showError(((RidMessage)object).Error("W1000", "URL"));
            }
            RidElement.mOverFlow[3] = true;
        } else if (((ZPoint)object4).getX() > ((Dimension)object2).getWidth() - d) {
            ((ZPoint)object4).setX(((Dimension)object2).getWidth() - d);
            if (!mOverFlow[2]) {
                ZDebug.err("Page Overflow");
                object = new RidMessage();
                MessageDialog.showError(((RidMessage)object).Error("W1000", "Page"));
            }
            RidElement.mOverFlow[2] = true;
        }
        return object4;
    }

    protected static double getTitleHeight() {
        if (TTL == 0.0) {
            ZDimension zDimension = ZApp.getTextPreferredSize("Hjgy", null, 0.0);
            TTL = zDimension.getHeight();
        }
        return TTL;
    }

    public static ZDimension getTextPreferredSize(String string, int n, String string2, AffineTransform affineTransform, double d) {
        ZResource zResource = ZApp.getTheApp().getResource();
        if (string == null || string.length() == 0) {
            string = zResource.getString("app.font.name");
        }
        if (n == 0) {
            n = zResource.getInt("app.font.size", 10);
        }
        Font font = new Font(string, 0, n);
        if (affineTransform == null) {
            affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        LineBreakMeasurer lineBreakMeasurer = ZApp.createLineBreakMeasurer(string2, font, null, null, null);
        return ZGraphicUtil.getTextPreferredSize(lineBreakMeasurer, null, string2.length(), d);
    }

    public boolean hasRect(String string, String string2) {
        XElementNS xElementNS = this.findChildElement(".ViewInfo." + string + ".Position", "On=" + string2);
        if (xElementNS != null) {
            return xElementNS.hasAttribute("X") && xElementNS.hasAttribute("Y") && xElementNS.hasAttribute("Width") && xElementNS.hasAttribute("Height");
        }
        return false;
    }

    public void setRect(String string, String string2, ZRectangle zRectangle) {
        XElementNS xElementNS = this.getChildElement(".ViewInfo." + string + ".Position", "On=" + string2);
        xElementNS.setDoubleAttr("X", zRectangle.getX());
        xElementNS.setDoubleAttr("Y", zRectangle.getY());
        xElementNS.setDoubleAttr("Width", zRectangle.getWidth());
        xElementNS.setDoubleAttr("Height", zRectangle.getHeight());
    }

    public ZRectangle getRect(String string, String string2) {
        XElementNS xElementNS = this.findChildElement(".ViewInfo." + string + ".Position", "On=" + string2);
        if (xElementNS == null) {
            return new ZRectangle();
        }
        double d = xElementNS.getDoubleAttr("X", 0.0);
        double d2 = xElementNS.getDoubleAttr("Y", 0.0);
        double d3 = xElementNS.getDoubleAttr("Width", 0.0);
        double d4 = xElementNS.getDoubleAttr("Height", 0.0);
        return new ZRectangle(d, d2, d3, d4);
    }
}

