/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.doc;

import java.util.Enumeration;
import java.util.Vector;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.util.ZString;

public class AccessCounts {
    protected double mTotal = 0.0;
    protected double mMax = 1000.0;
    protected double[] mArray = null;
    protected boolean[] mLogList = null;
    protected String mLogType = "";

    public AccessCounts() {
    }

    public AccessCounts(String string) {
        this.setArray(string, null);
    }

    public AccessCounts(String string, boolean[] blArray) {
        this.setArray(string, blArray);
    }

    public void setArray(String string, boolean[] blArray) {
        this.mLogList = blArray;
        this.mTotal = 0.0;
        String[] stringArray = ZString.tokenize(string, ",");
        this.mArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            double d = ZString.parseDouble(stringArray[i], 0.0);
            if (blArray == null) {
                this.mTotal += d;
            } else if (blArray.length <= i) {
                this.mTotal += d;
            } else if (blArray[i]) {
                this.mTotal += d;
            }
            this.mArray[i] = d;
        }
    }

    public void margeMax(AccessCounts accessCounts) {
        int n;
        int n2 = this.getArrayCount();
        int n3 = accessCounts.getArrayCount();
        if (n2 < n3) {
            double[] dArray = new double[n3];
            for (n = 0; n < n2; ++n) {
                dArray[n] = this.mArray[n];
            }
            while (n < n3) {
                dArray[n] = 0.0;
                ++n;
            }
            this.mArray = dArray;
        }
        for (n = 0; n < n3; ++n) {
            double d = accessCounts.getArrayData(n);
            if (!(this.mArray[n] < d)) continue;
            this.mArray[n] = d;
        }
        double d = accessCounts.getTotalCount();
        if (this.mTotal < d) {
            this.mTotal = d;
        }
    }

    public ZRectangle[] createAccessRects(ZRectangle zRectangle, AccessCounts accessCounts) {
        int n;
        Vector<Double> vector = new Vector<Double>();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = accessCounts.getArrayCount();
        if (this.mLogList != null) {
            for (n = 0; n < this.mLogList.length; ++n) {
                if (!this.mLogList[n]) continue;
                if (n < n3) {
                    d2 = accessCounts.getArrayData(n);
                    vector.add(new Double(d2));
                    if (!(d2 > 0.0)) continue;
                    d += d2;
                    ++n2;
                    continue;
                }
                vector.add(new Double(0.0));
            }
        }
        while (n < n3) {
            d2 = accessCounts.getArrayData(n);
            vector.add(new Double(d2));
            if (d2 > 0.0) {
                d += d2;
                ++n2;
            }
            ++n;
        }
        while (n < this.getArrayCount()) {
            vector.add(new Double(0.0));
            ++n;
        }
        ZRectangle[] zRectangleArray = null;
        if (this.mLogType.equals("join")) {
            if (d != 0.0) {
                double d3 = zRectangle.getHeight() * d / this.mMax;
                zRectangleArray = new ZRectangle[]{new ZRectangle(zRectangle.getX(), zRectangle.getY() + zRectangle.getHeight() - d3, zRectangle.getWidth(), d3)};
            }
        } else if (n2 > 0) {
            zRectangleArray = new ZRectangle[n2];
            Enumeration enumeration = vector.elements();
            n = 0;
            double d4 = zRectangle.getX();
            double d5 = zRectangle.getY();
            double d6 = zRectangle.getWidth();
            double d7 = zRectangle.getHeight();
            double d8 = 0.0;
            int n4 = 0;
            int n5 = vector.size();
            while (enumeration.hasMoreElements()) {
                Double d9 = (Double)enumeration.nextElement();
                double d10 = d9;
                if (d10 > 0.0) {
                    double d11 = d7 * d10 / this.mMax;
                    if (!this.mLogType.equals("parallel")) {
                        zRectangleArray[n] = new ZRectangle(d4, d5 + d7 - d8 - d11, d6, d11);
                        d8 += d11;
                    } else {
                        zRectangleArray[n] = new ZRectangle(d4 + d6 / (double)n5 * (double)n4, d5 + d7 - d11, d6 / (double)n5, d11);
                    }
                    ++n;
                }
                ++n4;
            }
        }
        return zRectangleArray;
    }

    public void calcMaxCount() {
        if (!this.mLogType.equals("parallel")) {
            this.mMax = this.mTotal;
        } else {
            this.mMax = 0.0;
            for (int i = 0; i < this.mArray.length; ++i) {
                if (this.mLogList != null && this.mLogList.length > i && !this.mLogList[i]) continue;
                if (this.mMax == 0.0) {
                    this.mMax = this.mArray[i];
                    continue;
                }
                if (!(this.mMax < this.mArray[i])) continue;
                this.mMax = this.mArray[i];
            }
        }
        if (this.mMax == 0.0) {
            this.mMax = 1000.0;
        }
    }

    public double getTotalCount() {
        return this.mTotal;
    }

    public int getArrayCount() {
        if (this.mArray == null) {
            return 0;
        }
        return this.mArray.length;
    }

    public double getArrayData(int n) {
        if (this.mArray == null || this.mArray.length <= n) {
            return 0.0;
        }
        return this.mArray[n];
    }

    public void setLogType(String string) {
        this.mLogType = string;
    }
}

