/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.analyzer;

import java.util.HashMap;
import java.util.Vector;
import jp.co.nri.rid.analyzer.BaseURL;
import jp.co.nri.rid.analyzer.FileNameStudio;
import jp.co.nri.rid.analyzer.LinkedPageList;
import jp.co.nri.rid.analyzer.RWarningException;
import jp.co.nri.rid.analyzer.iExceptionCode;
import jp.co.nri.rid.analyzer.iMappingScript;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.importer.RIgnoreFiles;
import jp.co.nri.rid.xml.elementBooster;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceMappingScript
implements iMappingScript,
iExceptionCode {
    private static final String RESOURCEUNIT = "ResourceUnit";
    private static final String ZONEUNIT = "ZoneUnit";
    private static final String LINKEDPAGEUNIT = "LinkedPageUnit";
    private static final String LINKEDPAGE = "LinkedPage";
    private static final String KEY = "Key";
    private static final String NAME = "Name";
    private static final String REFERENCE = "Reference";
    private static final String RESOURCE = "Resource";
    private static final String PAGE = "Page";
    private static final String WIDTH = "Width";
    private static final String HEIGHT = "Height";
    private static final String ALT = "Alt";
    private static final String LINKTYPE = "LinkType";
    private static final String CREATOR = "Creator";
    private static final String ANALIZER = "analyzer";
    private static final String EXIST = "Exist";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String IMG = "img";
    private static final String EMBED = "embed";
    private static final String INPUT = "input";
    private static final String BODY = "body";
    private static final String TABLE = "table";
    private static final String TR = "tr";
    private static final String TD = "td";
    private static final String SCRIPT = "script";
    private static final String LINK = "link";
    private static final String INCLUDE = "include";
    private static final String EXEC = "exec";
    private static final String SRC = "src";
    private static final String LOWSRC = "lowsrc";
    private static final String BACKGROUND = "background";
    private static final String FILE = "file";
    private static final String VIRTUAL = "virtual";
    private static final String CMD = "cmd";
    private static final String CGI = "cgi";
    private static final String HREF = "href";
    private static final String IMGSRC = "img.src";
    private static final String IMGLOWSRC = "img.lowsrc";
    private static final String EMBEDSRC = "embed.src";
    private static final String EMBEDLOWSRC = "embed.lowsrc";
    private static final String INPUTSRC = "input.src";
    private static final String INPUTLOWSRC = "input.lowsrc";
    private static final String[] names = new String[]{"img", "embed", "input", "body", "table", "tr", "td", "script", "link"};
    private static final String[][] attrmap = new String[][]{{"img", "src", "lowsrc"}, {"embed", "src", "lowsrc"}, {"input", "src", "lowsrc"}, {"body", "background"}, {"table", "background"}, {"tr", "background"}, {"td", "background"}, {"include", "file", "virtual"}, {"exec", "cmd", "cgi"}, {"script", "src"}, {"link", "href", "src"}};
    private static final String[][] optionmap = new String[][]{{"img.src", "Width", "Height", "Alt"}, {"img.lowsrc", "Width", "Height", "Alt"}, {"embed.src", "Width", "Height", "Alt"}, {"embed.lowsrc", "Width", "Height", "Alt"}, {"input.src", "Width", "Height", "Alt"}, {"input.lowsrc", "Width", "Height", "Alt"}};
    private elementBooster myTopZone;
    private StringMap2D myTagMap;
    private StringMap2D myOptionMap;
    private BaseURL baseURL;
    private LinkedPageList linkedPageList;

    public ResourceMappingScript(elementBooster elementBooster2, LinkedPageList linkedPageList, BaseURL baseURL) {
        this.baseURL = baseURL;
        this.linkedPageList = linkedPageList;
        this.myTagMap = new StringMap2D(attrmap);
        this.myOptionMap = new StringMap2D(optionmap);
        this.myTopZone = elementBooster2.child(ZONEUNIT);
    }

    public String[] names() {
        return names;
    }

    public void hit(String string, String string2, elementBooster elementBooster2) throws RidException, RWarningException {
        RWarningException rWarningException = new RWarningException();
        String[] stringArray = this.myTagMap.get(string2);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.resource(string, elementBooster2, elementBooster2.attribute(stringArray[i]), elementBooster2.tagname() + "." + stringArray[i]);
                continue;
            }
            catch (RWarningException rWarningException2) {
                rWarningException.add(rWarningException2);
            }
        }
        if (0 < rWarningException.length()) {
            throw rWarningException;
        }
    }

    public void hitForFlash(String string, String string2, String string3) throws RidException, RWarningException {
        RWarningException rWarningException = new RWarningException();
        try {
            this.resource(string, null, string2, string3);
        }
        catch (RWarningException rWarningException2) {
            rWarningException.add(rWarningException2);
        }
        if (0 < rWarningException.length()) {
            throw rWarningException;
        }
    }

    private void resource(String string, elementBooster elementBooster2, String string2, String string3) throws RWarningException, RidException {
        String[] stringArray;
        Element element;
        String string4;
        String string5 = string2;
        if (null == string2) {
            return;
        }
        if (null != this.baseURL && null != (string4 = this.baseURL.getInnerPath(string, string2))) {
            string2 = string4;
        }
        if (FileNameStudio.isURL(string2 = FileNameStudio.cutParamForUrlUnit(string2))) {
            return;
        }
        if (RIgnoreFiles.ignorefile(string2)) {
            return;
        }
        string4 = FileNameStudio.filename(string2);
        if (null == string4) {
            throw new RWarningException("W2210", "\"" + string5 + "\"" + " (from " + string + ")");
        }
        String string6 = string2.startsWith("/") ? "/" : FileNameStudio.zonename(string);
        String string7 = FileNameStudio.zonename(string6, FileNameStudio.zonename(string2));
        String string8 = null;
        string8 = null == string7 ? new String(string4) : string7 + "/" + string4;
        Element element2 = this.findResourceUnit(string8, this.myTopZone.element());
        if (null == element2) {
            element = this.findZoneUnit(string8, this.myTopZone.element());
            if (element != null) {
                throw new RWarningException("W2302", string8);
            }
            stringArray = FileNameStudio.zone(this.myTopZone, string8, ANALIZER);
            if (stringArray == null) {
                throw new RWarningException("W2301", string8);
            }
            element2 = stringArray.add(RESOURCEUNIT).element();
            element2.setAttribute(NAME, string4);
            element2.setAttribute(CREATOR, ANALIZER);
            element2.setAttribute(EXIST, FALSE);
        }
        if (null == (element = this.linkedPageList.get(string8))) {
            element = this.linkedPageList.appendUnit(string8);
        }
        element.setAttribute(LINKTYPE, string3);
        stringArray = this.myOptionMap.get(string3);
        if (null == stringArray) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            element.setAttribute(stringArray[i], elementBooster2.attribute(stringArray[i].toLowerCase()));
        }
    }

    private Element findZoneResourceUnit(String string, NodeList nodeList) {
        for (int i = nodeList.getLength() - 1; 0 <= i; --i) {
            Element element;
            String string2;
            Node node = nodeList.item(i);
            if (1 != node.getNodeType() || !ZONEUNIT.equals(string2 = node.getNodeName()) && !RESOURCEUNIT.equals(string2) || !string.equalsIgnoreCase((element = (Element)node).getAttribute(NAME))) continue;
            return element;
        }
        return null;
    }

    private Element findResourceUnit(String string, Element element) {
        String[] stringArray = string.split("/");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            NodeList nodeList = element.getChildNodes();
            if (null != (element = this.findZoneResourceUnit(stringArray[i], nodeList))) continue;
            return null;
        }
        return element.getTagName().equals(RESOURCEUNIT) ? element : null;
    }

    private Element findZoneUnit(String string, Element element) {
        String[] stringArray = string.split("/");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            NodeList nodeList = element.getChildNodes();
            if (null != (element = this.findZoneResourceUnit(stringArray[i], nodeList))) continue;
            return null;
        }
        return element.getTagName().equals(ZONEUNIT) ? element : null;
    }

    private class StringMap2D
    extends HashMap {
        private String myKeyName1;
        private String myKeyName2;

        public StringMap2D(String[][] stringArray) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i];
                int n2 = stringArray2.length;
                for (int j = 1; j < n2; ++j) {
                    this.add(stringArray2[0], stringArray2[j]);
                }
            }
        }

        public void add(String string, String string2) {
            Vector<String> vector = (Vector<String>)super.get(string);
            if (null == vector) {
                vector = new Vector<String>();
                this.put(string, vector);
            }
            vector.add(string2);
        }

        public String[] get(String string) {
            try {
                return ((Vector)super.get(string)).toArray(new String[0]);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
    }
}

