/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.analyzer;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkList {
    private static final String LINK = "Link";
    private static final String LINKUNIT = "LinkUnit";
    private static final String CONNECT0 = "Connect0";
    private static final String CONNECT1 = "Connect1";
    private static final String KEY = "Key";
    private Hashtable list = null;
    private String from = null;
    private NodeList linkNodeList;
    private Document document;
    private Element linkTag;

    public LinkList(Element element) {
        this.document = element.getOwnerDocument();
        this.linkTag = this.getLinkTag(element);
        this.linkNodeList = this.linkTag.getElementsByTagName(LINKUNIT);
    }

    public Element get(String string) {
        if (null == this.list) {
            this.buildList();
        }
        return (Element)this.list.get(string.toLowerCase());
    }

    public void reset(String string) {
        this.from = string;
        this.list = null;
    }

    public Element appendUnit(String string) {
        Element element = this.document.createElement(CONNECT0);
        element.setAttribute(KEY, this.from);
        Element element2 = this.document.createElement(CONNECT1);
        element2.setAttribute(KEY, string);
        Element element3 = this.document.createElement(LINKUNIT);
        element3.appendChild(element);
        element3.appendChild(element2);
        this.linkTag.appendChild(element3);
        this.list.put(string.toLowerCase(), element3);
        return element3;
    }

    private String getChildAttribute(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (0 >= nodeList.getLength()) {
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        return element2.getAttribute(string2);
    }

    private Element getLinkTag(Element element) {
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        for (int i = nodeList.getLength() - 1; 0 <= i; --i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType() || !LINK.equals(node.getNodeName())) continue;
            element2 = (Element)node;
            break;
        }
        if (null == element2) {
            element2 = this.document.createElement(LINK);
            element.appendChild(element2);
        }
        return element2;
    }

    private void buildList() {
        this.list = new Hashtable();
        for (int i = this.linkNodeList.getLength() - 1; 0 <= i; --i) {
            Element element = (Element)this.linkNodeList.item(i);
            String string = this.getChildAttribute(element, CONNECT0, KEY);
            try {
                if (!this.from.equalsIgnoreCase(string)) continue;
                String string2 = this.getChildAttribute(element, CONNECT1, KEY);
                this.list.put(string2.toLowerCase(), element);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

