/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid;

import java.awt.Window;
import java.util.Vector;
import javax.swing.JComponent;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZChildWindowAction;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.ui.UDialog;
import jp.co.iti.fagot.ui.UWindowManager;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.nri.rid.RPanPanel;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.xml.PaneledElementFactory;
import org.w3c.dom.Element;

public class RWindowManager
extends UWindowManager {
    public static final int PROPERTY = 0;
    public static final int PANPANEL = 1;
    public static final int WINDOW_COUNT = 2;

    public RWindowManager(IZApp iZApp) {
        super(iZApp, 2);
    }

    public Window createWindow(int n) {
        UDialog uDialog = null;
        switch (n) {
            case 0: {
                UDialog uDialog2 = new UDialog(this.mApp, "property");
                this.updatePropertyDialog(uDialog2);
                uDialog = uDialog2;
                break;
            }
            case 1: {
                UDialog uDialog3 = new UDialog(this.mApp, "panpanel");
                RPanPanel rPanPanel = new RPanPanel();
                uDialog3.setComponent(rPanPanel, true);
                uDialog = uDialog3;
            }
        }
        return uDialog;
    }

    public void updateWindow(int n) {
        Window window = this.getWindow(n);
        if (window == null) {
            return;
        }
        switch (n) {
            case 0: {
                UDialog uDialog = (UDialog)window;
                this.updatePropertyDialog(uDialog);
                break;
            }
            case 1: {
                RPanPanel rPanPanel = (RPanPanel)((UDialog)window).getComponent();
                rPanPanel.restract();
            }
        }
    }

    public void setVisible(int n, boolean bl) {
        super.setVisible(n, bl);
        ZChildWindowAction zChildWindowAction = (ZChildWindowAction)this.getApp().getAction("childwin" + n);
        if (zChildWindowAction != null) {
            zChildWindowAction.update();
        }
    }

    protected void updatePropertyDialog(UDialog uDialog) {
        Object object;
        String string = ZInstance.prop().getProperty("panel.active");
        JComponent jComponent = (JComponent)ZInstance.map().get(string);
        if (!(jComponent instanceof DocPane)) {
            uDialog.getContentPane().removeAll();
            uDialog.validate();
            uDialog.repaint();
            return;
        }
        DocPane docPane = (DocPane)jComponent;
        DocElement docElement = null;
        Vector vector = GobManager.getSelectedElement(docPane.getPanelId());
        if (vector.size() != 1) {
            docElement = (DocElement)((Object)((RidDocumentSite)docPane.getDocument()).getRootElement(docPane.getPanelId()));
        } else {
            object = (GElement)vector.firstElement();
            docElement = (DocElement)((GElement)object).getContainer();
        }
        if (docElement == null) {
            uDialog.getContentPane().removeAll();
            uDialog.validate();
            uDialog.repaint();
            return;
        }
        uDialog.getContentPane().removeAll();
        object = new PaneledElementFactory();
        Element element = DocManager.createElementLayout(docElement.getTagName());
        uDialog.setComponent(((PaneledElementFactory)object).PaneledElement((Element)((Object)docElement), element), true);
        uDialog.validate();
    }
}

