/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.xml;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GEllipse;
import jp.co.iti.fagot.gob.GLine;
import jp.co.iti.fagot.gob.GPath;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.PStyle;
import jp.co.iti.fagot.gob.PTransform;
import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.xml.SVGLine;
import jp.co.iti.fagot.xml.SVGPathdata;
import jp.co.iti.fagot.xml.SVGStyle;
import jp.co.iti.fagot.xml.SVGWorker;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GRootSVG
extends SVGWorker {
    public double strokeWidthRatio = 1.0;
    private double myRootX;
    private double myRootY;
    private double myRootW;
    private double myRootH;

    public GRootSVG() throws ParserConfigurationException {
        super(null, null, "800", "600", "0 0 10000 10000", "xMidYMid meet", null);
    }

    private Element markerArrow(String string, String string2, SVGStyle sVGStyle, boolean bl) {
        Element element = this.doc.createElement("marker");
        element.setAttribute("id", string);
        element.setAttribute("viewBox", "0 0 10 10");
        element.setAttribute("refX", bl ? "1" : "9");
        element.setAttribute("refY", "5");
        element.setAttribute("markerWidth", "12");
        element.setAttribute("markerHeight", "12");
        element.setAttribute("orient", "auto");
        element.setAttribute("markerUnits", "userSpaceOnUse");
        Element element2 = this.doc.createElement("polygon");
        element2.setAttribute("points", string2);
        element2.setAttribute("style", sVGStyle.toString());
        element.appendChild(element2);
        return element;
    }

    public GRootSVG(Vector vector) throws ParserConfigurationException {
        this();
        this.setGobs(vector);
    }

    protected void setGobs(Vector vector) {
        Object object;
        try {
            object = ZApp.getTheApp().getResource();
            double d = Double.parseDouble(((ZResource)object).getString("svg.line.width"));
            this.strokeWidthRatio = d / 100.0;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        object = null;
        ZRectangle zRectangle = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object2;
            GElement gElement = (GElement)enumeration.nextElement();
            PTransform pTransform = gElement.getTransform();
            Vector vector2 = gElement.getBackChildren();
            Vector vector3 = gElement.getForeChildren();
            Element element = this.rootelement;
            if (vector2.size() + vector3.size() > 0) {
                element = this.doc.createElement("g");
                this.rootelement.appendChild(element);
            }
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                object2 = (GElement)enumeration2.nextElement();
                zRectangle = this.addItem(element, (GElement)object2, pTransform);
                if (object == null) {
                    object = zRectangle;
                    continue;
                }
                ((ZRectangle)object).union(zRectangle);
            }
            zRectangle = this.addItem(element, gElement, null);
            if (object == null) {
                object = zRectangle;
            } else {
                ((ZRectangle)object).union(zRectangle);
            }
            object2 = vector3.elements();
            while (object2.hasMoreElements()) {
                GElement gElement2 = (GElement)object2.nextElement();
                zRectangle = this.addItem(element, gElement2, pTransform);
                ((ZRectangle)object).union(zRectangle);
            }
        }
        double d = 20.0;
        this.myRootX = ((ZRectangle)object).getX() - d;
        this.myRootY = ((ZRectangle)object).getY() - d;
        this.myRootW = ((ZRectangle)object).getWidth() + d * 2.0;
        this.myRootH = ((ZRectangle)object).getHeight() + d * 2.0;
        if (800.0 > this.myRootW && 600.0 > this.myRootH) {
            this.setWidth(this.myRootW);
            this.setHeight(this.myRootH);
        }
        this.setViewBox(this.myRootX, this.myRootY, this.myRootW, this.myRootH);
    }

    public String calcViewBox(double d, double d2) {
        return this.myRootX + " " + this.myRootY + " " + this.myRootW + " " + this.myRootH;
    }

    protected ZRectangle addItem(Element element, GElement gElement, PTransform pTransform) {
        ZRectangle zRectangle = gElement.getTransformedBounds();
        if (pTransform != null) {
            zRectangle = new ZRectangle(pTransform.transform(zRectangle).getBounds2D());
        }
        PStyle pStyle = gElement.getStyle();
        SVGStyle sVGStyle = new SVGStyle();
        sVGStyle.fill.fill = pStyle.getFillColor().getString();
        sVGStyle.fill.rule = pStyle.getFillRule().getString();
        sVGStyle.stroke.stroke = pStyle.getStrokeColor().getString();
        double d = pStyle.getStroke().getWidth().get();
        d = 0.0 == d ? 1.0 : d;
        sVGStyle.stroke.width = String.valueOf(d * this.strokeWidthRatio);
        if (gElement instanceof GString) {
            GString gString = (GString)gElement;
            sVGStyle.text.dominantBaseline = "hanging";
            sVGStyle.text.font.family = gString.getFontName();
            int n = 0;
            if (null == sVGStyle.text.font.family) {
                ZResource zResource = ZApp.getTheApp().getResource();
                sVGStyle.text.font.family = zResource.getString("app.font.name");
                n = zResource.getInt("app.font.size", 0);
            } else {
                try {
                    n = Integer.parseInt(gString.getFontSize(), 0);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            try {
                sVGStyle.text.font.size = String.valueOf((double)n * pTransform.getTransform().getScaleY());
            }
            catch (NullPointerException nullPointerException) {
                sVGStyle.text.font.size = String.valueOf(n);
            }
            element.appendChild((Node)((Object)this.createText(String.valueOf(zRectangle.getX()), String.valueOf(zRectangle.getY()), gString.getText(), sVGStyle)));
        } else if (gElement instanceof GEllipse) {
            double d2 = zRectangle.getWidth() / 2.0;
            double d3 = zRectangle.getHeight() / 2.0;
            double d4 = zRectangle.getX() + d2;
            double d5 = zRectangle.getY() + d3;
            element.appendChild((Node)((Object)this.createEllipse(String.valueOf(d4), String.valueOf(d5), String.valueOf(d2), String.valueOf(d3), sVGStyle)));
        } else if (gElement instanceof GRectangle) {
            element.appendChild((Node)((Object)this.createRect(String.valueOf(zRectangle.getX()), String.valueOf(zRectangle.getY()), String.valueOf(zRectangle.getWidth()), String.valueOf(zRectangle.getHeight()), null, null, sVGStyle)));
        } else if (gElement instanceof GLine) {
            ZLine zLine = ((GLine)gElement).getLine();
            ZPoint zPoint = zLine.getP1Z();
            ZPoint zPoint2 = zLine.getP2Z();
            PTransform pTransform2 = gElement.getTransform();
            zPoint = pTransform2.transform(zPoint);
            zPoint2 = pTransform2.transform(zPoint2);
            if (pTransform != null) {
                zPoint = pTransform.transform(zPoint);
                zPoint2 = pTransform.transform(zPoint2);
            }
            SVGLine sVGLine = this.createLine(String.valueOf(zPoint.getX()), String.valueOf(zPoint.getY()), String.valueOf(zPoint2.getX()), String.valueOf(zPoint2.getY()), sVGStyle);
            if (((GLine)gElement).isArrow(1) || ((GLine)gElement).isArrow(1)) {
                SVGPathdata sVGPathdata;
                ZPath zPath;
                Element element2 = this.doc.createElement("g");
                element2.appendChild((Node)((Object)sVGLine));
                if (((GLine)gElement).isArrow(1)) {
                    zPath = new ZPath(ZGraphicUtil.createArrowShape(zPoint, zPoint2, 8.0, 4.0));
                    sVGPathdata = this.converttoPathdata(zPath);
                    element2.appendChild((Node)((Object)this.createPath(sVGPathdata, sVGStyle)));
                }
                if (((GLine)gElement).isArrow(2)) {
                    zPath = new ZPath(ZGraphicUtil.createArrowShape(zPoint2, zPoint, 8.0, 4.0));
                    sVGPathdata = this.converttoPathdata(zPath);
                    element2.appendChild((Node)((Object)this.createPath(sVGPathdata, sVGStyle)));
                }
                element.appendChild(element2);
            } else {
                element.appendChild((Node)((Object)sVGLine));
            }
        } else if (gElement instanceof GPath) {
            ZPath zPath = ((GPath)gElement).getPath();
            PTransform pTransform3 = gElement.getTransform();
            zPath = new ZPath(pTransform3.transform(zPath));
            if (pTransform != null) {
                zPath = new ZPath(pTransform.transform(zPath));
            }
            SVGPathdata sVGPathdata = this.converttoPathdata(zPath);
            element.appendChild((Node)((Object)this.createPath(sVGPathdata, sVGStyle)));
        }
        return zRectangle;
    }

    protected SVGPathdata converttoPathdata(ZPath zPath) {
        byte[] byArray = zPath.getTypes();
        double[] dArray = zPath.getCoords();
        SVGPathdata sVGPathdata = new SVGPathdata();
        int n = 0;
        int n2 = zPath.getNumTypes();
        int n3 = dArray.length;
        block7: for (int i = 0; i < n2; ++i) {
            switch (byArray[i]) {
                case 0: {
                    if (n + 2 > n3) continue block7;
                    sVGPathdata.moveto(dArray[n], dArray[n + 1]);
                    n += 2;
                    continue block7;
                }
                case 1: {
                    if (n + 2 > n3) continue block7;
                    sVGPathdata.lineto(dArray[n], dArray[n + 1]);
                    n += 2;
                    continue block7;
                }
                case 2: {
                    if (n + 4 > n3) continue block7;
                    sVGPathdata.quadto(dArray[n], dArray[n + 1], dArray[n + 2], dArray[n + 3]);
                    n += 4;
                    continue block7;
                }
                case 3: {
                    if (n + 6 > n3) continue block7;
                    sVGPathdata.curveto(dArray[n], dArray[n + 1], dArray[n + 2], dArray[n + 3], dArray[n + 4], dArray[n + 5]);
                    n += 6;
                    continue block7;
                }
                case 4: {
                    sVGPathdata.closepath();
                }
            }
        }
        return sVGPathdata;
    }

    public void setLogo(Element element) {
        if (!"svg".equals(element.getTagName())) {
            return;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(element.getAttribute("height"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.myRootY -= d;
        this.myRootH += d;
        this.setViewBox(this.myRootX, this.myRootY, this.myRootW, this.myRootH);
        Element element2 = this.doc.createElement("g");
        element2.setAttribute("transform", "translate(" + String.valueOf(this.myRootX) + "," + String.valueOf(this.myRootY) + ")");
        NodeList nodeList = element.getChildNodes();
        if (null == nodeList) {
            return;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            element2.appendChild(this.doc.importNode(node, true));
        }
        this.rootelement.appendChild(element2);
    }
}

