/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.util;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.iti.fagot.util.ZString;

public class ZDebug {
    protected static boolean mTrace = true;
    protected static String mFile = null;
    protected static Vector mLaps = null;

    public static void setTrace(boolean bl) {
        mTrace = bl;
    }

    public static void setTraceFile(String string) {
        mFile = string;
    }

    public static void printStack() {
        try {
            String string = null;
            string.toString();
        }
        catch (NullPointerException nullPointerException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream, true);
            nullPointerException.printStackTrace(printStream);
            String string = byteArrayOutputStream.toString();
            int n = string.indexOf(")");
            String string2 = "ZDebug.printStack()" + string.substring(n + 1);
            ZDebug.printErr(string2);
        }
    }

    public static String getStack() {
        String string = null;
        try {
            String string2 = null;
            string2.toString();
        }
        catch (NullPointerException nullPointerException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream, true);
            nullPointerException.printStackTrace(printStream);
            String string3 = byteArrayOutputStream.toString();
            int n = string3.indexOf(")");
            string = string3.substring(n + 1);
        }
        return string;
    }

    public static void trace(Throwable throwable) {
        if (!mTrace) {
            return;
        }
        String string = ZDebug.getCaller();
        ZDebug.println(string + throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (null == stackTraceElementArray) {
            return;
        }
        for (int i = stackTraceElementArray.length - 1; 0 <= i; --i) {
            ZDebug.println(stackTraceElementArray[i].toString());
        }
    }

    public static void trace(String string) {
        if (!mTrace) {
            return;
        }
        String string2 = ZDebug.getCaller();
        ZDebug.println(string2 + string);
    }

    public static void trace() {
        if (!mTrace) {
            return;
        }
        String string = ZDebug.getCaller();
        ZDebug.println(string + "### trace ###");
    }

    public static void err(String string) {
        String string2 = ZDebug.getCaller();
        ZDebug.printErr(string2 + string);
    }

    public static void dump(byte[] byArray) {
        int n;
        if (!mTrace) {
            return;
        }
        int n2 = byArray.length;
        if (n2 > 64) {
            n2 = 64;
        }
        for (int i = 0; i < n2; i += n) {
            int n3;
            String string = "    *** Dump *** : ";
            string = string + ZDebug.getHex(6, i);
            string = string + " : ";
            n = n2 - i > 16 ? 16 : n2 - i;
            for (n3 = 0; n3 < 16; ++n3) {
                if (n3 < n) {
                    string = string + ZDebug.getHex(2, byArray[i + n3]);
                    string = string + " ";
                } else {
                    string = string + "   ";
                }
                if (n3 != 7) continue;
                string = string + " ";
            }
            string = string + " | ";
            for (n3 = 0; n3 < 16; ++n3) {
                string = n3 < n ? string + (char)byArray[i + n3] : string + " ";
                if (n3 != 7) continue;
                string = string + " ";
            }
            ZDebug.println(string);
        }
    }

    public static String getHex(int n, int n2) {
        int n3;
        String string = "";
        for (n3 = 0; n3 < n && n2 != 0; n2 /= 16, ++n3) {
            int n4 = n2 % 16;
            string = new Character(Character.forDigit(n4, 16)).toString() + string;
        }
        while (n3 < n) {
            string = "0" + string;
            ++n3;
        }
        return string;
    }

    public static void lapStart(String string) {
        mLaps = new Vector();
        Date date = new Date();
        mLaps.add(date);
        String string2 = ZDebug.getCaller();
        mLaps.add(string2 + string);
    }

    public static void lap(String string) {
        if (mLaps == null) {
            return;
        }
        Date date = new Date();
        mLaps.add(date);
        String string2 = ZDebug.getCaller();
        mLaps.add(string2 + string);
    }

    public static void lapEnd(String string, boolean bl) {
        if (mLaps == null) {
            return;
        }
        Date date = new Date();
        mLaps.add(date);
        String string2 = ZDebug.getCaller();
        mLaps.add(string2 + string);
        Date date2 = (Date)mLaps.firstElement();
        long l = date.getTime() - date2.getTime();
        DateFormat dateFormat = DateFormat.getTimeInstance();
        Enumeration enumeration = mLaps.elements();
        Date date3 = (Date)enumeration.nextElement();
        String string3 = (String)enumeration.nextElement();
        if (bl) {
            String string4 = "*** lap ***,";
            long l2 = date3.getTime();
            while (enumeration.hasMoreElements()) {
                date3 = (Date)enumeration.nextElement();
                string3 = (String)enumeration.nextElement();
                long l3 = date3.getTime();
                long l4 = l3 - l2;
                string4 = string4 + l4 + ",";
                l2 = l3;
            }
            ZDebug.println(string4);
        } else {
            ZDebug.println("*** lap ***");
            ZDebug.println(dateFormat.format(date3) + ":total[" + l + "]" + string3);
            long l5 = date3.getTime();
            while (enumeration.hasMoreElements()) {
                date3 = (Date)enumeration.nextElement();
                string3 = (String)enumeration.nextElement();
                long l6 = date3.getTime();
                long l7 = l6 - l5;
                long l8 = l6 % 1000L;
                float f = l7 * 100L / l;
                ZDebug.println(dateFormat.format(date3) + ":" + l8 + "#" + l7 + "[" + f + "%]" + string3);
                l5 = l6;
            }
        }
        mLaps = null;
    }

    protected static String getCaller() {
        String string = null;
        try {
            String string2 = null;
            string2.toString();
        }
        catch (NullPointerException nullPointerException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream, true);
            nullPointerException.printStackTrace(printStream);
            String string3 = byteArrayOutputStream.toString();
            int n = string3.indexOf("(");
            String string4 = string3.substring(n + 1);
            n = string4.indexOf("(");
            string4 = string4.substring(n + 1);
            n = string4.indexOf("(");
            String string5 = string4.substring(0, n);
            String[] stringArray = ZString.tokenize(string5, ".");
            String string6 = stringArray[stringArray.length - 1];
            string4 = string4.substring(n);
            n = string4.indexOf(")");
            string = string4.substring(0, n + 1) + string6 + ":";
        }
        return string;
    }

    protected static void println(String string) {
        if (mFile == null) {
            System.out.println(string);
        } else {
            try {
                FileWriter fileWriter = new FileWriter(mFile, true);
                fileWriter.write(string + "\n");
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void printErr(String string) {
        if (mFile == null) {
            System.err.println(string);
        } else {
            try {
                FileWriter fileWriter = new FileWriter(mFile, true);
                fileWriter.write("*ERR*:" + string + "\n");
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

