/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ui.UIFactory;
import jp.co.iti.fagot.ui.UWindowManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;

public class UFrame
extends JFrame
implements IZApp {
    private String mFrameName;
    private UIFactory mUIFactory;
    private UWindowManager mWindowManager = null;
    private JMenuBar mMenubar;
    private JToolBar mToolbar;
    private Hashtable mActions = new Hashtable();
    private ZResource mResource;

    public UFrame(String string) {
        this.mFrameName = string;
    }

    public void setLookAndFeel() {
        String string = this.getResource().getString("app.lookandfeel");
        if (string != null) {
            try {
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(this);
                Enumeration enumeration = this.getChildWindows().elements();
                while (enumeration.hasMoreElements()) {
                    SwingUtilities.updateComponentTreeUI((Component)enumeration.nextElement());
                }
            }
            catch (Throwable throwable) {
                ZDebug.err("Error loading L&F: " + throwable);
                throwable.printStackTrace();
            }
        }
    }

    protected void createUIFactory() {
        this.mUIFactory = new UIFactory(this);
    }

    protected void setTitle() {
        String string = this.getResource().getString("app." + this.mFrameName + ".title");
        this.setTitle(string);
        URL uRL = this.getResource().getURL("app." + this.mFrameName + ".icon");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.setIconImage(imageIcon.getImage());
        }
    }

    protected void createMenuBar() {
        this.mMenubar = this.getUIFactory().createMenuBar("app.menubar");
        if (this.mMenubar != null) {
            this.getRootPane().setJMenuBar(this.mMenubar);
        }
    }

    protected void createToolBar() {
        this.mToolbar = this.getUIFactory().createToolBar("app.toolbar");
        if (this.mToolbar != null) {
            this.getContentPane().add("North", this.mToolbar);
        }
    }

    protected void addFrameAdapter() {
        this.addWindowListener(new UFrameAdapter());
    }

    public UIFactory getUIFactory() {
        return this.mUIFactory;
    }

    public void updateRecent(String string) {
    }

    public void setWindowManager(UWindowManager uWindowManager) {
        this.mWindowManager = uWindowManager;
    }

    public UWindowManager getWindowManager() {
        return this.mWindowManager;
    }

    protected Vector getChildWindows() {
        if (this.getWindowManager() != null) {
            return this.getWindowManager().getWindows();
        }
        return new Vector();
    }

    protected void createResource() {
        this.mResource = new ZResource(this.getClass());
    }

    public void saveResource() {
        this.getResource().saveProperty();
    }

    public ZResource getResource() {
        return this.mResource;
    }

    public String getFrameName() {
        return this.mFrameName;
    }

    protected void addActions(Action[] actionArray) {
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            this.mActions.put(action.getValue("Name"), action);
        }
    }

    public Action getAction(String string) {
        return (Action)this.mActions.get(string);
    }

    public void updateActions() {
        Enumeration enumeration = this.mActions.elements();
        while (enumeration.hasMoreElements()) {
            Action action = (Action)enumeration.nextElement();
        }
    }

    public Frame getFrame() {
        return this;
    }

    public void exitFrame() {
    }

    public boolean preExit(boolean bl) {
        return true;
    }

    public void exit() {
    }

    protected class UFrameAdapter
    extends WindowAdapter {
        protected UFrameAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            UFrame.this.exitFrame();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            System.gc();
        }
    }
}

