/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.PStyle;

public class GSelector
extends GRectangle {
    public GSelector() {
        this(new ZRectangle(0.0, 0.0, 5.0, 5.0));
    }

    public GSelector(ZRectangle zRectangle) {
        this.setRect(zRectangle);
        this.getStyle().setFillColor(new FColor(Color.white));
        this.getStyle().setStrokeColor(new FColor(Color.black));
    }

    public boolean isHit(ZPoint zPoint, ZPoint zPoint2) {
        ZRectangle zRectangle = new ZRectangle(this.getRect());
        zRectangle.setCenter(zPoint);
        return zRectangle.contains(zPoint2);
    }

    public double getMargin(double d, double d2) {
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d3 * d2 * this.getRect().getWidth();
        double d5 = d3 * d * this.getRect().getHeight();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        return d6;
    }

    public GSelector createScaledSelector(double d, double d2) {
        return new GSelector(new ZRectangle(0.0, 0.0, this.getRect().getWidth() * d, this.getRect().getHeight() * d2));
    }

    public void paint(DocGraphics docGraphics) {
        Color color;
        Graphics2D graphics2D = docGraphics.getGraphics();
        PStyle pStyle = this.getStyle();
        ZRectangle zRectangle = this.getRect();
        ZPoint zPoint = zRectangle.getCenter();
        ZPoint zPoint2 = docGraphics.getGridControler().transform(zPoint);
        zRectangle.setCenter(zPoint2);
        if (!pStyle.getFill().getColor().isNull()) {
            color = graphics2D.getColor();
            graphics2D.setColor(pStyle.getFill().getColor().get());
            graphics2D.fill(zRectangle);
            graphics2D.setColor(color);
        }
        if (!pStyle.getStroke().getColor().isNull()) {
            color = graphics2D.getColor();
            graphics2D.setColor(pStyle.getStroke().getColor().get());
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(pStyle.getStroke().createStroke());
            graphics2D.draw(zRectangle);
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    public void paint(Graphics2D graphics2D, ZPoint zPoint) {
        ZRectangle zRectangle = new ZRectangle(this.getRect());
        zRectangle.setCenter(zPoint);
        graphics2D.setColor(Color.white);
        graphics2D.fill(zRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(zRectangle);
    }

    public void paintCircle(Graphics2D graphics2D, ZPoint zPoint) {
        ZRectangle zRectangle = new ZRectangle(this.getRect());
        zRectangle.setCenter(zPoint);
        graphics2D.setColor(Color.blue);
        graphics2D.fillOval((int)zRectangle.getX(), (int)zRectangle.getY(), (int)zRectangle.getWidth(), (int)zRectangle.getHeight());
        graphics2D.drawOval((int)zRectangle.getX(), (int)zRectangle.getY(), (int)zRectangle.getWidth(), (int)zRectangle.getHeight());
    }
}

