/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.fob.FInteger;
import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GPath;
import jp.co.iti.fagot.gob.GSelector;
import jp.co.iti.fagot.gob.PStyle;
import jp.co.iti.fagot.util.ZGraphicUtil;

public class GLine
extends GPath {
    protected ZLine mLine = new ZLine();
    protected FInteger mArrow = new FInteger();
    public static final int ARROW_FORWARD = 1;
    public static final int ARROW_BACKWARD = 2;
    protected int mMovePoint = 0;
    public static final int PT_NONE = -1;
    public static final int PT_START = 0;
    public static final int PT_END = 1;

    public ZRectangle getMyBounds() {
        return new ZRectangle(this.mLine.getBounds2D());
    }

    public byte getHitModeGob(ZPoint zPoint) {
        GSelector gSelector = new GSelector();
        AffineTransform affineTransform = this.getTransform().getTransform();
        gSelector = gSelector.createScaledSelector(1.0 / affineTransform.getScaleX(), 1.0 / affineTransform.getScaleY());
        if (this.isSelect()) {
            if (gSelector.isHit(this.mLine.getP1Z(), zPoint)) {
                this.mMovePoint = 0;
                return 12;
            }
            if (gSelector.isHit(this.mLine.getP2Z(), zPoint)) {
                this.mMovePoint = 1;
                return 12;
            }
        }
        if (ZGraphicUtil.isNearLine(this.mLine.getP1Z(), this.mLine.getP2Z(), zPoint, gSelector.getMargin(1.0, 0.0))) {
            this.mMovePoint = -1;
            return 1;
        }
        return 0;
    }

    public void moveStartGob(DocGridControler docGridControler) {
        switch (docGridControler.getMoveMode()) {
            case 1: {
                this.mMovePoint = -1;
                break;
            }
            case 11: {
                this.mMovePoint = 1;
                break;
            }
            case 12: {
                double d = ZGraphicUtil.getDistance(docGridControler.getStartPoint(), this.mLine.getP1Z());
                double d2 = ZGraphicUtil.getDistance(docGridControler.getStartPoint(), this.mLine.getP2Z());
                this.mMovePoint = d < d2 ? 0 : 1;
            }
        }
    }

    public ZPath getMovingPathGob(DocGridControler docGridControler) {
        return new ZPath(this.getMovingLine(docGridControler));
    }

    public ZLine getMovingLine(DocGridControler docGridControler) {
        ZPoint zPoint = docGridControler.getStartGrid();
        ZPoint zPoint2 = docGridControler.getMoveGrid();
        ZLine zLine = this.getLine();
        switch (docGridControler.getMoveMode()) {
            case 1: {
                zLine.translate(docGridControler.getOffsetGrid());
                break;
            }
            case 11: {
                zLine = new ZLine(zPoint, zPoint2);
                break;
            }
            case 12: {
                if (this.mMovePoint == 0) {
                    zLine = new ZLine(zPoint2, this.mLine.getP2Z());
                    break;
                }
                if (this.mMovePoint != 1) break;
                zLine = new ZLine(this.mLine.getP1Z(), zPoint2);
            }
        }
        return zLine;
    }

    public int getMovePoint() {
        return this.mMovePoint;
    }

    public void paintContents(DocGraphics docGraphics) {
        Shape shape;
        super.paintContents(docGraphics);
        Graphics2D graphics2D = docGraphics.getGraphics();
        PStyle pStyle = this.getStyle();
        Color color = graphics2D.getColor();
        graphics2D.setColor(pStyle.getStroke().getColor().get());
        ZPoint zPoint = docGraphics.getGridControler().transform(this.mLine.getP1Z());
        ZPoint zPoint2 = docGraphics.getGridControler().transform(this.mLine.getP2Z());
        if (this.isArrow(1)) {
            shape = ZGraphicUtil.createArrowShape(zPoint, zPoint2, 8.0, 4.0);
            graphics2D.fill(shape);
        }
        if (this.isArrow(2)) {
            shape = ZGraphicUtil.createArrowShape(zPoint2, zPoint, 8.0, 4.0);
            graphics2D.fill(shape);
        }
        graphics2D.setColor(color);
    }

    public void paintSelector(DocGraphics docGraphics) {
        docGraphics.getGridControler().pushTransform(this.getTransform());
        GSelector gSelector = new GSelector();
        ZPoint zPoint = docGraphics.getGridControler().transform(this.mLine.getP1Z());
        gSelector.paint(docGraphics.getGraphics(), zPoint);
        zPoint = docGraphics.getGridControler().transform(this.mLine.getP2Z());
        gSelector.paint(docGraphics.getGraphics(), zPoint);
        docGraphics.getGridControler().popTransform();
    }

    protected boolean paintCheck(DocGraphics docGraphics) {
        boolean bl = true;
        this.createPaintShape(docGraphics);
        Rectangle2D rectangle2D = this.mPaintShape.getBounds2D();
        Rectangle rectangle = docGraphics.getGraphics().getClipBounds();
        if (rectangle != null && ((double)rectangle.x > rectangle2D.getX() + rectangle2D.getWidth() || (double)(rectangle.x + rectangle.width) < rectangle2D.getX()) && ((double)rectangle.y > rectangle2D.getY() + rectangle2D.getHeight() || (double)(rectangle.y + rectangle.height) < rectangle2D.getY())) {
            bl = false;
        }
        return bl;
    }

    protected void createPaintShape(DocGraphics docGraphics) {
        ZPath zPath = new ZPath(this.getLine());
        this.setPath(zPath);
        this.mPaintShape = docGraphics.getGridControler().transform(zPath);
    }

    public void setLine(ZLine zLine) {
        this.mLine.setLine(zLine);
    }

    public ZLine getLine() {
        return new ZLine(this.mLine);
    }

    public void setArrow(int n) {
        this.mArrow.set(n);
    }

    public boolean isArrow(int n) {
        int n2 = this.mArrow.get();
        return (n2 & n) != 0;
    }

    public void setFobManager(FobManager fobManager) {
        super.setFobManager(fobManager);
        this.mArrow.setFobManager(fobManager, this);
    }

    public Object createClone() {
        return new GLine();
    }

    public void copyAttribute(Object object) {
        super.copyAttribute(object);
        ((GLine)object).setLine(this.getLine());
        ((GLine)object).mArrow.set(this.mArrow.get());
    }
}

