/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;

public class DocUI
extends ComponentUI {
    protected DocLayout mLayout = new DocLayout();
    protected boolean mPainting = false;
    protected Graphics mGraphics = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new DocUI();
    }

    public void installUI(JComponent jComponent) {
        jComponent.setBackground(Color.white);
        jComponent.setForeground(Color.black);
        jComponent.setOpaque(true);
        jComponent.setAutoscrolls(true);
        jComponent.setLayout(this.mLayout);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(this.mLayout);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.mPainting) {
            this.mGraphics = graphics;
            return;
        }
        this.mPainting = true;
        this.mGraphics = null;
        try {
            DocPane docPane = (DocPane)jComponent;
            if (!docPane.canPaint()) {
                this.mPainting = false;
                return;
            }
            if (docPane.isOpaque()) {
                graphics.setColor(docPane.getBackground());
                Rectangle rectangle = graphics.getClipBounds();
                if (rectangle != null) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    graphics.fillRect(0, 0, docPane.getWidth(), docPane.getHeight());
                }
            }
            boolean bl = false;
            if (docPane.isUpdateGobs()) {
                bl = true;
                docPane.createGobs();
            }
            DocGraphics docGraphics = new DocGraphics((Graphics2D)graphics, docPane.getGridControler(), bl);
            GobManager.paint(docPane, docGraphics);
            GobManager.paintCurrent(docPane, docGraphics);
            Graphics graphics2 = this.mGraphics;
            while (graphics2 != null) {
                this.mGraphics = null;
                docPane.repaint();
                graphics2 = this.mGraphics;
                this.mPainting = true;
            }
        }
        catch (Throwable throwable) {
            ZDebug.err("!!!Exception\uff1a" + throwable.toString());
            throwable.printStackTrace();
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1900", throwable.toString()));
            System.exit(0);
        }
        this.mPainting = false;
    }

    class DocLayout
    implements LayoutManager {
        protected Hashtable mComponents = new Hashtable();

        DocLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if (string.startsWith("Doc")) {
                this.mComponents.put(component, string);
            }
        }

        public void removeLayoutComponent(Component component) {
            if (this.mComponents.containsKey(component)) {
                this.mComponents.remove(component);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public void layoutContainer(Container container) {
            Enumeration enumeration = this.mComponents.keys();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                String string = (String)this.mComponents.get(component);
                String[] stringArray = ZString.tokenize(string);
                if (stringArray.length == 5) {
                    double d = ZString.parseDouble(stringArray[1], 0.0);
                    double d2 = ZString.parseDouble(stringArray[2], 0.0);
                    double d3 = ZString.parseDouble(stringArray[3], 0.0);
                    double d4 = ZString.parseDouble(stringArray[4], 0.0);
                    component.setBounds((int)d, (int)d2, (int)d3, (int)d4);
                    if (!bl) continue;
                    bl = false;
                    component.requestFocus();
                    continue;
                }
                ZDebug.trace("  \u00d7layout:" + string);
            }
        }
    }
}

