/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DefaultAction;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.IApplication;
import jp.co.iti.fagot.doc.IDocument;
import jp.co.iti.fagot.doc.IElement;
import jp.co.iti.fagot.ui.UIFactory;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZScript;
import jp.co.iti.fagot.util.ZString;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DocManager {
    protected static Hashtable mProperties = new Hashtable();
    protected static Hashtable mScripts = new Hashtable();
    protected static Hashtable mFactories = new Hashtable();
    protected static Hashtable mLayouts = new Hashtable();
    protected static Hashtable mMaps = new Hashtable();
    protected static Hashtable mTexts = new Hashtable();
    public static final String APPLICATION = "application";
    public static final String PANEL = "panel";
    public static final String DOCUMENT = "document";
    public static final String ELEMENT = "element";
    public static final String DOC_BAR = "docbar";
    public static final String UPDATE_DOCUMENT = "updateDocument";
    public static final String CREATE_PANEL = "createPanel";
    public static final String GET_BACKGROUND = "getBackground";
    public static final String CREATE_ELEMENT = "create";
    public static final String GET_HIT_MODE = "getHitMode";

    public static IApplication createApplication() {
        return (IApplication)DocManager.createInstance(APPLICATION, "main");
    }

    public static IDocument createDocument(String string) {
        return (IDocument)DocManager.createInstance(DOCUMENT, string);
    }

    public static IElement createElement(DocDocument docDocument, String string, String string2) {
        IElement iElement = (IElement)DocManager.createInstance(ELEMENT, string2);
        if (iElement != null) {
            iElement.constructElement(docDocument, string, string2);
        }
        return iElement;
    }

    public static DefaultAction[] createAction() {
        ZProperties zProperties = DocManager.loadProperty(APPLICATION);
        String[] stringArray = ZString.tokenize(zProperties.getProperty("actions"));
        DefaultAction[] defaultActionArray = new DefaultAction[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            defaultActionArray[i] = (DefaultAction)DocManager.createInstance(APPLICATION, stringArray[i]);
            defaultActionArray[i].setApp(ZApp.getTheApp());
            defaultActionArray[i].setActionName(stringArray[i]);
        }
        return defaultActionArray;
    }

    protected static Object createInstance(String string, String string2) {
        String string3 = DocManager.getClassName(string, string2);
        if (string3 != null) {
            try {
                Class<?> clazz = Class.forName(string3);
                if (clazz instanceof Class) {
                    return clazz.newInstance();
                }
                return null;
            }
            catch (Throwable throwable) {
                ZDebug.trace("Class not found:" + string3);
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public static String getClassName(String string, String string2) {
        ZProperties zProperties = DocManager.loadProperty(string);
        String string3 = zProperties.getProperty(string2 + ".package");
        String string4 = zProperties.getProperty(string2 + ".class");
        if (string3 != null && string4 != null) {
            return string3 + "." + string4;
        }
        return null;
    }

    public static UIFactory createUIFactory(String string) {
        UIFactory uIFactory = (UIFactory)mFactories.get(string);
        if (uIFactory == null) {
            uIFactory = new UIFactory(ZApp.getTheApp(), new ZResource(DocManager.loadProperty(string)));
            mFactories.put(string, uIFactory);
        }
        return uIFactory;
    }

    public static Element createElementLayout(String string) {
        Element element = (Element)mLayouts.get(string);
        if (element == null) {
            ZProperties zProperties = DocManager.loadProperty(ELEMENT);
            String string2 = zProperties.getProperty(string + ".layout");
            try {
                DOMParser dOMParser = new DOMParser();
                dOMParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                InputSource inputSource = DocManager.createInputSource(DocManager.getConfigFile(ELEMENT, string2));
                dOMParser.parse(inputSource);
                element = dOMParser.getDocument().getDocumentElement();
            }
            catch (Throwable throwable) {
                ZDebug.err("FileOpen failed:" + DocManager.getConfigFile(ELEMENT, string2));
                ZDebug.err("    " + throwable.toString());
                throwable.printStackTrace();
            }
            mLayouts.put(string, element);
        }
        return element;
    }

    public static InputSource createInputSource(String string) {
        InputSource inputSource = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            inputSource = new InputSource(bufferedInputStream);
        }
        catch (Throwable throwable) {
            ZDebug.err("FileOpen failed:" + string);
            ZDebug.err("    " + throwable.toString());
        }
        return inputSource;
    }

    public static Element createMapElement(String string) {
        Element element = (Element)mMaps.get(string);
        if (element == null) {
            try {
                DOMParser dOMParser = new DOMParser();
                dOMParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                InputSource inputSource = DocManager.createInputSource(string);
                dOMParser.parse(inputSource);
                element = dOMParser.getDocument().getDocumentElement();
            }
            catch (Throwable throwable) {
                ZDebug.err("FileOpen failed:" + string);
                ZDebug.err("    " + throwable.toString());
                throwable.printStackTrace();
            }
            mMaps.put(string, element);
        }
        return element;
    }

    public static Reader createTextFile(String string) {
        String string2 = (String)mTexts.get(string);
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n;
                FileInputStream fileInputStream = new FileInputStream(string);
                byte[] byArray = new byte[4096];
                while ((n = fileInputStream.read(byArray)) != -1) {
                    stringBuffer.append(new String(byArray, 0, n));
                }
            }
            catch (Throwable throwable) {
                ZDebug.err("FileOpen failed:" + string);
                ZDebug.err("    " + throwable.toString());
                throwable.printStackTrace();
            }
            mTexts.put(string, stringBuffer.toString());
        }
        return new StringReader(string2);
    }

    public static Object invokeDocBarFunction(String string, String string2, Object[] objectArray) {
        ZProperties zProperties = DocManager.loadProperty(DOC_BAR);
        String string3 = zProperties.getProperty(string + ".script");
        String string4 = DocManager.getConfigFile(DOC_BAR, string3);
        return DocManager.invokeFunction(string4, string2, objectArray);
    }

    private static Object invokeFunction(String string, String string2, Object[] objectArray) {
        ZScript zScript = (ZScript)mScripts.get(string);
        if (zScript == null) {
            zScript = new ZScript();
            zScript.loadScript(string);
            mScripts.put(string, zScript);
        }
        return zScript.invoke(string2, objectArray);
    }

    public static String getConfigDirectory(String string) {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string2 = zResource.getString("app.install.path");
        String string3 = zResource.getString("app.config.dir");
        return string2 + File.separator + string3 + File.separator + string;
    }

    public static String getConfigFile(String string, String string2) {
        return DocManager.getConfigDirectory(string) + File.separator + string2;
    }

    public static ZProperties loadProperty(String string) {
        return DocManager.loadProperty(string, string);
    }

    public static ZProperties loadProperty(String string, String string2) {
        String string3 = DocManager.getConfigFile(string, string2);
        String string4 = string3 + ".properties";
        ZProperties zProperties = (ZProperties)mProperties.get(string4);
        if (zProperties == null) {
            zProperties = new ZProperties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string4);
                zProperties.load(fileInputStream);
                fileInputStream.close();
                String string5 = Locale.getDefault().getLanguage();
                if (string5.length() > 0) {
                    try {
                        ZProperties zProperties2 = new ZProperties();
                        String string6 = string3 + "_" + string5 + ".properties";
                        fileInputStream = new FileInputStream(string6);
                        zProperties2.load(fileInputStream);
                        fileInputStream.close();
                        zProperties.putAll((Map<?, ?>)zProperties2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                mProperties.put(string4, zProperties);
            }
            catch (IOException iOException) {
                ZDebug.err("Custom Properties load failed:(" + string4 + ")" + iOException);
            }
        }
        return zProperties;
    }
}

