/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocUI;
import jp.co.iti.fagot.doc.DocUIAdapter;
import jp.co.iti.fagot.util.ZResource;

public class DocComponent
extends JComponent
implements Scrollable,
Accessible {
    protected DocUIAdapter mUIAdapter = null;
    protected DocDocument mDoc = null;
    protected String mPanelId = "default";
    protected DocGridControler mGrid = null;

    public DocComponent() {
        this.updateUI();
        this.setDocument(this.createDocument());
        this.addAncestorListener(new DocAncestorAdapter());
    }

    public DocComponent(String string) {
        this();
        this.mPanelId = string;
    }

    public String getPanelId() {
        return this.mPanelId;
    }

    public DocDocument createDocument() {
        DocDocument docDocument = new DocDocument();
        docDocument.initDocument();
        return docDocument;
    }

    public void setDocument(DocDocument docDocument) {
        DocDocument docDocument2 = this.mDoc;
        this.mDoc = docDocument;
        this.firePropertyChange("document", (Object)docDocument2, (Object)this.mDoc);
        this.revalidate();
        this.repaint();
        this.setUIAdapter(this.createUIAdapter());
        this.setGridControler(this.createGridControler());
    }

    public DocDocument getDocument() {
        return this.mDoc;
    }

    public DocUIAdapter createUIAdapter() {
        return null;
    }

    public void setUIAdapter(DocUIAdapter docUIAdapter) {
        if (this.mUIAdapter != null) {
            this.removeMouseListener(this.mUIAdapter);
            this.removeMouseMotionListener(this.mUIAdapter);
            this.removeKeyListener(this.mUIAdapter);
        }
        this.mUIAdapter = docUIAdapter;
        this.addMouseListener(this.mUIAdapter);
        this.addMouseMotionListener(this.mUIAdapter);
        this.addKeyListener(this.mUIAdapter);
    }

    public DocGridControler createGridControler() {
        return new DocGridControler();
    }

    public void setGridControler(DocGridControler docGridControler) {
        this.mGrid = docGridControler;
    }

    public DocGridControler getGridControler() {
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl = zResource.getBoolean("edit.grid", true);
        double d = zResource.getInt("edit.gridsize", 10);
        this.mGrid.setEnable(bl);
        this.mGrid.setGrid(d, d);
        return this.mGrid;
    }

    public void updateUI() {
        this.setUI(new DocUI());
        this.invalidate();
    }

    public void paintTemporary() {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        this.paintComponent(bufferedImage.createGraphics());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return 10;
            }
            case 0: {
                return 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return 100;
            }
            case 0: {
                return 100;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new DocAccessibleComponent();
        }
        return this.accessibleContext;
    }

    public class DocAncestorAdapter
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            DocComponent.this.requestFocus();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }

    public class DocAccessibleComponent
    extends JComponent.AccessibleJComponent {
        public DocAccessibleComponent() {
            super(DocComponent.this);
        }
    }
}

