/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2007/01/05
 *
 */
package com.kickmogu.rhythm.core.ws.serializer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.rpc.encoding.Deserializer;

import org.apache.axis.Constants;
import org.apache.axis.encoding.DeserializerFactory;

public class MemberDeserializerFactory implements DeserializerFactory {

	private static List supportedMechanismTypes;

	static {
		supportedMechanismTypes = new ArrayList();
		supportedMechanismTypes.add(Constants.AXIS_SAX);
	}

	public Iterator getSupportedMechanismTypes() {
		return supportedMechanismTypes.iterator();
	}

	public Deserializer getDeserializerAs(String mechanismType) {
		if (Constants.AXIS_SAX.equals(mechanismType)) {
			return new MemberDeserializer();
		} else {
			return null;
		}
	}

	public static DeserializerFactory create(java.lang.Class javaType, javax.xml.namespace.QName xmlType) {
		return new MemberDeserializerFactory();
	}
	
}