/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package com.kickmogu.renderer.todo
{
	import mx.controls.dataGridClasses.DataGridItemRenderer;
	import mx.controls.dataGridClasses.DataGridListData;
	import mx.controls.DataGrid;
	import mx.states.SetStyle;
	import flash.utils.describeType;

	public class TodoGraphCellRenderer extends DataGridItemRenderer 
	{
		public function TodoGraphCellRenderer()
		{
			super();
			background = true;
		}
		
		override public function set data(value:Object):void {
			super.data = value;
			if (value == null) {
				return;
			}
			var col:int = DataGridListData(listData).columnIndex;
			if (value is mx.controls.dataGridClasses.DataGridColumn) {
				super.data = value;
				percentWidth = 100;
				if (col != 0) {
					ignorePadding = true;
				}
				return;
			}
			if (value == null || col == 0 || parseInt(value["clm" + (col - 1)].toString()) == 0) {
				backgroundColor = 0xffffff;
			} else {
				backgroundColor = 0xff0000;
			}
		}
	}
}