<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.ItemVerify");
Rhaco::importLibrary("data.Feed");
class ItemTable extends TableObjectBase{
	var $id;
	var $feedId;
	var $url;
	var $title;
	var $description;
	var $updateDate;
	function ItemTable(
		$id=null
	){
		$this->id = 0;
		$this->feedId = 0;
		$this->url = null;
		$this->title = null;
		$this->description = null;
		$this->updateDate = null;
		$this->setId($id);
	}
	function setId($value){
		$this->id = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getId(){
		return $this->id;
	}
	function setFeedId($value){
		$this->feedId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getFeedId(){
		return $this->feedId;
	}
	function setUrl($value){
		$this->url = $value;
	}
	function getUrl(){
		return $this->url;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setDescription($value){
		$this->description = $value;
	}
	function getDescription(){
		return $this->description;
	}
	function setUpdateDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->updateDate = $value;
	}
	function getUpdateDate(){
		return $this->updateDate;
	}
	function formatUpdateDate($format="Y/m/d H:i:s"){
		return date($format,$this->updateDate);
	}
	function columnId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."ITEM","ITEM"),"ID","Id","SERIAL");
	}
	function columnFeedId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."ITEM","ITEM"),"FEED_ID","FeedId","INTEGER");
	}
	function columnUrl(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."ITEM","ITEM"),"URL","Url","STRING");
	}
	function columnTitle(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."ITEM","ITEM"),"TITLE","Title","STRING");
	}
	function columnDescription(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."ITEM","ITEM"),"DESCRIPTION","Description","STRING");
	}
	function columnUpdateDate(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."ITEM","ITEM"),"UPDATE_DATE","UpdateDate","TIMESTAMP");
	}
	function referenceFeedId(){
		return array(new Feed(),Feed::columnId(),$this->getFeedId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			Feed::columnId(),
			Item::columnFeedId()
		);
		return $criteria;
	}
	function criteriaFeedId($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			Feed::columnId(),
			$this->getFeedId()
		);
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new ItemVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new ItemVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(Item::columnId(),Item::columnFeedId(),Item::columnUrl(),Item::columnTitle(),Item::columnDescription(),Item::columnUpdateDate(),);
	}
	function primaryKey(){
		return array(Item::columnId(),);
	}
}
?>