<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class FeedTableVerify{
	var $valid = true;

	function FeedTableVerify(){
	}
	function verify($tableObject){
		$this->verifyId($tableObject->getId());
		$this->verifyUrl($tableObject->getUrl());
		$this->verifyUpdateDate($tableObject->getUpdateDate());
		return $this->valid;	
	}
	function verifyId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedId())),$this->_validName("id"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedId())),$this->_validName("id"));
		}
		unset($value);
	}
	function verifyUrl($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedUrl())),$this->_validName("url"));
		}
		unset($value);
	}
	function verifyUpdateDate($value){
		if(!empty($value) && !Validate::isTimestamp($value)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedUpdateDate())),$this->_validName("updateDate"));
		}
		unset($value);
	}

	function namedId(){
		return Message::_("ID");
	}
	function namedUrl(){
		return Message::_("URL");
	}
	function namedUpdateDate(){
		return Message::_("UPDATE_DATE");
	}
	function _validName($name){
		$this->valid = false;
		return "Feed_".$name;
	}
}

?>