<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class BookmarkTableVerify{
	var $valid = true;

	function BookmarkTableVerify(){
	}
	function verify($tableObject){
		$this->verifyId($tableObject->getId());
		$this->verifyUserId($tableObject->getUserId());
		$this->verifyPageId($tableObject->getPageId());
		$this->verifyTitle($tableObject->getTitle());
		$this->verifyComment($tableObject->getComment());
		$this->verifyTags($tableObject->getTags());
		return $this->valid;	
	}
	function verifyId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedId())),$this->_validName("id"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedId())),$this->_validName("id"));
		}
		unset($value);
	}
	function verifyUserId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedUserId())),$this->_validName("userId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedUserId())),$this->_validName("userId"));
		}
		unset($value);
	}
	function verifyPageId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedPageId())),$this->_validName("pageId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedPageId())),$this->_validName("pageId"));
		}
		unset($value);
	}
	function verifyTitle($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedTitle())),$this->_validName("title"));
		}
		if(!empty($value) && !Validate::isString($value,0,1000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedTitle(),1000)),$this->_validName("title"));
		}
		unset($value);
	}
	function verifyComment($value){
		if(!empty($value) && !Validate::isString($value,0,6000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedComment(),6000)),$this->_validName("comment"));
		}
		unset($value);
	}
	function verifyTags($value){
		if(!empty($value) && !Validate::isString($value,0,1000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedTags(),1000)),$this->_validName("tags"));
		}
		unset($value);
	}

	function namedId(){
		return Message::_("ID");
	}
	function namedUserId(){
		return Message::_("USER_ID");
	}
	function namedPageId(){
		return Message::_("PAGE_ID");
	}
	function namedTitle(){
		return Message::_("TITLE");
	}
	function namedComment(){
		return Message::_("COMMENT");
	}
	function namedTags(){
		return Message::_("TAGS");
	}
	function _validName($name){
		$this->valid = false;
		return "Bookmark_".$name;
	}
}

?>