<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.BookmarkVerify");
Rhaco::importLibrary("data.UserLogin");
Rhaco::importLibrary("data.Page");
class BookmarkTable extends TableObjectBase{
	var $id;
	var $userId;
	var $pageId;
	var $title;
	var $comment;
	var $tags;
	function BookmarkTable(
		$id=null
	){
		$this->id = 0;
		$this->userId = 0;
		$this->pageId = 0;
		$this->title = null;
		$this->comment = null;
		$this->tags = null;
		$this->setId($id);
	}
	function setId($value){
		$this->id = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getId(){
		return $this->id;
	}
	function setUserId($value){
		$this->userId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getUserId(){
		return $this->userId;
	}
	function setPageId($value){
		$this->pageId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getPageId(){
		return $this->pageId;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setComment($value){
		$this->comment = $value;
	}
	function getComment(){
		return $this->comment;
	}
	function setTags($value){
		$this->tags = $value;
	}
	function getTags(){
		return $this->tags;
	}
	function columnId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."BOOKMARK","BOOKMARK"),"ID","Id","SERIAL");
	}
	function columnUserId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."BOOKMARK","BOOKMARK"),"USER_ID","UserId","INTEGER");
	}
	function columnPageId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."BOOKMARK","BOOKMARK"),"PAGE_ID","PageId","INTEGER");
	}
	function columnTitle(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."BOOKMARK","BOOKMARK"),"TITLE","Title","STRING");
	}
	function columnComment(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."BOOKMARK","BOOKMARK"),"COMMENT","Comment","STRING");
	}
	function columnTags(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."BOOKMARK","BOOKMARK"),"TAGS","Tags","STRING");
	}
	function referenceUserId(){
		return array(new UserLogin(),UserLogin::columnId(),$this->getUserId());
	}
	function referencePageId(){
		return array(new Page(),Page::columnId(),$this->getPageId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			UserLogin::columnId(),
			Bookmark::columnUserId()
		);
		$criteria->add(
			Page::columnId(),
			Bookmark::columnPageId()
		);
		return $criteria;
	}
	function criteriaUserId($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			UserLogin::columnId(),
			$this->getUserId()
		);
		return $criteria;
	}
	function criteriaPageId($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			Page::columnId(),
			$this->getPageId()
		);
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new BookmarkVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new BookmarkVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(Bookmark::columnId(),Bookmark::columnUserId(),Bookmark::columnPageId(),Bookmark::columnTitle(),Bookmark::columnComment(),Bookmark::columnTags(),);
	}
	function primaryKey(){
		return array(Bookmark::columnId(),);
	}
}
?>