<?php
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.table.PageTable");
class Page extends PageTable{
	var $feed;
	var $bookmarkList = array();
	var $itemList = array();
	
	function getTagList(){
		if(!empty($this->tags)){
			return array_merge(split(" ",$this->tags));
		}
		return array();
	}
	function setTags($value){
		$tags = array();
		
		if(is_array($value)){
			$value = implode(" ",$value);
		}
		foreach(split(" ",str_replace("　"," ",$value)) as $tag){
			if(!empty($tag)){
				$tags[$tag] = $tag;
			}
		}
		sort($tags);
		$this->tags = implode(" ",$tags);
	}
	function setUrl($value){
		parent::setUrl(preg_replace("/[\r\n]/","",$value));
	}
	function setTitle($value){
		parent::setTitle(preg_replace("/[\r\n]/","",$value));
	}
	function setFeed($feed){
		if(Variable::isClassType(Feed,$feed)){
			$this->feed = $feed;
		}
	}
	function getFeed(){
		return $this->feed;
	}
	function setBookmark($bookmark){
		foreach(Variable::toArray($bookmark) as $bm){		
			if(Variable::isClassType(Bookmark,$bm)){
				$this->bookmarkList[] = $bm;
			}
		}
	}
	function getBookmark(){
		return Variable::toArray($this->bookmarkList);
	}
	function setItem($item){
		foreach(Variable::toArray($item) as $im){		
			if(Variable::isClassType(Item,$im)){
				$this->itemList[] = $im;
			}
		}
	}
	function getItem(){
		return Variable::toArray($this->itemList);
	}
	function admin(){
		
	}
}
?>