<?php
Rhaco::importLibrary("data.table.BookmarkTable");
class Bookmark extends BookmarkTable{
	var $page;
	var $userDetail;
	
	function setTitle($value){
		parent::setTitle(preg_replace("/[\r\n]/","",$value));
	}
	function setUserDetail($value){
		$this->userDetail = $value;
	}
	function getLogin(){
		$userDetail = $this->getUserDetail();
		return $userDetail->getLogin();
	}
	function getUserDetail(){
		if(Variable::isClassType(UserDetail,$this->userDetail)){
			return $this->userDetail;
		}
		return new UserDetail();
	}
	function setPage($value){
		$this->page = $value;
	}
	function getPage(){
		if(Variable::isClassType(Page,$this->page)){
			return $this->page;
		}
		return new Page();
	}
	function getUrl(){
		if(Variable::isClassType(Page,$this->page)){
			return $this->page->getUrl();
		}
		return "";
	}
	function getDescription(){
		if(Variable::isClassType(Page,$this->page)){
			return $this->page->getDescription();
		}
		return "";
	}
	function getTagList(){
		if(!empty($this->tags)){
			return array_merge(split(" ",$this->tags));
		}
		return array();
	}
	function setTags($value){
		$tags = array();
		
		if(is_array($value)){
			$value = implode(" ",$value);
		}
		foreach(split(" ",str_replace("　"," ",$value)) as $tag){
			if(!empty($tag)){
				$tags[$tag] = $tag;
			}
		}
		sort($tags);
		$this->tags = implode(" ",$tags);
	}
	function admin(){
		
	}
}
?>