<?php
Rhaco::import("lang.StringUtil");
Rhaco::import("tag.data.SimpleTag");
Rhaco::import("tag.feed.FeedParser");
Rhaco::import("tag.SimpleTagParser");
Rhaco::importLibrary("data.Page");
Rhaco::importLibrary("data.Feed");
Rhaco::importLibrary("data.PageFeed");
Rhaco::importLibrary("data.Item");
Rhaco::importLibrary("data.Query");
Rhaco::importLibrary("DbUtilGoesby");

class PageController{
	function add($url,$dbUtil=null){
		if(preg_match("/^http[s]*:\/\//i",$url)){
			$dbUtil	= DbUtilGoesby::instance($dbUtil);
			$url		= StringUtil::encoding($url,StringUtil::getEncodeTypeUTF8());
			$page	= $dbUtil->get(new Page(),new Criteria(Page::columnUrl(),$url));
	
			if(!Variable::isClassType(Page,$page)){
				$page = $dbUtil->insert(Variable::hashConvObject(array("url"=>$url,"title"=>$url,"registDate"=>time()),new Page()));
			}
			return PageController::update($page,$dbUtil);
		}
		return false;
	}	
	function update($pageIdOrPage,$dbUtil=null){
		$dbUtil	= DbUtilGoesby::instance($dbUtil);
		if(!Variable::isClassType(Page,$pageIdOrPage)){			
			$pageIdOrPage = $dbUtil->get(new Page($pageIdOrPage));
		}
		if(Variable::isClassType(Page,$pageIdOrPage)){
			$page	= $pageIdOrPage;
			$src		= Http::body($page->getUrl());
			$tag		= new SimpleTag();
			$tag->set(SimpleTagParser::xhtmlnize($src,"meta"),"head");

			foreach($tag->getIn("title") as $titletag){
				$page->setTitle(StringUtil::encoding($titletag->getValue(),StringUtil::getEncodeTypeUTF8()));
				break;
			}
			foreach($tag->getIn("rdf:RDF") as $rdftag){
				foreach($rdftag->getIn("rdf:Description") as $desctag){
					$page->setDescription(StringUtil::encoding($desctag->getParameter("dc:description"),StringUtil::getEncodeTypeUTF8()));
					break;
				}
			}
			if($page->getDescription() == ""){
				foreach($tag->getIn("meta") as $intag){
					$name = strtolower($intag->getParameter("name"));

					if("description" == $name){
						$page->setDescription(StringUtil::encoding($intag->getParameter("content"),StringUtil::getEncodeTypeUTF8()));
						break;
					}
					if("keywords" == $name){
						$page->setDescription(StringUtil::encoding($intag->getParameter("content"),StringUtil::getEncodeTypeUTF8()));
						break;
					}
				}
			}
			$tagList		= array();
			$criteria	= new Criteria(Bookmark::columnPageId(),$page->getId());
			$criteria->addOrder(Bookmark::columnId());
			$bookmarkList = $dbUtil->select(new Bookmark(),$criteria);

			if($page->getDescription() == ""){
				foreach($bookmarkList as $bookmark){
					if($bookmark->getComment() != ""){
						$page->setDescription($bookmark->getComment());
						break;
					}
				}
			}				
			foreach($bookmarkList as $bookmark){
				$tagList = array_merge($tagList,$bookmark->getTagList());
			}
			$page->setCount(sizeof($bookmarkList));
			$page->setTags($tagList);		
			$page->setUpdateDate(time());
			$dbUtil->update($page);
			$dbUtil->delete(new PageFeed(),new Criteria(PageFeed::columnPageId(),$page->getId()));
			
			$feedurl = FeedParser::alternateUrl($page->getUrl(),$src);

			if(!empty($feedurl)){
				$feed = $dbUtil->get(new Feed(),new Criteria(Feed::columnUrl(),$feedurl));

				if(!Variable::isClassType(Feed,$feed)){
					$feed = new Feed();
					$feed->setUrl($feedurl);
					$feed = $dbUtil->insert($feed);
				}
				if(Variable::isClassType(Feed,$feed)){
					$dbUtil->insert(new PageFeed($page->getId(),$feed->getId()));
					$page->setFeed($feed);
				}
			}
		}
		return $page;
	}
	function search($query=null,$offset=0,$dbUtil=null){
		$dbUtil		= DbUtilGoesby::instance($dbUtil);
		$criteria	= new Criteria();
		$criteria->setLimit(Rhaco::define("LIST_MAX_COUNT"));
		$criteria->setOffset($offset);
		
		if(Variable::isClassType(Query,$query)){
			if($query->isRssTime()){
				$criteria = Item::related(PageFeed::related(Page::related($criteria)));
				$criteria->addGreaterEquals(Item::columnUpdateDate(),DateUtil::addHour(time(),$query->getRssTime() * -1));
			}
			foreach($query->getKeywords() as $word){
				$keyword = new Criteria();
				$keyword->addLikei(Page::columnDescription(),$word);
				
				$keywordor = new Criteria();
				$keywordor->addLikei(Page::columnTitle(),$word);				
				$keyword->addCriteriaOr($keywordor);
				
				$keywordor = new Criteria();
				$keywordor->addLikei(Page::columnTags(),$word);				
				$keyword->addCriteriaOr($keywordor);

				$keywordor = new Criteria();
				$keywordor->addLike(Page::columnUrl(),$word);				
				$keyword->addCriteriaOr($keywordor);
								
				$criteria->addCriteria($keyword);
			}
			foreach($query->getTags() as $tag){
				$criteria->addLikei(Page::columnTags(),$tag);				
			}
		}
		if($query->isRssTime()){
			$criteria->addOrder(Item::columnUpdateDate());	
			$criteria->addOrder(Item::columnId());		
			list($pageList,$playList) = $dbUtil->select(array(new Page(),new Item()),$criteria);						
			$playList 	= $dbUtil->combineTableObject($playList,Item::columnUrl());
			$count		= sizeof($playList);
		}else{
			$criteria->addOrderDesc(Page::columnId());	
			$pageList	= $dbUtil->select(new Page(),$criteria);
			$playList	= $pageList;
			$count		= $dbUtil->count(new Page(),$criteria);
		}
		return array($dbUtil->combineTableObject($pageList,Page::columnId()),$playList,$count);
	}
	function get($pageId,$offset=0,$dbUtil=null){
		$dbUtil		= DbUtilGoesby::instance($dbUtil);
		$page		= $dbUtil->get(new Page($pageId));
		
		if(Variable::isClassType(Page,$page)){
			$criteria		= new Criteria(Bookmark::columnPageId(),$page->getId());
			$criteria->setLimit(Rhaco::define("LIST_MAX_COUNT"));
			$criteria->setOffset($offset);
			$criteria->addOrderDesc(Bookmark::columnId());			
			$bookmarkList	= $dbUtil->select(new Bookmark(),$criteria);
			$count			= $dbUtil->count(new Bookmark(),$criteria);

			$criteria		= new Criteria();
			$criteria->addIn(UserLogin::columnId(),$dbUtil->extractionTableColumn($bookmarkList,Bookmark::columnUserId()));
			list($userList,$userDetailList) = $dbUtil->select(array(new UserLogin(),new UserDetail()),$criteria);			
			$userList		= $dbUtil->combineTableObject($userList,UserLogin::columnId());
			$userDetailList	= $dbUtil->combineTableObject($userDetailList,UserDetail::columnUserId());			

			foreach($bookmarkList as $key => $bookmark){
				$userDetailList[$bookmark->getUserId()]->setUser($userList[$bookmark->getUserId()]);
				$bookmark->setUserDetail($userDetailList[$bookmark->getUserId()]);
				$bookmarkList[$key] = $bookmark;
			}
			$criteria		= new Criteria(Page::columnId(),$page->getId());
			$criteria		= Item::related(PageFeed::related(Page::related($criteria)));			
			$criteria->addOrder(Item::columnUpdateDate());
			$itemList		= $dbUtil->select(new Item(),$criteria);

			$page->setBookmark($bookmarkList);
			$page->setItem($itemList);
			return array($page,$count);
		}
		return false;
	}
	function getPlays($ids,$rssTime,$dbUtil=null){
		if(!Variable::isClassType(DbUtil,$dbUtil)){
			$dbUtil	= new DbUtil(new DbConnectionGoesby());
		}
		if(!empty($rssTime)){
			$criteria = new Criteria();
			$criteria->addIn(Item::columnId(),split(",",$ids));
			$criteria->addOrder(Item::columnUpdateDate());	
			$criteria->addOrder(Item::columnId());		

			return $dbUtil->combineTableObject($dbUtil->select(new Item(),$criteria),Item::columnUrl());
		}
		$criteria = new Criteria();
		$criteria->addIn(Page::columnId(),split(",",$ids));
		$criteria->addOrder(Page::columnId());	
		return $dbUtil->select(new Page(),$criteria);
	}
	function getItem($dbUtil=null){
		if(!Variable::isClassType(DbUtil,$dbUtil)){
			$dbUtil	= new DbUtil(new DbConnectionGoesby());
		}
		$criteria = new Criteria();
		$criteria->setOffset(0);
		$criteria->setLimit(Rhaco::define("LIST_MAX_COUNT",30));
		$criteria->addOrderDesc(Item::columnUpdateDate());
		
		return $dbUtil->select(new Item(),$criteria);
	}
	function updateFeed($feed,$dbUtil=null){		
		if(Variable::isClassType(Feed,$feed)){
			if(!Variable::isClassType(DbUtil,$dbUtil)){
				$dbUtil	= new DbUtil(new DbConnectionGoesby());
			}
			$criteria	= new Criteria();
			$result		= Http::modified($feed->getUrl(),DateUtil::addHour(time(),(Rhaco::define("RSS_GET_MAX_HOUR",98) * -1)),1);	

			if(is_bool($result) && $result == false){
				foreach($dbUtil->select(new PageFeed(),new Criteria(PageFeed::columnFeedId(),$feed->getId())) as $pageFeed){
					$dbUtil->delete($pageFeed);
				}
				$dbUtil->delete($feed);
				return false;
			}else{
				$itemList		= array();
				$rss				= FeedParser::parse($result);
				$count			= 0;

				foreach($rss->getItem() as $item){
					$toItem = new Item();
					$toItem->setFeedId($feed->getId());
					$toItem->setTitle($item->getTitle());
					$toItem->setUrl($item->getLink());
					$toItem->setUpdateDate($item->getPubDate());
					$toItem->setDescription($item->getDescription());
										
					$itemList[$item->getLink()] = $toItem;
					
					if($count++ >= 10){
						break;
					}
				}
				$criteria = new Criteria();
				$criteria->addIn(Item::columnUrl(),array_keys($itemList));

				foreach($dbUtil->select(new Item(),$criteria) as $item){
					unset($itemList[$item->getUrl()]);
				}
				foreach(Variable::toArray($itemList) as $item){
					$dbUtil->insert($item);
				}
				$feed->setUpdateDate(time());
				$dbUtil->update($feed);
				return $toItem;
			}
		}
		return false;
	}
	function deleteItem($dbUtil=null){
		$dbUtil		= DbUtilGoesby::instance($dbUtil);
		$criteria	= new Criteria();
		$criteria->addLess(Item::columnUpdateDate(),DateUtil::addHour(time(),(Rhaco::define("RSS_GET_MAX_HOUR") * -1)));
		$dbUtil->delete(new Item(),$criteria);
	}
}
?>