<?php
Rhaco::import("lang.Variable");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.DuplicateException");
Rhaco::importLibrary("data.Page");
Rhaco::importLibrary("data.Bookmark");
Rhaco::importLibrary("UserController");
Rhaco::importLibrary("PageController");
Rhaco::importLibrary("data.Query");
Rhaco::importLibrary("DbUtilGoesby");

class BookmarkController{
	function add($loginUserDetail,$url,$dbUtil=null){
		if(Variable::isClassType(UserDetail,$loginUserDetail)){
			$dbUtil		= DbUtilGoesby::instance($dbUtil);
			$page		= PageController::add($url,$dbUtil);
			$bookmark	= $dbUtil->get(new Bookmark(),
								new Criteria(
									Criterion::equal(Bookmark::columnUserId(),$loginUserDetail->getUserId()),
									Criterion::equal(Bookmark::columnPageId(),$page->getId())
							));
			if(!Variable::isClassType(Bookmark,$bookmark)){
				$bookmark = $dbUtil->insert(
								Variable::hashConvObject(
									array("pageId"=>$page->getId(),"userId"=>$loginUserDetail->getUserId(),"title"=>$page->getTitle(),"comment"=>$page->getDescription())
									,new Bookmark()));
				$page->setCount($page->getCount() + 1);
				
				if($dbUtil->update($page)){
					$user = $dbUtil->get(new UserDetail(),new Criteria(UserDetail::columnUserId(),$loginUserDetail->getUserId()));			
					if(Variable::isClassType(UserDetail,$user)){
						$user->setBookmarkCount($user->getBookmarkCount() + 1);
						if($dbUtil->update($user)){
							$dbUtil->commit();
							return true;
						}
					}
				}
			}
			$dbUtil->rollback();
		}
		return false;
	}
	function search($login,$query=null,$dbUtil=null){
		$dbUtil			= DbUtilGoesby::instance($dbUtil);
		$bookmarkList	= array();
		$pageList		= array();
		$playList		= array();
		$rssmode			= false;
		$criteria		= Bookmark::related(
							new Criteria(
								Criterion::equal(UserLogin::columnLogin(),$login),
								Criterion::equal(Bookmark::columnUserId(),UserLogin::columnId()
							)));
		if(Variable::isClassType(Query,$query)){
			if($query->isRssTime()){
				$rssmode		= true;
				$criteria	= PageFeed::related(Item::related(Page::related($criteria)));
				$criteria->addGreaterEquals(Item::columnUpdateDate(),DateUtil::addHour(time(),$query->getRssTime() * -1));
			}
			if($query->isLimit()){
				$criteria->setOffset($query->getOffset());				
				$criteria->setLimit($query->getLimit());
			}
			foreach($query->getKeywords() as $word){
				$keyword = new Criteria();
				$keyword->addLikei(Bookmark::columnComment(),$word);
				$keyword->addCriteriaOr(new Criteria(Criterion::ilike(Bookmark::columnTitle(),$word)));
				$keyword->addCriteriaOr(new Criteria(Criterion::ilike(Bookmark::columnTags(),$word)));
				$keyword->addCriteriaOr(new Criteria(Criterion::ilike(Page::columnUrl(),$word)));
				$criteria->addCriteria($keyword);
			}
			foreach($query->getTags() as $tag){
				$criteria->addLike(Bookmark::columnTags(),$tag);				
			}
		}
		if($rssmode){
			$criteria->addOrder(Item::columnUpdateDate());	
			$criteria->addOrder(Item::columnId());
			
			list($bookmarkList,$pageList,$playList)	= $dbUtil->select(array(new Bookmark(),new Page(),new Item()),$criteria);
			$playList		= $dbUtil->combineTableObject($playList,Item::columnUrl());
			$bookmarkList	= $dbUtil->combineTableObject($bookmarkList,Bookmark::columnId());
			$count			= sizeof($bookmarkList);
		}else{
			$criteria->addOrderDesc(Bookmark::columnId());
			list($bookmarkList,$pageList)	= $dbUtil->select(array(new Bookmark(),new Page()),$criteria);
			$playList	= $pageList;
			$count		= $dbUtil->count(new Bookmark(),$criteria);
		}
		if(!empty($bookmarkList)){
			foreach($bookmarkList as $key => $bookmark){
				$bookmarkList[$key]->setPage($pageList[$key]);
			}
		}
		return array($bookmarkList,$playList,$count);
	}
	function drop($loginUserDetail,$bookmarkId,$dbUtil=null){
		if(Variable::isClassType(UserDetail,$loginUserDetail)){		
			$dbUtil	= DbUtilGoesby::instance($dbUtil);
			$getbm	= $dbUtil->get(new Bookmark($bookmarkId));
			
			if(Variable::isClassType(Bookmark,$getbm) && $loginUserDetail->getUserId() == $getbm->getUserId()){
				if($dbUtil->delete(new Bookmark($bookmarkId))){
					$user = $dbUtil->get(new UserDetail(),new Criteria(UserDetail::columnUserId(),$loginUserDetail->getUserId()));			
					if(Variable::isClassType(UserDetail,$user)){
						$user->setBookmarkCount($dbUtil->count(new Bookmark(),new Criteria(Bookmark::columnUserId(),$loginUserDetail->getUserId())));
						if($dbUtil->update($user)){
							$dbUtil->commit();
							return true;
						}
					}
				}
			}
		}
		$dbUtil->rollback();
		return false;
	}	
	function get($id,$dbUtil=null){
		$dbUtil		= DbUtilGoesby::instance($dbUtil);		
		$criteria	= new Criteria(
							Criterion::equal(Page::columnId(),Bookmark::columnPageId()),
							Criterion::equal(Bookmark::columnId(),$id));
		list(list($bookmark),list($page))	= $dbUtil->select(array(new Bookmark(),new Page()),$criteria);
		
		if(Variable::isClassType(Bookmark,$bookmark)){
			$bookmark->setPage($page);
			return $bookmark;
		}
		return false;
	}
	function update($loginUserDetail,$bookmark,$dbUtil=null){
		if(Variable::isClassType(UserDetail,$loginUserDetail) && Variable::isClassType(Bookmark,$bookmark)){
			$dbUtil	= DbUtilGoesby::instance($dbUtil);
			$getbm	= $dbUtil->get($bookmark);

			if(Variable::isClassType(Bookmark,$getbm) && $loginUserDetail->getUserId() == $getbm->getUserId()){
				$getbm->setTitle($bookmark->getTitle());
				$getbm->setComment($bookmark->getComment());
				$getbm->setTags($bookmark->getTags());

				if($dbUtil->update($getbm)){
					$page		= $dbUtil->get(new Page($getbm->getPageId()));
					
					if(Variable::isClassType(Page,$page)){
						$page->setTags(array_merge($page->getTagList(),$bookmark->getTagList()));
						if($dbUtil->update($page)){
							$userDetail = $dbUtil->get($loginUserDetail);
							$userDetail->setTags(array_merge($userDetail->getTagList(),$bookmark->getTagList()));
							if($dbUtil->update($userDetail)){
								$dbUtil->commit();
								return true;
							}
						}
					}
				}
			}else{
				ExceptionTrigger::raise(new PermissionException(Message::__("Bookmarks")));
			}
		}
		$dbUtil->rollback();
		return false;
	}
	function import($loginUserDetail,$file,$dbUtil=null){
		if(Variable::isClassType(UserDetail,$loginUserDetail) && Variable::isClassType(File,$file)){
			$urlList			= array();
			$bookmarkList	= array();
			$fileUtil		= new FileUtil();
			$feed			= FeedParser::parse($fileUtil->read($file->getTmp()));

			foreach($feed->getItem() as $item){
				$urlList[]	= $item->getLink();
			}
			$dbUtil			= DbUtilGoesby::instance($dbUtil);
			$criteria		= new Criteria(Criterion::in(Page::columnUrl(),$urlList));
			$pageList		= $dbUtil->combineTableObject($dbUtil->select(new Page(),$criteria),Page::columnUrl());
			$criteria		= Bookmark::related(new Criteria(
										Criterion::equal(Bookmark::columnUserId(),$loginUserDetail->getUserId()),
										Criterion::in(Page::columnUrl(),$urlList)));
			$bookmarkList	= $dbUtil->combineTableObject($dbUtil->select(new Bookmark(),$criteria),Bookmark::columnPageId());

			foreach($feed->getItem() as $item){
				if(!isset($pageList[$item->getLink()])){
					if($item->getTitle() == ""){
						$item->setTitle($item->getLink());
					}					
					$page = $dbUtil->insert(Variable::hashConvObject(array("url"=>$item->getLink(),"title"=>$item->getTitle(),"registDate"=>time()),new Page()));					
				}else{
					$page = $pageList[$item->getLink()];
				}
				if(Variable::isClassType(Page,$page) && !isset($bookmarkList[$page->getId()])){
					$bookmark = $dbUtil->insert(Variable::hashConvObject(
									array("pageId"=>$page->getId(),"userId"=>$loginUserDetail->getUserId(),"title"=>$item->getTitle(),"comment"=>$item->getComments(),"tags"=>$item->getDescription())
									,new Bookmark()));
					$page->setCount($page->getCount() + 1);
					$dbUtil->update($page);
				}
			}
			$user = $dbUtil->get(new UserDetail(),new Criteria(UserDetail::columnUserId(),$loginUserDetail->getUserId()));
			
			if(Variable::isClassType(UserDetail,$user)){
				$user->setBookmarkCount($dbUtil->count(new Bookmark(),new Criteria(Bookmark::columnUserId(),$loginUserDetail->getUserId())));
				$dbUtil->update($user);
				$dbUtil->commit();
			}
			$dbUtil->rollback();
		}
	}
	function redirect($userDetail){
		if(Variable::isClassType(UserDetail,$userDetail)){
			Header::redirect(Rhaco::url(sprintf("bookmarkList.php/%s",$userDetail->getLogin())));
		}
	}
}
?>