<?php
require_once("./__init__.php");
Rhaco::import("tag.feed.FeedParser");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("DbUtilGoesby");
Rhaco::importLibrary("PageController");
Rhaco::importLibrary("data.Item");

$dbUtil		= DbUtilGoesby::instance($dbUtil);
$itemList	= array();
$urlList		= array();
$exsistList	= array();

$criteria	= new Criteria();
$criteria->addLess(Feed::columnUpdateDate(),DateUtil::addHour(time(),-12));
$criteria->setLimit(Rhaco::define("UPDATE_FEED_SIZE"));
foreach($dbUtil->select(new Feed(),$criteria) as $feed){
	$toItem		= PageController::updateFeed($feed,$dbUtil);
	
	if(Variable::isClassType(Item,$toItem)){
		$itemList[]	= $toItem;
		$urlList[]	= $toItem->getUrl();
	}
}
if(sizeof($urlList) > 0){
	$criteria = new Criteria();
	$criteria->addIn(Item::columnUrl(),$urlList);
	foreach($dbUtil->select(new Item(),$criteria) as $item){
		$exsistList[$item->getUrl()] = 1;
	}
}
foreach($itemList as $item){
	if(!isset($exsistList[$item->getUrl()])){
		$dbUtil->insert($item);
	}
}
$dbUtil->commit();
?>