<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Assert.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class UnitTest extends Assert{
	var $testtarget	= array();
	
	function UnitTest(){
		parent::Assert();
		$this->begin();
		$this->testtarget = array_flip(Variable::toArray($this->testtarget));
		$this->test();
	}
	function begin(){		
	}
	function setUp(){
	}
    function tearDown(){
	}
	function test(){
		$this->method	= get_class($this);
		$className		= strtolower($this->method);

		foreach(get_class_methods($this) as $methodName){	
			if(preg_match("/^test(.+)$/",$methodName)){
				if($className != strtolower($methodName)){
					if($this->_isTarget($methodName)){
						$this->method = sprintf("%s::%s",$className,$methodName);
						$this->setUp();
							$usec	= $this->_getTime();
							call_user_func(array($this,$methodName));
							$eusec	= $this->_getTime() - $usec;
							$GLOBALS["ASSERT"][] = sprintf("(%s)%s %s microsecond\n",$this->method,"EXECUTE_TIME",($eusec>0)?$eusec:0);
						$this->tearDown();
					}
				}
			}
		}
	}
	function flush(){
		if(is_array($GLOBALS["ASSERT"])){
			foreach($GLOBALS["ASSERT"] as $assert){
				print($assert);
			}
		}
		unset($GLOBALS["ASSERT"]);
	}
	function _isTarget($name){
		if(!is_array($this->testtarget) || empty($this->testtarget)){
			return true;
		}
		return array_key_exists(strtolower($name),$this->testtarget);
	}
	function setTarget($name){
		$list	= Variable::toArray($name);
		$new		= array();
		foreach($list as $value){
			$new[] = strtolower($value);
		}
		$this->testtarget = array_merge(Variable::toArray($this->testtarget),$new);
	}
	function _getTime(){
		$time	= gettimeofday();
		return ($time["sec"].str_replace(" ","0",sprintf("%-6d",$time["usec"])));
	}
}
?>