<?php
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class OpmlOutline{
	var $text = "";
	var $type = "";
	var $value = "";
	
	var $isComment = false;
	var $isBreakpoint = false;	
		
	var $htmlUrl = "";
	var $xmlUrl = "";
	var $title = "";
	var $description = "";
	var $outlineList = array();

	var $tags = "";

	function set($src,$tags=""){
		$tag = new SimpleTag();

		if(!$tag->set($src,"outline")){	
			return false;
		}
		$this->setText($tag->getParameter("text"));
		$this->setType($tag->getParameter("type"));
		$this->setIsComment($tag->getParameter("isComment",false));
		$this->setIsBreakpoint($tag->getParameter("isBreakpoint",false));		

		$this->setHtmlUrl($tag->getParameter("htmlUrl"));
		$this->setXmlUrl($tag->getParameter("xmlUrl"));
		$this->setTitle($tag->getParameter("title"));
		$this->setDescription($tag->getParameter("description"));

		if($this->getTitle() == ""){
			$tags = trim($tags)." ".trim($this->getText());
		}else{
			$this->setTags($tags);
		}
		foreach($tag->getIn("outline") as $outlinetag){
			$outline = new OpmlOutline();
			$outline->set($outlinetag->getPlain(),$tags);
			$this->outlineList[] = $outline;
		}
		return true;
	}
	function get(){
		$outTag	= new SimpleTag("outline");
		if($this->getText() != "")		$outTag->setParameter("text",$this->getText());
		if($this->getType() != "")		$outTag->setParameter("type",$this->getType());
		if($this->getIsComment() != "")	$outTag->setParameter("isComment",$this->getIsComment());
		if($this->getIsBreakpoint() != "")$outTag->setParameter("isBreakpoint",$this->getIsBreakpoint());
		
		if($this->getHtmlUrl() != "")		$outTag->setParameter("htmlUrl",$this->getHtmlUrl());
		if($this->getXmlUrl() != "")		$outTag->setParameter("xmlUrl",$this->getXmlUrl());
		if($this->getTitle() != "")		$outTag->setParameter("title",$this->getTitle());
		if($this->getDescription() != "")	$outTag->setParameter("description",$this->getDescription());
		if($this->getTags() != "")		$outTag->setParameter("tags",$this->getTags());		

		$outTag->addValue($this->getValue());
		
		foreach(Variable::toArray($this->outlineList) as $outline){
			$outTag->addValue($outline->get());
		}
		return $outTag->get();
	}
	function setText($value){
		$this->text = $value;
	}
	function getText(){
		return $this->text;
	}
	function setType($value){
		$this->type = $value;
	}
	function getType(){
		return $this->type;
	}
	function setIsComment($value){
		$this->isComment = Variable::getBoolean($value);
	}
	function getIsComment(){
		return $this->isComment;
	}
	function setIsBreakpoint($value){
		$this->isBreakpoint = Variable::getBoolean($value);
	}
	function getIsBreakpoint(){
		return $this->isBreakpoint;
	}
	function setValue($value){
		$this->value = $value;
	}
	function getValue(){
		return $this->value;
	}
	function setHtmlUrl($value){
		$this->htmlUrl = $value;
	}
	function getHtmlUrl(){
		return $this->htmlUrl;
	}
	function setXmlUrl($value){
		$this->xmlUrl = $value;
	}
	function getXmlUrl(){
		return $this->xmlUrl;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setDescription($value){
		$this->description = $value;
	}
	function getDescription(){
		return $this->description;
	}
	function getHtmlOutlines(){
		$list = array();		

		if($this->getHtmlUrl() != ""){
			$list[] = $this;
		}
		foreach($this->outlineList as $outline){
			$list = array_merge($list,$outline->getHtmlOutlines());
		}
		return $list;
	}
	function getXmlOutlines(){
		$list = array();		

		if($this->getXmlUrl() != ""){
			$list[] = $this;
		}
		foreach($this->outlineList as $outline){
			$list = array_merge($list,$outline->getXmlOutlines());
		}
		return $list;
	}
	function getItems(){
		$items = $this->getItem();
		
		foreach($this->getBlock() as $block){
			$items = array_merge($items,$block->getItems());
		}
		return $items;
	}
	function setTags($value){
		if($this->tags != ""){
			$this->tags = trim($this->tags)." ";
		}
		$this->tags .= trim($value);
	}
	function getTags(){
		return $this->tags;
	}
}
?>