<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/NetscapeBookmarkItem.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 */
class NetscapeBookmarkBlock{
	var $category = "";
	var $itemList = array();
	var $blockList = array();

	function NetscapeBookmarkBlock(){
	}
	function set($src,$category=""){
		$pregDTH	= "<DT>[\s\n\t]*(<H3[\s\n\t].+>.+<\/H3>)[\s\n\t]*(<DL>([^<]*))";
		$pregDTA	= "<DT>[\s\n\t]*(<A[\s\n\t].+>.+<\/A>)";
		$pregDD		= "[\s\n\t]*<DD>([^<]*)";

		$tag = new SimpleTag();

		if($tag->set($src,"dl")){
			$source = $tag->getValue();

			while(preg_match("/<DT>[\s\n\t]*<H3[\s\n\t].+>.+<\/H3>[\s\n\t]*[^<]*/i",$source,$matches)){
				$htag	= new SimpleTag();
				$block	= new NetscapeBookmarkBlock();
				$target	= substr($source,0,strpos($source,$matches[0]));
				$source	= substr($source,strlen($target));

				if($htag->set($source,"h3")){
					$block->category	= $htag->getValue();
					$source			= substr($source,strlen($matches[0]));
					$target			.= $matches[0];
					$tags			= trim($category)." ".trim($block->category);

					if(preg_match("/^<DL/",$source)){
						$dltag = new SimpleTag();

						if($dltag->set($source,"dl")){
							$block->set($dltag->getPlain(),$tags);
							$source	= substr($source,strlen($dltag->getPlain()));
							$target	.= $dltag->getPlain();
						}
					}
				}
				$src					= str_replace($target,"",$src);
				$this->blockList[]	= $block;				
			}
			if(preg_match_all(sprintf("/%s%s/i",$pregDTA,$pregDD),$src,$matches)){
				foreach($matches[1] as $key => $dtvalue){
					$item = new NetscapeBookmarkItem();
					$item->set($dtvalue,$matches[2][$key]);	
					$item->setTags($category);
					$this->setItem($item);
					$src = str_replace($matches[0][$key],"",$src);
				}
			}
			if(preg_match_all(sprintf("/%s/i",$pregDTA),$src,$matches)){
				foreach($matches[1] as $key => $dtvalue){
					$item = new NetscapeBookmarkItem();
					$item->set($dtvalue);
					$item->setTags($category);
					$this->setItem($item);
					$src = str_replace($matches[0][$key],"",$src);
				}
			}
		}
	}
	function get(){
		$src	= "";

		if($this->category != ""){
			$tag	= new SimpleTag("h3",$this->getCategory());
			$tag->setAttribute("folded");
			$src	.= $tag->get()."\n";
		}
		$src	.= "<dl><p>\n";
		foreach($this->getBlock() as $block){
			if(Variable::isClassType(NetscapeBookmarkBlock,$block)){
				$src .= $block->get();
			}
		}
		foreach($this->getItem() as $item){
			if(Variable::isClassType(NetscapeBookmarkItem,$item)){
				$src .= $item->get();
			}
		}
		$src	.= "</dl><p>\n";
		return $src;
	}

	function setCategory($value){
		$this->category = $value;
	}
	function getCategory(){
		return $this->category;
	}
	function getBlock(){
		return Variable::toArray($this->blockList);
	}
	function getItem(){
		return Variable::toArray($this->itemList);
	}
	function getItems(){
		$items = $this->getItem();
		
		foreach($this->getBlock() as $block){
			$items = array_merge($items,$block->getItems());
		}
		return $items;
	}
	function setItem($titleOrObject,$description="",$link=""){
		if(Variable::isClassType(NetscapeBookmarkItem,$titleOrObject)){
			$this->itemList[] = $titleOrObject;
		}else{
			$this->itemList[] = new NetscapeBookmarkItem($titleOrObject,$description,$link);
		}		
	}
}