<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomEntry.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 */
class AtomEntry03 extends AtomEntry{
	var $author = "";
	var $modified = "";
	var $issued = "";
	var $id = "";
	var $created = "";

	function _set($tag){
		parent::_set($tag);

		foreach($tag->getIn("author") as $intag){
			$data = new AtomAuthor();
			$data->set($intag->get());
			$this->setAuthor($data);
		}
		foreach($tag->getIn("modified") as $intag){
			$this->setModified($intag->getValue());
		}
		foreach($tag->getIn("issued") as $intag){
			$this->setIssued($intag->getValue());
		}
		foreach($tag->getIn("id") as $intag){
			$this->setId($intag->getValue());
		}
		foreach($tag->getIn("created") as $intag){
			$this->setCreated($intag->getValue());
		}
	}
	function _get($outTag){
		if(intval($this->modified) > 0){
			$tag		= new SimpleTag("modified",$this->getModified());
			$outTag->addValue($tag->get());
		}
		if(intval($this->issued) > 0){
			$tag		= new SimpleTag("issued",$this->getIssued());
			$outTag->addValue($tag->get());
		}
		if(intval($this->created) > 0){
			$tag		= new SimpleTag("created",$this->getCreated());
			$outTag->addValue($tag->get());
		}
		$tag		= new SimpleTag("id",$this->getId());
		$outTag->addValue($tag->get());

		$data = $this->getAuthor();
		$outTag->addValue($data->get());		

		return parent::_get($outTag);
	}
	function setModified($value){
		$this->modified = DateUtil::parseString($value);
	}
	function getModified(){
		return DateUtil::formatAtom($this->modified);
	}
	function setIssued($value){
		$this->issued = DateUtil::parseString($value);;
	}
	function getIssued(){
		return DateUtil::formatW3C($this->issued);
	}
	function setCreated($value){
		$this->created = DateUtil::parseString($value);
	}
	function getCreated(){
		return DateUtil::formatAtom($this->created);
	}
	function setId($value){
		$this->id = $value;
	}
	function getId(){
		return $this->id;
	}	
	function setAuthor($value){
		$this->author = $value;
	}
	function getAuthor(){
		if(Variable::isClassType(AtomAuthor,$this->author)){
			return $this->author;
		}
		return new AtomAuthor($this->author);
	}
}