<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/NetscapeBookmarkBlock.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/NetscapeBookmarkItem.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class NetscapeBookmark{
	var $title;
	var $header;
	var $block;

	function set($src){
		$tag = new SimpleTag("dummy",$src);

		foreach($tag->getIn("title") as $intag){
			$this->setTitle($intag->getValue());
		}
		foreach($tag->getIn("h1") as $intag){
			$this->setHeader($intag->getValue());
		}
		$this->block = new NetscapeBookmarkBlock();
		$this->block->set($src);
	}
	function get(){
		$src	= "<!DOCTYPE NETSCAPE-Bookmark-file-1>\n";
		$src 	.= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n";
		$tag	= new SimpleTag("title",$this->getTitle());
		$src	.= $tag->get()."\n";
		$tag	= new SimpleTag("h1",$this->getHeader());
		$src	.= $tag->get()."\n";
		$block	= $this->getBlock();
		$src	.= $block->get();
		return $src;
	}
	function output(){
		return StringUtil::encoding($this->get(),StringUtil::getEncodeTypeUTF8());
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setHeader($value){
		$this->header = $value;
	}
	function getHeader(){
		return $this->header;
	}
	function getBlock(){
		if(Variable::isClassType(NetscapeBookmarkBlock,$this->block)){
			return $this->block;
		}
		return new NetscapeBookmarkBlock();
	}
	function setItem($titleOrObject,$description="",$link=""){
		$block = $this->getBlock();
		$block->set($titleOrObject,$description,$link);
		$this->block = $block;
	}
	function getItems(){
		$block	= $this->getBlock();
		return $block->getItems();
	}
}
?>