<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/SimpleTagParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTagParameter.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class SimpleTag{
	var $name			= "";
	var $value			= "";
	var $plain			= "";
	var $parameterList	= array();
	var $attributeList	= array();

	function SimpleTag($name="",$value=""){
		$this->setName($name);
		$this->setValue($value);
	}
	function set($plain,$name=""){
		if(empty($name) && preg_match("/<([\w\d:_-]+)[\s\t\n\r\>]/s",preg_replace("/[\r\n]/","",$plain),$nameList)){
			$name = $nameList[1];
		}
		if(!empty($name)){
			$this->plain		= $plain;
			$this->name		= $name;
			$this->value		= "";
			$this->parameterList	= array();
			$this->attributeList	= array();

			if($this->plain != ""){
				return SimpleTagParser::parse($this);
			}
		}
		return false;
	}
    function get(){
		$parmater   		= "";
		$attribute		= "";
		$tag        		= "";

		foreach($this->getParameter() as $tagParameter){
			if(Variable::isClassType(SimpleTagParameter,$tagParameter)){
                $parmater .= sprintf(" %s=\"%s\"",$tagParameter->getName(),$tagParameter->getValue());
			}
		}
		foreach($this->getAttribute() as $tagAttribute){
			$attribute .= sprintf(" %s",$tagAttribute);
		}
        if($this->getRawValue() != ""){
            $tag .= sprintf("<%s%s%s>",$this->getName(),$parmater,$attribute);
	        $tag .= sprintf("%s",$this->getRawValue());
	        $tag .= sprintf("</%s>",$this->getName());
        }else{
            $tag .= sprintf("<%s%s%s />",$this->getName(),$parmater,$attribute);        
        }
        return $tag;
    }
	function setParameter($tagParameterOrName,$value=""){
		if(!Variable::isClassType(SimpleTagParameter,$tagParameterOrName)){
			$tagParameterOrName = new SimpleTagParameter($tagParameterOrName,$value);
		}
		$this->parameterList[$tagParameterOrName->getId()] = $tagParameterOrName;
	}
	function getParameter($parameterId="",$defaultValue=""){
		if(empty($parameterId)){
			return Variable::toArray($this->parameterList);
		}
		$parameterId = strtolower($parameterId);
		if($this->isParameter($parameterId) && Variable::isClassType(SimpleTagParameter,$this->parameterList[$parameterId])){
			return $this->parameterList[$parameterId]->getValue();
		}
		return $defaultValue;
	}
	function removeParameter($name=""){
		if(empty($name)){
			$this->parameterList = array();
		}else{
			unset($this->parameterList[strtolower($name)]);
		}
	}
	function isParameter($parameterId){
		return isset($this->parameterList[strtolower($parameterId)]);
	}
	function setAttribute($value){
		$this->attributeList[strtolower($value)] = $value;
	}
	function getAttribute($name=""){
		if(empty($name)){
			return Variable::toArray($this->attributeList);
		}
		return $this->attributeList[strtolower($name)];
	}
	function removeAttribute($name=""){
		if(empty($name)){
			$this->attributeList = array();
		}else{
			unset($this->attributeList[strtolower($name)]);
		}
	}
	function isAttribute($name){
		return isset($this->attributeList[strtolower($name)]);
	}
	function addTag($tag){
		if(Variable::isClassType(SimpleTag,$tag)){
			$this->addValue($tag->get());
		}
	}
	function getIn($tagName){
		$tagList = array();

		if(!empty($tagName) && $this->getRawValue() != ""){
			$plain = $this->getRawValue();

			while(true){
				$tag	 = new SimpleTag();

				if(!$tag->set($plain,$tagName)){
					break;
				}
				$tagList[] = $tag;
				$plain = str_replace($tag->getPlain(),"",$plain);
			}
		}
		return $tagList;
	}
	function getValue(){
		if(preg_match("/<!\[CDATA\[(.+)\]\]>/is",$this->value,$match)){
			return $match[1];
		}
		return $this->value;
	}
	function getRawValue(){
		return $this->value;
	}
	function setValue($value){
		if(Variable::isClassType(SimpleTag,$value)){
			$value = $value->get();
		}
		$this->value = $value;
	}
	function addValue($value){
		if(Variable::isClassType(SimpleTag,$value)){
			$value = $value->get();
		}		
		$this->value = $this->value.$value;
	}
	function getName(){
		return $this->name;
	}
	function setName($value){
		$this->name = trim($value);
	}
	function getPlain(){
		return $this->plain;
	}
}
?>