<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class TagUtil{ 
	var $FileUtil	= null;

	function TagUtil(){
		$this->FileUtil = new FileUtil();
	}	
	function select($filename,$conditionsTag,$limit=0,$offset=0){
		if($this->_isFile($filename)){
			$resultTagList	= array();
			$tag	 			= new SimpleTag();
			$count			= 0;
			$limit			= $offset + $limit;
	
			if($tag->set($this->FileUtil->fgets($filename))){
				if(Variable::isClassType(SimpleTag,$conditionsTag)){
					foreach($tag->getIn($conditionsTag->getName()) as $selectTag){
						if($this->_completeValidity($selectTag,$conditionsTag)){
							if($offset <= $count){							
								if($limit > 0 && $limit <= $count){
									break;
								}
								$resultTagList[] = $selectTag;
								$count++;
							}
						}
					}
				}else{
					$resultTagList[] = $tag;
				}
			}
			return $resultTagList;
		}
		return array();
	}
	function count($filename,$conditionsTag=null){
		if($this->_isFile($filename)){		
			$tag		= new SimpleTag();
			$count	= 0;
			
			if($tag->set($this->FileUtil->fgets($filename))){
				if(Variable::isClassType(SimpleTag,$conditionsTag)){
					foreach($tag->getIn($conditionsTag->getName()) as $selectTag){
						if($this->_completeValidity($selectTag,$conditionsTag)){
							$count++;
						}
					}
				}
			}
			return $count;
		}
		return false;
	}
	function get($filename,$conditionsTag=null){
		if($this->_isFile($filename)){	
			list($resultTag) = $this->select($filename,$conditionsTag);

			if(!Variable::isClassType(SimpleTag,$resultTag)){
				return false;
			}
			return $resultTag;
		}
		return false;
	}
	function insert($filename,$insertTag,$conditionsTag=null){
		if($this->_isFile($filename)){
			if(Variable::isClassType(SimpleTag,$insertTag)){
				$src = $this->FileUtil->fgets($filename);

				foreach($this->select($filename,$conditionsTag) as $tag){
					$plain = $tag->getPlain();

					$tag->addValue($insertTag->get());
					$src = str_replace($plain,$tag->get(),$src);
				}
				return $this->FileUtil->fwrite($filename,$src);
			}
		}
		return false;
	}
	function update($filename,$updateTag,$conditionsTag){
		if($this->_isFile($filename) && Variable::isClassType(SimpleTag,$conditionsTag)){
			if(Variable::isClassType(SimpleTag,$updateTag)){
				$src = $this->FileUtil->fgets($filename);
				
				foreach($this->select($filename,$conditionsTag) as $tag){
					$src = str_replace($tag->getPlain(),$updateTag->get(),$src);
				}
				return $this->FileUtil->fwrite($filename,$src);
			}
		}
		return false;
	}
	function delete($filename,$conditionsTag){
		if($this->_isFile($filename) && Variable::isClassType(SimpleTag,$conditionsTag)){
			$src = $this->FileUtil->fgets($filename);
			
			foreach($this->select($filename,$conditionsTag) as $tag){
				$src = str_replace($tag->getPlain(),"",$src);
			}
			return $this->FileUtil->fwrite($filename,$src);
		}
		return false;
	}
	function setTransaction($bool){
		$this->FileUtil->setTransaction($bool);
	}
	function commit($filename){
		return $this->FileUtil->commit($filename);
	}
	function rollback($filename){
		$this->FileUtil->rollback($filename);
	}
	function close($filename){
		$this->FileUtil->close($filename);
	}
	function getIn($tag,$conditionsTag){
		$tagList = array();

		if(Variable::isClassType(SimpleTag,$tag) && Variable::isClassType(SimpleTag,$conditionsTag) && $tag->getRawValue() != ""){
			$plain	= $tag->getRawValue();

			while(true){
				$tmptag	= new SimpleTag();

				if($tmptag->set($plain,$conditionsTag->getName())){
					if($this->_validity($tmptag,$conditionsTag)){
						$tagList[] = $tmptag;
					}
					$plain = str_replace($tmptag->getPlain(),"",$plain);
				}else{
					break;
				}
			}
		}
		return $tagList;
	}
	function getNotIn($tag,$conditionsTag){
		$tagList = array();

		if(Variable::isClassType(SimpleTag,$tag) && Variable::isClassType(SimpleTag,$conditionsTag) && $tag->getRawValue() != ""){
			$plain	= $tag->getRawValue();

			while(true){
				$tmptag	= new SimpleTag();

				if($tmptag->set($plain,$conditionsTag->getName())){
					if(!$this->_validity($tmptag,$conditionsTag)){
						$tagList[] = $tmptag;
					}
					$plain = str_replace($tmptag->getPlain(),"",$plain);
				}else{
					break;
				}
			}
		}
		return $tagList;
	}
	function isTagfile($filename,$tagname,$create=false){
		$tag	 = new SimpleTag();		
		
		if($tag->set($this->FileUtil->fgets($filename),$tagname)){
			if(preg_match("/".$tag->getName()."/i",$tagname)){
				return true;
			}
		}else if(Variable::getBoolean($create)){
			$newTag = new SimpleTag($tagname);
			return $this->FileUtil->fputs($filename,$newTag->get());
		}
		return false;
	}
	function sort($tagList,$orderNameArray,$limit=0,$offset=0){
		$tagList = $this->_keyset($tagList,$orderNameArray);
		ksort($tagList);

		return $this->_sort($tagList,$offset,$limit);
	}
	function rsort($tagList,$orderNameArray,$limit=0,$offset=0){
		$tagList = $this->_keyset($tagList,$orderNameArray);
		krsort($tagList);

		return $this->_sort($tagList,$offset,$limit);
	}
	function toObject($tag,$object){
		$hash = array();

		if(Variable::isClassType(SimpleTag,$tag)){				
			foreach($tag->getParameter() as $parameter){
				$hash[$parameter->getId()] = $parameter->getValue();
			}
			return Variable::hashConvObject($hash,$object);
		}
		return $object;
	}
	
	function _completeValidity($tag,$conditionsTag){
		if($this->_validity($tag,$conditionsTag)){
			$nextTargetTag	= new SimpleTag();
			$nextTag			= new SimpleTag();

			if($nextTargetTag->set($conditionsTag->getValue())){
				foreach($tag->getIn($nextTargetTag->getName()) as $nextTag){
					if($this->_completeValidity($nextTag,$nextTargetTag)){
						return true;
					}
				}
				return false;
			}
			return true;
		}
		return false;
	}
	function _validity($tag,$conditionsTag){
		if(strtolower($tag->getName()) != strtolower($conditionsTag->getName())){
			return false;
		}
		foreach($conditionsTag->getParameter() as $parameterId => $param){
			if(!($tag->isParameter($parameterId) &&
				preg_match("/^".$param->getValue()."$/",$tag->getParameter($parameterId))
			)){
				return false;
			}
		}
		foreach($conditionsTag->getAttribute() as $attributeId => $attribute){
			if(!($tag->isAttribute($attributeId) &&
				preg_match("/^".$attribute."$/",$tag->getAttribute($attributeId))
			)){
				return false;
			}
		}
		$conditionsTagValue = trim(str_replace("\n","",str_replace("\r","",$conditionsTag->getValue())));
		if(!empty($conditionsTagValue)){
			$tagValue = trim(str_replace("\n"," ",str_replace("\r"," ",$tag->getValue())));
			if(empty($tagValue) || (!empty($tagValue) && !preg_match("/^".$conditionsTagValue."$/i",$tagValue))){
				return false;
			}
		}
		return true;
	}	
	function _sort($tagList,$offset,$limit){
		$count	= 0;
		$limit	= $offset + $limit;

		if($limit > 0){
			$list = array();
			
			foreach($tagList as $tag){
				if($offset <= $count && $limit >= $count){
					$list[] = $tag;
				}
				$count++;
			}
			$tagList = $list;
		}
		return $tagList;
	}	
	function _keyset($tagList,$orderNameArray){
		if(is_array($tagList)){
			$resultTagList	= array();
			$nameList		= array();
			$nameSizeList	= array();
			$format			= array();
			$tagSize			= sizeof(strval($tagList));
	
			if(!is_array($orderNameArray)){
				$orderNameArray = array($orderNameArray);
			}
			foreach($tagList as $id => $tag){
				foreach($orderNameArray as $name){
					if(!isset($nameSizeList[$name])){
						$nameSizeList[$name] = 0;
					}
					$param = $tag->getParameter($name);
	
					$nameList[$id][$name] = $param;
	
					if(strlen($param) > $nameSizeList[$name]){
						$nameSizeList[$name] = strlen($param);
						$format[$name] = sprintf("%%'_-%ds%%0%dd",$nameSizeList[$name],$tagSize);
					}
				}
			}
			foreach($nameList as $id => $idList){
				$argName = "";
	
				foreach($idList as $name => $param){
					$argName .= sprintf($format[$name],$param,$id);
				}
				$resultTagList[$argName] = $tagList[$id];
			}
			return $resultTagList;
		}
		return array();
	}
	function _isFile($filename){
		if(!empty($filename) && $this->FileUtil->exist($filename)){
			return true;
		}
		return false;
	}
}
?>