<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class ColumnModel{
	var $name;
	var $type;
	var $primary;
	var $unique;
	var $size;
	var $default;
	var $require;
	var $variable;
	var $serial;
	var $method;

	function formatset(){
		if($this->isTypeEmail()){
			$this->size = 255;
		}else if($this->isTypeInteger()){
			if(empty($this->size)){
				$this->size = 22;
			}
			if($this->type == "SERIAL"){
				$this->primary = true;
			}
		}else if($this->isTypeZip()){
			$this->size = 8;
		}else if($this->isTypeTel()){
			$this->size = 13;
		}
		if($this->default == "null"){
			$this->default = "";
		}
	}
	function isTypeString(){
		if(($this->type == "TEXT" || $this->type == "STRING" || 
			$this->type == "EMAIL" || $this->type == "TEL" || 
			$this->type == "ZIP") && 
			$this->size > 0
		){
			return true;
		}
		return false;
	}
	function isTypeEmail(){
		if($this->type == "EMAIL"){
			return true;
		}
		return false;
	}
	function isTypeZip(){
		if($this->type == "ZIP"){
			return true;
		}
		return false;
	}
	function isTypeTel(){
		if($this->type == "TEL"){
			return true;
		}
		return false;
	}
	function isTypeInteger(){
		if($this->type == "INTEGER" || $this->type == "SERIAL" || $this->type == "TIME"){
			return true;
		}
		return false;
	}
	function isTypeTimestamp(){
		if($this->type == "TIMESTAMP"){
			return true;
		}
		return false;
	}
	function isTypeDate(){
		if($this->type == "DATE"){
			return true;
		}
		return false;
	}
	function isAlpha(){
		if($this->type == "EMAIL" || $this->type == "TEL" || $this->type == "ZIP"){
			return true;
		}
		return false;
	}
	function isBool(){
		if($this->type == "BOOLEAN"){
			return true;
		}
		return false;
	}
	function getDefault(){
		switch($this->type){
			case "INTEGER":
			case "SERIAL":
			case "TIME":			
				return sprintf("%d",$this->default);
			case "FLOAT":
				return sprintf("%f",$this->default);
			case "BOOLEAN":
				return intval(Variable::getBoolean($this->default));
			case "STRING":
			case "TEXT":
			case "EMAIL":
			case "TEL":
			case "ZIP":
				if($this->default != ""){
					return sprintf("\"%s\"",$this->default);
				}
				break;
			case "TIMESTAMP":
			case "DATE":			
				if($this->default != ""){
					if(preg_match("/sysdate/i",$this->default)){
						return "time()";
					}
					return DateUtil::format($value);
				}
		}
		return "null";
	}
}
?>